/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.issue.TestXmlCustomIssueView;
import electric.xml.Document;
import org.apache.commons.lang3.StringEscapeUtils;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestSearchXmlCustomIssueView
extends TestXmlCustomIssueView {
    public TestSearchXmlCustomIssueView(String name) {
        super(name);
    }

    @Override
    protected String getHSP1ViewPage(String fieldParam) {
        return "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?pid=10000&resolution=1&sorter/field=issuekey&sorter/order=ASC&tempMax=1000&" + fieldParam;
    }

    @Override
    protected String getHSP2ViewPage(String fieldParam) {
        return "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?type=1&pid=10000&resolution=-1&sorter/field=issuekey&sorter/order=ASC&tempMax=1000&" + fieldParam;
    }

    @Override
    protected String getHSP3ViewPage(String fieldParam) {
        return "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?type=5&pid=10000&sorter/field=issuekey&sorter/order=ASC&tempMax=1000&" + fieldParam;
    }

    public void testXMLCommentsOfResults() throws Exception {
        this.restoreData("TestXMLIssueCustomView.xml");
        this._testXMLCommentOfResults(this.getHSP1ViewPage(""));
        this._testXMLCommentOfResults(this.getHSP1ViewPage("blah=value"));
        this._testXMLCommentOfResults("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml");
    }

    public void _testXMLCommentOfResults(String url) throws Exception {
        this.gotoPage(url);
        TestSearchXmlCustomIssueView.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        TestSearchXmlCustomIssueView.log("Checking the contents of the XML comment of the XML resulsts");
        Node commentNode = doc.getFirstChild();
        TestSearchXmlCustomIssueView.assertNotNull((Object)commentNode);
        TestSearchXmlCustomIssueView.assertEquals((short)8, (short)commentNode.getNodeType());
        String commentText = commentNode.getNodeValue();
        TestSearchXmlCustomIssueView.assertNotNull((Object)commentText);
        TestSearchXmlCustomIssueView.assertTrue((commentText.indexOf("RSS generated by JIRA") > -1 ? 1 : 0) != 0);
        TestSearchXmlCustomIssueView.assertTrue((commentText.indexOf("It is possible to restrict the fields that are returned in this document by specifying the 'field' parameter in your request.\nFor example, to request only the issue key and summary add field=key&field=summary to the URL of your request.") > -1 ? 1 : 0) != 0);
        String expectedUrl = this.getEnvironmentData().getBaseUrl() + url;
        expectedUrl = expectedUrl.indexOf("?") > -1 ? expectedUrl + (expectedUrl.endsWith("&") ? "" : "&") + "field=key&field=summary" : expectedUrl + "?field=key&field=summary";
        TestSearchXmlCustomIssueView.assertTrue((commentText.indexOf(StringEscapeUtils.escapeXml((String)expectedUrl)) > -1 ? 1 : 0) != 0);
    }
}

