/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestOpsBarStructure
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestOpsBar.xml");
    }

    public void testWorkflows() {
        this.navigation.issue().viewIssue("HSP-1");
        this.assertExtraTransitionsExist();
        this.navigation.issue().viewIssue("HSP-2");
        if (this.referencePluginEnabled()) {
            this.assertOnlyReferenceTransitionExists();
        } else {
            this.assertOnlyStandardTransitions();
        }
        this.navigation.issue().viewIssue("HSP-3");
        if (this.referencePluginEnabled()) {
            this.assertOnlyReferenceTransitionExists();
        } else {
            this.assertOnlyStandardTransitions();
        }
        this.navigation.issue().viewIssue("HSP-4");
        if (this.referencePluginEnabled()) {
            this.assertOnlyReferenceTransitionExists();
        } else {
            this.assertNoTransitions();
        }
    }

    private boolean referencePluginEnabled() {
        return new XPathLocator(this.tester, "//a[@id='reference-operation']").exists();
    }

    private void assertNoTransitions() {
        this.assertions.assertNodeDoesNotExist("//span[@id='opsbar-transitions_more']");
        this.assertions.assertNodeDoesNotExist("//a[@id='opsbar-transitions_more']");
    }

    private void assertOnlyStandardTransitions() {
        this.assertions.assertNodeExists("//span[@id='opsbar-transitions_more']");
        this.assertions.assertNodeDoesNotExist("//a[@id='opsbar-transitions_more']");
    }

    private void assertExtraTransitionsExist() {
        this.assertions.assertNodeDoesNotExist("//span[@id='opsbar-transitions_more']");
        this.assertions.assertNodeExists("//a[@id='opsbar-transitions_more']");
    }

    private void assertOnlyReferenceTransitionExists() {
        this.assertions.assertNodeExists(new CssLocator(this.tester, "ul.aui-list-section > li > #reference-operation"));
    }

    public void testConjoined() {
        this.navigation.issue().viewIssue("HSP-5");
        String editGroup = "//div[@class='ops-menus aui-toolbar']/div/ul[1]";
        this.assertions.assertNodeHasText(editGroup + "/li[1]", "Edit");
        String commentGroup = "//div[@class='ops-menus aui-toolbar']/div/ul[2]";
        this.assertions.assertNodeHasText(commentGroup + "/li[1]", "Comment");
        String operationsGroup = "//div[@class='ops-menus aui-toolbar']/div/ul[3]";
        this.assertions.assertNodeHasText(operationsGroup + "/li[1]", "Assign");
        this.assertions.assertNodeDoesNotHaveText(operationsGroup + "/li[1]", "More");
        this.assertions.assertNodeByIdExists("opsbar-operations_more");
    }

    public void testLoginButton() {
        this.navigation.logout();
        this.navigation.issue().viewIssue("ANONED-1");
        IdLocator locator = new IdLocator(this.tester, "ops-login-lnk");
        TestOpsBarStructure.assertEquals((int)0, (int)locator.getNodes().length);
        this.navigation.issue().viewIssue("ANON-1");
        locator = new IdLocator(this.tester, "ops-login-lnk");
        TestOpsBarStructure.assertEquals((int)1, (int)locator.getNodes().length);
        this.tester.clickLink("ops-login-lnk");
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        this.text.assertTextPresent(new CssLocator(this.tester, "#content header h1"), "Anon viewable issue");
        locator = new IdLocator(this.tester, "ops-login-lnk");
        TestOpsBarStructure.assertEquals((int)0, (int)locator.getNodes().length);
    }

    public void testOpsbarTransitionOrder() {
        String workflowName = "Copy of jira";
        this.administration.restoreData("TestOpsbarTransitionOrder.xml");
        this.navigation.issue().viewIssue("HSP-1");
        String operationsGroup = "//div[@class='ops-menus aui-toolbar']/div/ul[4]";
        String[] originalOrder = new String[]{"Start Progress", "Resolve Issue", "Close Issue"};
        String[] newOrder = new String[]{"Close Issue", "Resolve Issue", "Start Progress"};
        this.assertTransitionOrder("//div[@class='ops-menus aui-toolbar']/div/ul[4]", originalOrder);
        this.administration.workflows().goTo().createDraft("Copy of jira");
        this.backdoor.workflow().setTransitionProperty("Copy of jira", true, 4L, "opsbar-sequence", 100);
        this.backdoor.workflow().setTransitionProperty("Copy of jira", true, 2L, "opsbar-sequence", 20);
        this.administration.workflows().goTo().publishDraft("Copy of jira").publish();
        this.navigation.issue().viewIssue("HSP-1");
        this.assertTransitionOrder("//div[@class='ops-menus aui-toolbar']/div/ul[4]", newOrder);
    }

    private void assertTransitionOrder(String operationsGroup, String[] expectedText) {
        this.assertions.getTextAssertions().assertTextSequence(new XPathLocator(this.tester, operationsGroup), expectedText);
    }
}

