/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR})
public class TestNextPreviousPager
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("BigIssueSet.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    public void testAlwaysGreen() {
    }

    private void assertPagerListForwards(String filterName, String ... keys) {
        int i;
        this.navigation.issue().viewIssue(keys[0]);
        for (i = 0; i < keys.length; ++i) {
            this.assertPager(keys[i], filterName, keys.length, i + 1);
            if (i == keys.length - 1) continue;
            this.tester.clickLink("next-issue");
        }
        for (i = keys.length; i > 0; --i) {
            this.assertPager(keys[i - 1], filterName, keys.length, i);
            if (i == 1) continue;
            this.tester.clickLink("previous-issue");
        }
    }

    private void assertPagerListBackwards(String filterName, String ... keys) {
        int i;
        this.navigation.issue().viewIssue(keys[keys.length - 1]);
        for (i = keys.length; i > 0; --i) {
            this.assertPager(keys[i - 1], filterName, keys.length, i);
            if (i == 1) continue;
            this.tester.clickLink("previous-issue");
        }
        for (i = 0; i < keys.length; ++i) {
            this.assertPager(keys[i], filterName, keys.length, i + 1);
            if (i == keys.length - 1) continue;
            this.tester.clickLink("next-issue");
        }
    }

    private void assertPager(String key, String filter, int total, int position) {
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.text.assertTextPresent(locator, "Test issue " + key);
        this.tester.assertLinkPresent("return-to-search");
        if (position == 1) {
            this.tester.assertLinkNotPresent("previous-issue");
        } else {
            this.text.assertTextSequence(locator, "Previous Issue", position + " of " + total);
            this.tester.assertLinkPresent("previous-issue");
        }
        if (position == total) {
            this.tester.assertLinkNotPresent("next-issue");
        } else {
            this.text.assertTextSequence(locator, position + " of " + total, "Next Issue");
            this.tester.assertLinkPresent("next-issue");
        }
    }
}

