/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestLinkIssue
extends JIRAWebTest {
    private static final String DELETE_LINK_TEXT = "Delete this link";

    public TestLinkIssue(String name) {
        super(name);
    }

    @Override
    public void tearDown() {
        this.administration.issueLinking().disable();
        super.tearDown();
    }

    public void testLinkIssue() {
        this.administration.restoreBlankInstance();
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.administration.issueLinking().enable();
        this.administration.subtasks().enable();
        TestLinkIssue.assertFalse((boolean)this.administration.issueLinking().exists("jira_subtask_link"));
        if (this.administration.issueLinking().exists("Duplicate")) {
            this.administration.issueLinking().delete("Duplicate");
        }
        if (this.administration.issueLinking().exists("Cloners")) {
            this.administration.issueLinking().delete("Cloners");
        }
        if (this.administration.issueLinking().exists("related")) {
            this.administration.issueLinking().delete("related");
        }
        this.administration.issueLinking().disable();
        String issueKey1 = this.navigation.issue().createIssue("homosapien", "Bug", "test 1");
        String issueKey2 = this.navigation.issue().createIssue("homosapien", "Bug", "test 1");
        this.availabilityOfIssueLinkLink(issueKey1);
        this.linkingIssue(issueKey1, issueKey2);
        this.assertSubTaskLinkNotPresentOn(issueKey1);
        this.duplicateIssueLinkTypeNameError();
        this.notFoundNotDoubleescapedIssueLinkError();
        this.issueOperationForCloningWithIssueLinking(issueKey1);
        this.cancelLinkDeletion();
        this.confirmLinkDeletion();
        this.navigation.issue().deleteIssue(issueKey1);
        this.navigation.issue().deleteIssue(issueKey2);
        this.administration.issueLinking().enable();
        this.administration.issueLinking().delete("Duplicate");
        this.administration.issueLinking().delete("Cloners");
        this.administration.issueLinking().delete("related");
        this.administration.issueLinking().disable();
    }

    public void availabilityOfIssueLinkLink(String issueKey) {
        TestLinkIssue.log("Link Issue: test for availability of 'link issue' link");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkNotPresent("link-issue");
        this.administration.issueLinking().enable();
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkPresent("link-issue");
        this.administration.issueLinking().disable();
        this.administration.issueLinking().enable();
        this.administration.issueLinking().addIssueLink("Duplicate", "is a duplicate of", "duplicates");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkPresent("link-issue");
        this.administration.issueLinking().disable();
    }

    public void linkingIssue(String issueKey1, String issueKey2) {
        TestLinkIssue.log("Link Issue: test linking an issue");
        this.administration.issueLinking().enable();
        this.navigation.issue().gotoIssue(issueKey1);
        this.linkIssueWithComment("HSP-1", "duplicates", "HSP-2", null, null);
        this.text.assertTextPresent(this.locator.page(), issueKey2);
        this.administration.issueLinking().disable();
    }

    public void assertSubTaskLinkNotPresentOn(String issueKey) {
        TestLinkIssue.log("Link Issue: test that the subtask links are not present when linking an issue");
        this.administration.issueLinking().enable();
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("link-issue");
        this.tester.assertRadioOptionValueNotPresent("linkDesc", "jira_subtask_outward");
        this.tester.assertRadioOptionValueNotPresent("linkDesc", "jira_subtask_inward");
        this.tester.assertRadioOptionLabelNotPresent("linkDesc", "jira_subtask_outward");
        this.tester.assertRadioOptionLabelNotPresent("linkDesc", "jira_subtask_inward");
        this.administration.issueLinking().disable();
    }

    public void duplicateIssueLinkTypeNameError() {
        TestLinkIssue.log("Link Issue: test attempting to add duplicate link type name");
        this.administration.issueLinking().enable();
        this.tester.setFormElement("name", "Duplicate");
        this.tester.setFormElement("outward", "is a duplicate of");
        this.tester.setFormElement("inward", "duplicates");
        this.tester.submit();
        this.text.assertTextPresent(this.locator.page(), "Another link type with that name already exists");
        this.administration.issueLinking().disable();
    }

    public void notFoundNotDoubleescapedIssueLinkError() {
        TestLinkIssue.log("Link Issue: test attempting to link an invalid issue using an HTML string");
        this.administration.issueLinking().enable();
        this.linkIssueWithComment("HSP-1", "duplicates", "<b>BOLD</b>", null, null, "The issue key &quot;&lt;b&gt;BOLD&lt;/b&gt;&quot; does not exist.");
        this.administration.issueLinking().disable();
    }

    public void issueOperationForCloningWithIssueLinking(String issueKey) {
        TestLinkIssue.log("Issue Operation: Test the ability to automatically link the clone to its parent");
        this.administration.issueLinking().enable();
        this.administration.issueLinking().addIssueLink("Cloners", "clones", "is cloned by");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLinkWithText("Clone");
        this.tester.setFormElement("summary", "Second Clone of Test 1");
        this.tester.submit();
        this.text.assertTextPresent(this.locator.page(), "Second Clone of Test 1");
        this.text.assertTextPresent(this.locator.page(), "Issue Links");
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
        this.administration.issueLinking().disable();
    }

    public void cancelLinkDeletion() {
        TestLinkIssue.log("Testing cancel option of delete link wizard");
        String issueKey1 = this.navigation.issue().createIssue("homosapien", "Bug", "test issue 1");
        String issueKey2 = this.navigation.issue().createIssue("homosapien", "Bug", "test issue 2");
        this.administration.issueLinking().enable();
        this.gotoLinkDeleteConfirmationScreen(issueKey1, issueKey2);
        this.tester.clickLink("issue-link-delete-cancel");
        this.text.assertTextPresent(this.locator.page(), issueKey1);
        this.text.assertTextPresent(this.locator.page(), "test issue 1");
        this.navigation.issue().deleteIssue(issueKey1);
        this.navigation.issue().deleteIssue(issueKey2);
        this.administration.issueLinking().disable();
    }

    public void testVisibilityOfDeleteIssueLink() throws SAXException {
        this.administration.restoreBlankInstance();
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.administration.issueLinking().enable();
        this.administration.issueLinking().addIssueLink("Duplicate", "is a duplicate of", "duplicates");
        String issueKey1 = this.navigation.issue().createIssue("homosapien", "Bug", "test 1");
        String issueKey2 = this.navigation.issue().createIssue("homosapien", "Bug", "test 1");
        this.linkingIssue(issueKey1, issueKey2);
        this.administration.issueLinking().enable();
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue(issueKey1);
        this.tester.assertLinkPresent("delete-link_internal-10001_10000");
        this.administration.permissionSchemes().defaultScheme().removePermission(ProjectPermissions.LINK_ISSUES, "jira-users");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(issueKey1);
        this.tester.assertLinkNotPresent("delete-link_internal-10001_10000");
        this.tester.gotoPage("/secure/DeleteLink.jspa?id=10000&sourceId=10001&linkType=10000&atl_token=" + this.page.getXsrfToken());
        this.text.assertTextPresent(this.locator.page(), "You do not have permission to delete links in this project.");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.LINK_ISSUES, "jira-users");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(issueKey1);
        this.tester.assertLinkPresent("delete-link_internal-10001_10000");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.administration.permissionSchemes().defaultScheme().removePermission(ProjectPermissions.LINK_ISSUES, "jira-users");
        this.navigation.issue().deleteIssue(issueKey1);
        this.navigation.issue().deleteIssue(issueKey2);
        this.administration.issueLinking().disable();
    }

    public void confirmLinkDeletion() {
        TestLinkIssue.log("Testing confirm option of delete link wizard");
        String issueKey1 = this.navigation.issue().createIssue("homosapien", "Bug", "test 1");
        String issueKey2 = this.navigation.issue().createIssue("homosapien", "Bug", "test 1");
        this.administration.issueLinking().enable();
        this.gotoLinkDeleteConfirmationScreen(issueKey1, issueKey2);
        this.tester.submit("Delete");
        this.text.assertTextPresent(this.locator.page(), issueKey1);
        this.text.assertTextNotPresent(this.locator.page(), "relates to");
        this.navigation.issue().deleteIssue(issueKey1);
        this.navigation.issue().deleteIssue(issueKey2);
        this.administration.issueLinking().disable();
    }

    public void testLinkComment() {
        this.administration.restoreData("TestBlankInstancePlusAFewUsers.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.administration.issueLinking().enable();
        this.administration.issueLinking().addIssueLink("duplicates", "duplicates", "is duplicated by");
        this.administration.issueLinking().addIssueLink("resembles", "resembles", "is resembled by");
        this.administration.issueLinking().addIssueLink("jokingly duplicates", "jokingly duplicates", "is jokingly duplicated by");
        this.administration.issueLinking().addIssueLink("similar", "similar to", "is similar to");
        this.administration.issueLinking().addIssueLink("duplicates", "duplicates", "is duplicated by");
        String issueKey1 = this.navigation.issue().createIssue("homosapien", "Test Bug", "Bug1");
        String issueKey2 = this.navigation.issue().createIssue("homosapien", "Test Bug", "Bug2");
        String issueKey3 = this.navigation.issue().createIssue("homosapien", "Test Bug", "Bug3");
        String issueKey4 = this.navigation.issue().createIssue("homosapien", "Test Bug", "Bug4");
        String issueKey5 = this.navigation.issue().createIssue("homosapien", "Test Bug", "Bug5");
        String issueKey6 = this.navigation.issue().createIssue("homosapien", "Test Bug", "Bug6");
        String commentJiraUsers1 = "comment visible to jira-users";
        String commentJiraUsers2 = "comment visible to All Users";
        String commentAdmins1 = "comment visible to jira-administrators";
        String commentAdmins2 = "comment visible to Administrators";
        String commentDev1 = "comment visible to jira-developers";
        String commentDev2 = "comment visible to Developers";
        ImmutableList jiraUserComments = ImmutableList.of((Object)"comment visible to jira-users", (Object)"comment visible to All Users");
        ImmutableList jiraAdminComments = ImmutableList.of((Object)"comment visible to jira-administrators", (Object)"comment visible to Administrators");
        ImmutableList jiraDevComments = ImmutableList.of((Object)"comment visible to jira-developers", (Object)"comment visible to Developers");
        this.administration.issueLinking().enable();
        this.linkIssueWithComment(issueKey1, "duplicates", issueKey2, "comment visible to jira-users", "group:jira-users");
        this.linkIssueWithComment(issueKey1, "resembles", issueKey3, "comment visible to jira-administrators", "group:jira-administrators");
        this.linkIssueWithComment(issueKey1, "duplicates", issueKey4, "comment visible to jira-developers", "group:jira-developers");
        this.linkIssueWithComment(issueKey1, "duplicates", issueKey5, "comment visible to All Users", "role:10000");
        this.linkIssueWithComment(issueKey1, "duplicates", issueKey6, "comment visible to Developers", "role:10001");
        this.linkIssueWithComment(issueKey1, "duplicates", issueKey6, "comment visible to Administrators", "role:10002");
        this.assertions.comments((Iterable<String>)jiraUserComments).areVisibleTo("fred", issueKey1);
        this.assertions.comments(Iterables.concat((Iterable)jiraAdminComments, (Iterable)jiraDevComments)).areNotVisibleTo("fred", issueKey1);
        this.assertions.comments(Iterables.concat((Iterable)jiraUserComments, (Iterable)jiraDevComments)).areVisibleTo("devman", issueKey1);
        this.assertions.comments((Iterable<String>)jiraAdminComments).areNotVisibleTo("devman", issueKey1);
        this.assertions.comments(Iterables.concat((Iterable)jiraUserComments, (Iterable)jiraAdminComments)).areVisibleTo("onlyadmin", issueKey1);
        this.assertions.comments((Iterable<String>)jiraDevComments).areNotVisibleTo("onlyadmin", issueKey1);
        this.assertions.comments(Iterables.concat((Iterable)jiraUserComments, (Iterable)jiraAdminComments, (Iterable)jiraDevComments)).areVisibleTo("admin", issueKey1);
    }

    public void testChangeHistoryShowsHyperlinkCorrectly() {
        this.administration.restoreData("TestLinkIssueChangeHistoryShowsHyperlink.xml");
        this.navigation.logout();
        this.navigation.login("fred");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLinkWithText("History");
        this.text.assertTextPresent(this.locator.page(), "MKY-1");
        this.tester.assertLinkNotPresentWithText("MKY-1");
        this.text.assertTextPresent(this.locator.page(), "HSP-2");
        this.tester.assertLinkNotPresentWithText("HSP-2");
        this.navigation.logout();
        this.navigation.login("admin");
        Long projectId = this.backdoor.project().getProjectId("MKY");
        this.tester.gotoPage("/secure/project/SelectProjectPermissionScheme!default.jspa?projectId=" + projectId);
        this.tester.selectOption("schemeIds", "Default Permission Scheme");
        this.tester.submit("Associate");
        this.navigation.issue().gotoIssue("HSP-2");
        this.tester.clickLink("edit-issue");
        this.tester.selectOption("security", "None");
        this.tester.submit("Update");
        this.navigation.logout();
        this.navigation.login("fred");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLinkWithText("History");
        this.text.assertTextPresent(this.locator.page(), "MKY-1");
        this.tester.assertLinkPresentWithText("MKY-1");
        this.text.assertTextPresent(this.locator.page(), "HSP-2");
        this.tester.assertLinkPresentWithText("HSP-2");
        this.navigation.logout();
        this.navigation.login("admin");
        this.navigation.issue().deleteIssue("HSP-2");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLinkWithText("History");
        this.text.assertTextPresent(this.locator.page(), "HSP-2");
        this.tester.assertLinkNotPresentWithText("HSP-2");
    }

    private void gotoLinkDeleteConfirmationScreen(String issueKey1, String issueKey2) {
        this.navigation.issue().gotoIssue(issueKey1);
        String linkTypeId = this.createIssueLinkType("related", "is related to", "relates to");
        String destId = this.navigation.issue().getId(issueKey2);
        this.linkIssueWithComment(issueKey1, "relates to", issueKey2, null, null);
        this.administration.issueLinking().enable();
        this.navigation.issue().gotoIssue(issueKey1);
        this.tester.clickLink("delete-link_internal-" + destId + "_" + linkTypeId);
        this.text.assertTextSequence(this.locator.page(), "Delete Link: ", issueKey1 + " relates to " + issueKey2);
    }
}

