/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestIssueViews
extends JIRAWebTest {
    private String exportsContent;

    public TestIssueViews(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueViews.xml");
    }

    public void testViewLinksChangeForModifiedFilter() {
        this.getViewsOption(null, "10000", null);
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-xml/10000/SearchRequest-10000.xml");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-rss/10000/SearchRequest-10000.xml");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-comments-rss/10000/SearchRequest-10000.xml");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-printable/10000/SearchRequest-10000.html");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-word/10000/SearchRequest-10000.doc");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-fullcontent/10000/SearchRequest-10000.html");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-excel-current-fields/10000/SearchRequest-10000.xls");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-rss/temp/SearchRequest.xml?");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.xml?");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-word/temp/SearchRequest.xml?");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-fullcontent/temp/SearchRequest.xml?");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-excel-current-fields/temp/SearchRequest.xml?");
        this.getViewsOption("ORDER BY key DESC", "10000", "true");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-xml/10000/SearchRequest-10000.xml");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-rss/10000/SearchRequest-10000.xml");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-comments-rss/10000/SearchRequest-10000.xml");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-printable/10000/SearchRequest-10000.html");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-word/10000/SearchRequest-10000.doc");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-fullcontent/10000/SearchRequest-10000.html");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-excel-current-fields/10000/SearchRequest-10000.xls");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-rss/temp/SearchRequest.xml?");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-word/temp/SearchRequest.doc?");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-fullcontent/temp/SearchRequest.html?");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-excel-current-fields/temp/SearchRequest.xls?");
    }

    public void testPermissionErrorWithGzipEnabled() {
        this.getAdministration().generalConfiguration().turnOnGZipCompression();
        this.getNavigation().issue().viewIssue("HSP-1");
        this.getNavigation().logout();
        this.getNavigation().gotoPage("/si/jira.issueviews:issue-html/HSP-1/HSP-1.html");
        this.assertTextPresent("You must log in to access this page.");
    }

    public void testEnableDisableIssueViewsPlugin() {
        this.getViewsOption();
        this.assertViewsLinkPresent("printable");
        this.assertViewsLinkPresent("fullContent");
        this.assertViewsLinkPresent("xml");
        this.assertViewsLinkPresent("rssIssues");
        this.assertViewsLinkPresent("rssComments");
        this.assertViewsLinkPresent("word");
        this.assertViewsLinkPresent("allExcelFields");
        this.assertViewsLinkPresent("currentExcelFields");
        this.togglePluginModule(false, "printable");
        this.getViewsOption();
        this.assertViewsLinkNotPresent("printable");
        this.assertViewsLinkPresent("fullContent");
        this.assertViewsLinkPresent("xml");
        this.assertViewsLinkPresent("rssIssues");
        this.assertViewsLinkPresent("rssComments");
        this.assertViewsLinkPresent("word");
        this.assertViewsLinkPresent("allExcelFields");
        this.assertViewsLinkPresent("currentExcelFields");
        this.togglePluginModule(true, "printable");
        this.togglePluginModule(false, "fullcontent");
        this.getViewsOption();
        this.assertViewsLinkPresent("printable");
        this.assertViewsLinkNotPresent("fullContent");
        this.assertViewsLinkPresent("xml");
        this.assertViewsLinkPresent("rssIssues");
        this.assertViewsLinkPresent("rssComments");
        this.assertViewsLinkPresent("word");
        this.assertViewsLinkPresent("allExcelFields");
        this.assertViewsLinkPresent("currentExcelFields");
        this.togglePluginModule(true, "fullcontent");
        this.togglePluginModule(false, "xml");
        this.getViewsOption();
        this.assertViewsLinkPresent("printable");
        this.assertViewsLinkPresent("fullContent");
        this.assertViewsLinkNotPresent("xml");
        this.assertViewsLinkPresent("rssIssues");
        this.assertViewsLinkPresent("rssComments");
        this.assertViewsLinkPresent("word");
        this.assertViewsLinkPresent("allExcelFields");
        this.assertViewsLinkPresent("currentExcelFields");
        this.togglePluginModule(true, "xml");
        this.togglePluginModule(false, "rss");
        this.getViewsOption();
        this.assertViewsLinkPresent("printable");
        this.assertViewsLinkPresent("fullContent");
        this.assertViewsLinkPresent("xml");
        this.assertViewsLinkNotPresent("rssIssues");
        this.assertViewsLinkPresent("rssComments");
        this.assertViewsLinkPresent("word");
        this.assertViewsLinkPresent("allExcelFields");
        this.assertViewsLinkPresent("currentExcelFields");
        this.togglePluginModule(true, "rss");
        this.togglePluginModule(false, "comments-rss");
        this.getViewsOption();
        this.assertViewsLinkPresent("printable");
        this.assertViewsLinkPresent("fullContent");
        this.assertViewsLinkPresent("xml");
        this.assertViewsLinkPresent("rssIssues");
        this.assertViewsLinkNotPresent("rssComments");
        this.assertViewsLinkPresent("word");
        this.assertViewsLinkPresent("allExcelFields");
        this.assertViewsLinkPresent("currentExcelFields");
        this.togglePluginModule(true, "comments-rss");
        this.togglePluginModule(false, "word");
        this.getViewsOption();
        this.assertViewsLinkPresent("printable");
        this.assertViewsLinkPresent("fullContent");
        this.assertViewsLinkPresent("xml");
        this.assertViewsLinkPresent("rssIssues");
        this.assertViewsLinkPresent("rssComments");
        this.assertViewsLinkNotPresent("word");
        this.assertViewsLinkPresent("allExcelFields");
        this.assertViewsLinkPresent("currentExcelFields");
        this.togglePluginModule(true, "word");
        this.togglePluginModule(false, "excel-all-fields");
        this.getViewsOption();
        this.assertViewsLinkPresent("printable");
        this.assertViewsLinkPresent("fullContent");
        this.assertViewsLinkPresent("xml");
        this.assertViewsLinkPresent("rssIssues");
        this.assertViewsLinkPresent("rssComments");
        this.assertViewsLinkPresent("word");
        this.assertViewsLinkNotPresent("allExcelFields");
        this.assertViewsLinkPresent("currentExcelFields");
        this.togglePluginModule(true, "excel-all-fields");
        this.togglePluginModule(false, "excel-current-fields");
        this.getViewsOption();
        this.assertViewsLinkPresent("printable");
        this.assertViewsLinkPresent("fullContent");
        this.assertViewsLinkPresent("xml");
        this.assertViewsLinkPresent("rssIssues");
        this.assertViewsLinkPresent("rssComments");
        this.assertViewsLinkPresent("word");
        this.assertViewsLinkPresent("allExcelFields");
        this.assertViewsLinkNotPresent("currentExcelFields");
        this.togglePluginModule(true, "excel-current-fields");
        this.togglePluginModule(false, "rss");
        this.togglePluginModule(false, "comments-rss");
        this.getViewsOption();
        this.assertViewsLinkPresent("printable");
        this.assertViewsLinkPresent("fullContent");
        this.assertViewsLinkPresent("xml");
        this.assertTextNotPresentInExportsContent("| RSS");
        this.assertViewsLinkNotPresent("rssIssues");
        this.assertViewsLinkNotPresent("rssComments");
        this.assertViewsLinkPresent("word");
        this.assertViewsLinkPresent("allExcelFields");
        this.assertViewsLinkPresent("currentExcelFields");
        this.togglePluginModule(true, "rss");
        this.togglePluginModule(true, "comments-rss");
        this.togglePluginModule(false, "excel-all-fields");
        this.togglePluginModule(false, "excel-current-fields");
        this.getViewsOption();
        this.assertViewsLinkPresent("printable");
        this.assertViewsLinkPresent("fullContent");
        this.assertViewsLinkPresent("xml");
        this.assertViewsLinkPresent("rssIssues");
        this.assertViewsLinkPresent("rssComments");
        this.assertViewsLinkPresent("word");
        this.assertTextNotPresentInExportsContent("| Excel");
        this.assertViewsLinkNotPresent("allExcelFields");
        this.assertViewsLinkNotPresent("currentExcelFields");
        this.togglePluginModule(true, "excel-all-fields");
        this.togglePluginModule(true, "excel-current-fields");
    }

    private void getViewsOption() {
        this.getViewsOption("", null, null);
    }

    private void getViewsOption(String jql, String filterId, String modified) {
        this.exportsContent = this.backdoor.issueNavControl().getExportOptions(jql, filterId, modified);
    }

    public void assertTextPresentInExportsContent(String text) {
        TestIssueViews.assertTrue((boolean)this.exportsContent.contains(text));
    }

    public void assertTextNotPresentInExportsContent(String text) {
        TestIssueViews.assertFalse((boolean)this.exportsContent.contains(text));
    }

    private void assertViewsLinkPresent(String id) {
        this.assertTextPresentInExportsContent("\"" + id + "\"");
    }

    private void assertViewsLinkNotPresent(String id) {
        this.assertTextNotPresentInExportsContent("\"" + id + "\"");
    }

    private void togglePluginModule(boolean enable, String module) {
        if (enable) {
            this.administration.plugins().enablePluginModule("jira.issueviews", "jira.issueviews:searchrequest-" + module);
        } else {
            this.administration.plugins().disablePluginModule("jira.issueviews", "jira.issueviews:searchrequest-" + module);
        }
    }
}

