/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.IssueSecurityLevel;
import com.atlassian.jira.functest.framework.admin.Project;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.ROLES, Category.SECURITY, Category.USERS_AND_GROUPS})
public class TestIssueSecurityWithGroupsAndRoles
extends JIRAWebTest {
    private static final String[] EXPECTED_SECURITY_LEVEL_NONE = new String[]{"None"};
    private static final String[] EXPECTED_SECURITY_LEVEL_RED = new String[]{"None", "Red"};
    private static final String[] EXPECTED_SECURITY_LEVEL_GREEN = new String[]{"None", "Green"};
    private static final String NEW_PROJECT_NAME = "New Project";
    private static final String NEW_GROUP_NAME = "securityGroup";
    private static final String NEW_SECURITY_SCHEME_NAME = "security scheme copy";

    public TestIssueSecurityWithGroupsAndRoles(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueSecurityWithGroupsAndRoles.xml");
    }

    public void testAddingAndRemovingUserFromGroupFlushesSecurityCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.addGroupToProjectRole("jira-developers", "homosapien", "Administrators");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
        this.getAdministration().usersAndGroups().removeUserFromGroup("admin", "jira-developers");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.getAdministration().usersAndGroups().addUserToGroup("admin", "jira-developers");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
    }

    public void testAddingAndRemovingUserFromRolesFlushesIssueSecurityCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.addUserToProjectRole("admin", "homosapien", "Administrators");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
        this.removeUserFromProjectRole("admin", "homosapien", "Administrators");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    public void testAddingAndRemovingGroupRolesFromProjectFlushesIssueSecurityCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.addGroupToProjectRole("jira-users", "homosapien", "Administrators");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
        this.removeGroupFromProjectRole("jira-users", "homosapien", "Administrators");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    public void testRemovingRoleFlushesIssueSecurityCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.addGroupToProjectRole("jira-users", "homosapien", "Administrators");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
        this.gotoProjectRolesScreen();
        this.clickLink("delete_Administrators");
        this.submit("Delete");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    public void testRemovingGroupFlushesIssueSecurityCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.getAdministration().usersAndGroups().addGroup(NEW_GROUP_NAME);
        this.getAdministration().issueSecuritySchemes().getScheme("New Security Scheme").getLevel("Red").addIssueSecurity(IssueSecurityLevel.IssueSecurity.GROUP, NEW_GROUP_NAME);
        this.getAdministration().usersAndGroups().addUserToGroup("admin", NEW_GROUP_NAME);
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
        this.getAdministration().usersAndGroups().deleteGroup(NEW_GROUP_NAME);
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    public void testNewProjectsWithDefaultRolesHaveCorrectSecurityLevel1() {
        this.addProject(NEW_PROJECT_NAME, "NEW", "admin");
        this.associateSecuritySchemeToProject(NEW_PROJECT_NAME, "New Security Scheme");
        this._testNewProjectsWithDefaultRolesHaveCorrectSecurityLevel();
    }

    public void testNewProjectsWithDefaultRolesHaveCorrectSecurityLevel2() {
        Project project = this.getAdministration().project();
        project.addProject(NEW_PROJECT_NAME, "NEW", "admin");
        this.associateSecuritySchemeToProject(NEW_PROJECT_NAME, "New Security Scheme");
        this._testNewProjectsWithDefaultRolesHaveCorrectSecurityLevel();
    }

    public void testRenamingSecuritySchemeFlushesCache() {
        this.addGroupToProjectRole("jira-users", "homosapien", "Administrators");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.clickLink("edit_10000");
        this.setFormElement("name", "New Security Schemeedited");
        this.submit("Update");
        this.assertLinkWithTextExists("Expected scheme to have been renamed", "New Security Schemeedited");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
    }

    public void testAddingAndRemovingSecuritySchemeFromProject() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.removeAssociationOfSecuritySchemeFromProject("homosapien");
        this.createIssueStep1();
        this.getDialog().setWorkingForm("issue-create");
        this.assertFormElementNotPresent("security");
        this.associateSecuritySchemeToProject("homosapien", "New Security Scheme");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    public void testSwappingSecuritySchemeFlushesCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.getAdministration().issueSecuritySchemes().newScheme(NEW_SECURITY_SCHEME_NAME, "new scheme for testing").newLevel("Orange", "Middle Level").addIssueSecurity(IssueSecurityLevel.IssueSecurity.GROUP, "jira-users");
        this.getAdministration().issueSecuritySchemes().getScheme(NEW_SECURITY_SCHEME_NAME).newLevel("Green", "Lowest Level").addIssueSecurity(IssueSecurityLevel.IssueSecurity.GROUP, "jira-developers");
        this.associateSecuritySchemeToProject("homosapien", NEW_SECURITY_SCHEME_NAME);
        this.assertIssueSecurityLevelOptions(new String[]{"None", "Green", "Orange"});
        this.associateSecuritySchemeToProject("homosapien", "New Security Scheme");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    public void testAddingAndRemovingSecurityLevelFlushesCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.createSecurityLevel("New Security Scheme", "Green", "Lowest Level");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.getAdministration().issueSecuritySchemes().getScheme("New Security Scheme").getLevel("Green").addIssueSecurity(IssueSecurityLevel.IssueSecurity.GROUP, "jira-users");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_GREEN);
        this.createSecurityLevel("New Security Scheme", "Orange", "Middle Level");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_GREEN);
        this.addRoleToSecurityLevel("New Security Scheme", "Green", "Administrators");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_GREEN);
        this.deleteSecurityLevel("New Security Scheme", "Green");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.deleteSecurityLevel("New Security Scheme", "Orange");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    private void _testNewProjectsWithDefaultRolesHaveCorrectSecurityLevel() {
        this.assertIssueSecurityLevelOptions(NEW_PROJECT_NAME, "Bug", EXPECTED_SECURITY_LEVEL_RED);
        this.logout();
        this.login("fred", "fred");
        this.assertIssueSecurityLevelOptions(NEW_PROJECT_NAME, "Bug", EXPECTED_SECURITY_LEVEL_NONE);
    }

    private void assertIssueSecurityLevelOptions(String[] expectedSecurityLevels) {
        this.assertIssueSecurityLevelOptions("homosapien", "Bug", expectedSecurityLevels);
    }

    private void assertIssueSecurityLevelOptions(String projectName, String issueType, String[] expectedSecurityLevels) {
        this.createIssueStep1(projectName, issueType);
        this.getDialog().setWorkingForm("issue-create");
        this.assertOptionsEqual("security", expectedSecurityLevels);
        this.assertOptionSelected("security", "None");
    }
}

