/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestIssuePrintableView
extends JIRAWebTest {
    public TestIssuePrintableView(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.administration.restoreData("TestTimeTrackingAggregates.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    public void testPrintableView() {
        this.navigation.issue().gotoIssue("HSP-10");
        this.tester.clickLinkWithText("Printable");
        this.assertTextSequence(new String[]{"parent 2", "HSP-9", "HSP-10", "sub 3"});
        this.assertTextPresentBeforeText("Status:", "Open");
        this.assertTextPresentBeforeText("Project:", "homosapien");
        this.assertTextPresentBeforeText("Component/s:", "None");
        this.assertTextPresentBeforeText("Affects Version/s:", "None");
        this.assertTextPresentBeforeText("Fix Version/s:", "None");
        this.assertTextSequence(new String[]{"Type:", "Sub-task", "Priority:", "Major"});
        this.assertTextSequence(new String[]{"Reporter:", "Administrator", "Assignee:", "Administrator"});
        this.assertTextSequence(new String[]{"Resolution:", "Unresolved", "Votes:", "0"});
        this.assertTextSequence(new String[]{"Remaining Estimate:", "1 day", "Time Spent:", "1 day", "Original Estimate:", "1 day"});
        this.assertTableNotPresent(" Remaining Estimate:");
        this.assertTableNotPresent(" Time Spent:");
        this.assertTableNotPresent(" Original Estimate:");
        this.assertTableNotPresent("Sub-Tasks:");
        this.tester.gotoPage("/browse/HSP-9");
        this.tester.clickLinkWithText("Printable");
        this.assertTextPresentBeforeText("HSP-9", "parent 2");
        this.assertTextPresentBeforeText("Status:", "Open");
        this.assertTextPresentBeforeText("Project:", "homosapien");
        this.assertTextPresentBeforeText("Component/s:", "None");
        this.assertTextPresentBeforeText("Affects Version/s:", "None");
        this.assertTextPresentBeforeText("Fix Version/s:", "None");
        this.assertTextSequence(new String[]{"Type:", "Bug", "Priority:", "Major"});
        this.assertTextSequence(new String[]{"Reporter:", "Administrator", "Assignee:", "Administrator"});
        this.assertTextSequence(new String[]{"Resolution:", "Unresolved", "Votes:", "0"});
        this.assertTextSequence(new String[]{" Remaining Estimate:", "3 days", "Remaining Estimate:", "Not Specified", " Time Spent:", "1 day", "Time Spent:", "Not Specified", " Original Estimate:", "3 days", "Original Estimate:", "Not Specified"});
        this.assertTextSequence(new String[]{"Sub-Tasks:", "HSP-10", "sub 3", "HSP-11", "sub 4"});
    }

    public void testProperHtmlEscaping() {
        this.navigation.userProfile().gotoCurrentUserProfile();
        this.tester.clickLink("edit_profile_lnk");
        this.tester.setFormElement("fullName", "Administrator &trade;");
        this.tester.submit();
        this.putTradeMarkIntoIssue("HSP-10");
        this.putTradeMarkIntoIssue("HSP-9");
        this.createIssueLinkType("related", "is related to", "relates to");
        this.linkIssueWithComment("HSP-9", "relates to", "HSP-10", null, null);
        this.tester.clickLinkWithText("Printable");
        this.assertTradeMarkIsEscaped();
        this.tester.gotoPage("/");
        this.navigation.issueNavigator().displayPrintableAllIssues();
        this.assertTradeMarkIsEscaped();
        this.tester.gotoPage("/");
        this.navigation.issueNavigator().displayFullContentAllIssues();
        this.assertTradeMarkIsEscaped();
        this.tester.gotoPage("/");
    }

    private void putTradeMarkIntoIssue(String issueKey) {
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("summary", "Issue " + issueKey + " &trade;");
        this.tester.setFormElement("environment", "&trade;");
        this.tester.setFormElement("description", "&trade;");
        this.tester.setFormElement("comment", "&trade;");
        this.tester.submit("Update");
    }

    private void assertTradeMarkIsEscaped() {
        this.assertTextNotPresent("&trade;");
        this.assertTextPresent("&amp;trade;");
    }
}

