/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.PERMISSIONS})
public class TestIssueOperationsWithLimitedPermissions
extends FuncTestCase {
    public static final String RESTRICTED_ISSUE_ID = "10000";
    public static final String RESTRICTED_ISSUE_KEY = "HSP-1";
    public static final String CLOSED_ISSUE_ID = "10020";
    public static final String PERMISSION_ERROR_DESC_ANONYMOUS = "You are not logged in, and do not have the permissions required to act on the selected issue as a guest.";
    public static final String PERMISSION_ERROR_DESC_USER = "You do not have permission to act on this issue.";
    public static final String PERMISSION_ERROR = "You do not have the permission to see the specified issue.";
    private static final String LOGIN = "log in";
    private static final String SIGNUP = "sign up";
    private static final String YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE = "You must log in to access this page.";
    private static final String PERMISSION_VIOLATION_MESSAGE = "It seems that you have tried to perform an operation which you are not permitted to perform.";

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.navigation.login("admin", "admin");
        this.administration.restoreData("TestIssueOperationsWithLimitedPermissionsProEnt.xml");
    }

    public void testIssueOperationsWithLimitedPermissions() {
        this.assertActionIsInaccessibleToAnonymousUser("/browse/", "new test issue", YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE, true);
        this.assertActionIsInaccessibleToUser("/browse/", "new test issue", PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsAccessibleToAdmin("/browse/", "new test issue", YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE);
        this.assertActionIsInaccessibleToAnonymousUser("VoteOrWatchIssue.jspa?vote=vote&", "new test issue", YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE, true);
        this.assertActionIsInaccessibleToUser("VoteOrWatchIssue.jspa?vote=vote&", "new test issue", PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsAccessibleToAdmin("VoteOrWatchIssue.jspa?vote=vote&", "new test issue", YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE);
        this.tester.assertLinkPresent("toggle-vote-issue");
        this.text.assertTextPresent(new IdLocator(this.tester, "toggle-vote-issue"), "Remove Vote");
        this.text.assertTextNotPresent(new IdLocator(this.tester, "toggle-vote-issue"), "Add Vote");
        this.assertActionIsInaccessibleToAdminForClosedIssue("VoteOrWatchIssue.jspa?vote=vote&", "An issue that will be closed!", "You cannot vote or change your vote on resolved issues.");
        this.assertActionIsInaccessibleToAnonymousUser("VoteOrWatchIssue.jspa?vote=unvote&", "new test issue", YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE, true);
        this.assertActionIsInaccessibleToUser("VoteOrWatchIssue.jspa?vote=unvote&", "new test issue", PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsAccessibleToAdmin("VoteOrWatchIssue.jspa?vote=unvote&", "new test issue", YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE);
        this.tester.assertLinkPresent("toggle-vote-issue");
        this.text.assertTextPresent(new IdLocator(this.tester, "toggle-vote-issue"), "Add Vote");
        this.text.assertTextNotPresent(new IdLocator(this.tester, "toggle-vote-issue"), "Remove Vote");
        this.assertActionIsInaccessibleToAdminForClosedIssue("VoteOrWatchIssue.jspa?vote=unvote&", "An issue that will be closed!", "You cannot vote or change your vote on resolved issues.");
        this.assertActionIsInaccessibleToAnonymousUser("VoteOrWatchIssue.jspa?watch=watch&", "new test issue", YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE, true);
        this.assertActionIsInaccessibleToUser("VoteOrWatchIssue.jspa?watch=watch&", "new test issue", PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsAccessibleToAdmin("VoteOrWatchIssue.jspa?watch=watch&", "new test issue", YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE);
        this.tester.assertLinkPresent("toggle-watch-issue");
        this.text.assertTextPresent(new IdLocator(this.tester, "toggle-watch-issue"), "Stop Watching");
        this.text.assertTextNotPresent(new IdLocator(this.tester, "toggle-watch-issue"), "Watch Issue");
        this.assertActionIsInaccessibleToAnonymousUser("VoteOrWatchIssue.jspa?watch=unwatch&", "new test issue", YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE, true);
        this.assertActionIsInaccessibleToUser("VoteOrWatchIssue.jspa?watch=unwatch&", "new test issue", PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsAccessibleToAdmin("VoteOrWatchIssue.jspa?watch=unwatch&", "new test issue", YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE);
        this.tester.assertLinkPresent("toggle-watch-issue");
        this.text.assertTextNotPresent(new IdLocator(this.tester, "toggle-watch-issue"), "Stop Watching");
        this.text.assertTextPresent(new IdLocator(this.tester, "toggle-watch-issue"), "Watch Issue");
        this.assertActionIsInaccessibleToAnonymousUser("WorkflowUIDispatcher.jspa?action=5&", "Resolve Issue", YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE, true);
        this.assertActionIsInaccessibleToUser("WorkflowUIDispatcher.jspa?action=5&", "Resolve Issue", PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsAccessibleToAdmin("WorkflowUIDispatcher.jspa?action=5&", "Resolve Issue", YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE);
        this.assertActionIsInaccessibleToAnonymousUser("AssignIssue!default.jspa?", "assign-issue-submit", PERMISSION_ERROR, true);
        this.assertActionIsInaccessibleToUser("AssignIssue!default.jspa?", "assign-issue-submit", PERMISSION_ERROR);
        this.assertActionIsAccessibleToAdmin("AssignIssue!default.jspa?", "assign-issue-submit", PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAdminForClosedIssue("AssignIssue!default.jspa?", "assign-issue-submit", PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsInaccessibleToAnonymousUser("CommentAssignIssue!default.jspa?action=5&", "Resolve Issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("CommentAssignIssue!default.jspa?action=5&", "Resolve Issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("CommentAssignIssue!default.jspa?action=5&", "Resolve Issue", PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAnonymousUser("EditIssue!default.jspa?", "Edit Issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("EditIssue!default.jspa?", "Edit Issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("EditIssue!default.jspa?", "Edit Issue", PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAdminForClosedIssue("EditIssue!default.jspa?", null, "You are not allowed to edit this issue due to its current status in the workflow.");
        this.assertActionIsInaccessibleToAnonymousUser("EditLabels!default.jspa?", null, PERMISSION_ERROR, true);
        this.assertActionIsInaccessibleToUser("EditLabels!default.jspa?", null, PERMISSION_ERROR);
        this.assertActionIsAccessibleToAdmin("EditLabels!default.jspa?", "Labels", PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAdminForClosedIssue("EditLabels!default.jspa?", null, PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsInaccessibleToAnonymousUser("CloneIssueDetails!default.jspa?", "Summary", PERMISSION_ERROR, false);
        this.assertActionIsInaccessibleToUser("CloneIssueDetails!default.jspa?", "Summary", PERMISSION_ERROR);
        this.assertActionIsAccessibleToAdmin("CloneIssueDetails!default.jspa?", "Summary", PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAnonymousUser("MoveIssue!default.jspa?", "Current Project", "You are not logged in and do not have the permissions required to browse projects as a guest.", true);
        this.assertActionIsInaccessibleToUser("MoveIssue!default.jspa?", "Current Project", "You do not have the permissions required to browse any projects.");
        this.assertActionIsAccessibleToAdmin("MoveIssue!default.jspa?", "homosapien", "You are not logged in and do not have the permissions required to browse projects as a guest.");
        this.assertActionIsInaccessibleToAnonymousUser("ViewVoters!default.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ViewVoters!default.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ViewVoters!default.jspa?", "There are no voters for this issue", PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAnonymousUser("ViewVoters!addVote.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ViewVoters!addVote.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ViewVoters!addVote.jspa?", "Remove your vote", PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAnonymousUser("ViewVoters!removeVote.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ViewVoters!removeVote.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ViewVoters!removeVote.jspa?", "There are no voters for this issue", PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!default.jspa?", "Watch Issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!default.jspa?", "Watch Issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!default.jspa?", "Watch Issue", PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!startWatching.jspa?", "Watch Issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!startWatching.jspa?", "Watch Issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!startWatching.jspa?", "Stop Watching", PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!stopWatching.jspa?", "Watch Issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!stopWatching.jspa?", "Watch Issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!stopWatching.jspa?", "Watch Issue", PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!startWatchers.jspa?userNames=admin&", "Watch Issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!startWatchers.jspa?userNames=admin&", "Watch Issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!startWatchers.jspa?userNames=admin&", "Stop Watching", PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!stopWatchers.jspa?userNames=admin&", "Watch Issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!stopWatchers.jspa?userNames=admin&", "Watch Issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!stopWatchers.jspa?userNames=admin&", "Stop Watching", PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAnonymousUser("CreateWorklog!default.jspa?", null, PERMISSION_ERROR, true);
        this.assertActionIsInaccessibleToUser("CreateWorklog!default.jspa?", null, PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsAccessibleToAdmin("CreateWorklog!default.jspa?", "Log Work", PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAdminForClosedIssue("CreateWorklog!default.jspa?", null, PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsInaccessibleToAnonymousUser("UpdateWorklog!default.jspa?worklogId=10000&", "Edit Work Log", YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE, false);
        this.assertActionIsInaccessibleToUser("UpdateWorklog!default.jspa?worklogId=10000&", "Edit Work Log", PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsAccessibleToAdmin("UpdateWorklog!default.jspa?worklogId=10000&", "Edit Work Log", PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsInaccessibleToAnonymousUser("DeleteWorklog!default.jspa?worklogId=10000&", "Delete Worklog", YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE, false);
        this.assertActionIsInaccessibleToUser("DeleteWorklog!default.jspa?worklogId=10000&", "Delete Worklog", PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsAccessibleToAdmin("DeleteWorklog!default.jspa?worklogId=10000&", "Delete Worklog", PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsInaccessibleToAnonymousUser("EditComment!default.jspa?commentId=10000&", "ignoreMeAndSeeAssertBelow", "You do not have the permission to edit this comment.", false);
        this.assertActionIsInaccessibleToUser("EditComment!default.jspa?commentId=10000&", "ignoreMeAndSeeAssertBelow", "you do not have the permission to edit this comment.");
        this.assertActionIsAccessibleToAdmin("EditComment!default.jspa?commentId=10000&", "Edit Comment", "you do not have the permission to edit this comment.");
        this.assertActionIsInaccessibleToAnonymousUser("DeleteComment!default.jspa?commentId=10000&", "ignoreMeAndSeeAssertBelow", "You do not have permission to delete comment with id: 10000", false);
        this.assertActionIsInaccessibleToUser("DeleteComment!default.jspa?commentId=10000&", "ignoreMeAndSeeAssertBelow", "You do not have permission to delete comment with id: 10000");
        this.assertActionIsAccessibleToAdmin("DeleteComment!default.jspa?commentId=10000&", "Delete Comment", "You do not have permission to delete comment with id: 10000");
        this.assertActionIsInaccessibleToAnonymousUser("CreateSubTaskIssue!default.jspa?parentIssueId=10000&", "Component/s", "You are not logged in and do not have the permissions required to browse projects as a guest.", true);
        this.assertActionIsInaccessibleToUser("CreateSubTaskIssue!default.jspa?parentIssueId=10000&", "Component/s", "You do not have the permissions required to browse any projects");
        this.assertActionIsAccessibleToAdmin("CreateSubTaskIssue!default.jspa?parentIssueId=10000&", "Component/s", PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAnonymousUser("CreateSubTaskIssue.jspa?parentIssueId=10000&", "Issue Type", "You are not logged in and do not have the permissions required to browse projects as a guest.", true);
        this.assertActionIsInaccessibleToUser("CreateSubTaskIssue.jspa?parentIssueId=10000&", "Issue Type", "You do not have the permissions required to browse any projects");
        this.assertActionIsAccessibleToAdmin("CreateSubTaskIssue.jspa?parentIssueId=10000&", "Issue Type", PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAnonymousUser("CreateSubTaskIssueDetails.jspa?parentIssueId=10000&issuetype=5&pid=10000&", "ignoreMeAndSeeAssertBelow", "You are not logged in, and do not have the permissions required to create an issue in this project as a guest.", false);
        this.assertActionIsInaccessibleToUser("CreateSubTaskIssueDetails.jspa?parentIssueId=10000&issuetype=5&pid=10000&", "ignoreMeAndSeeAssertBelow", "pid: You do not have permission to create issues in this project.");
        this.assertActionIsAccessibleToAdmin("CreateSubTaskIssueDetails.jspa?parentIssueId=10000&issuetype=5&pid=10000&", "Create Sub-Task", PERMISSION_ERROR);
    }

    private void assertActionIsInaccessibleToAnonymousUser(String actionUrl, String textNotPresent, String error_desc, boolean hasLoginLink) {
        this.navigation.logout();
        this.page.getFreshXsrfToken();
        if (actionUrl.equals("/browse/")) {
            this.tester.gotoPage("/browse/HSP-1?atl_token=" + this.page.getXsrfToken());
        } else {
            this.tester.gotoPage("/secure/" + actionUrl + "id=" + RESTRICTED_ISSUE_ID + "&atl_token=" + this.page.getXsrfToken());
        }
        if (hasLoginLink) {
            this.tester.assertTextPresent(error_desc);
            this.tester.assertLinkPresentWithText(SIGNUP);
        } else {
            this.tester.assertTextPresent(error_desc);
        }
        if (textNotPresent != null) {
            this.assertActionNotPresent(textNotPresent);
        }
    }

    private void assertActionIsInaccessibleToUser(String actionUrl, String textNotPresent, String error_desc) {
        this.navigation.login("fred", "fred");
        if (actionUrl.equals("/browse/")) {
            this.tester.gotoPage("/browse/HSP-1?atl_token=" + this.page.getXsrfToken());
        } else {
            this.tester.gotoPage("/secure/" + actionUrl + "id=" + RESTRICTED_ISSUE_ID + "&atl_token=" + this.page.getXsrfToken());
        }
        this.tester.assertTextPresent(error_desc);
        this.tester.assertLinkNotPresentWithText(LOGIN);
        this.tester.assertLinkNotPresentWithText(SIGNUP);
        if (textNotPresent != null) {
            this.assertActionNotPresent(textNotPresent);
        }
    }

    private void assertActionIsAccessibleToAdmin(String actionUrl, String textPresent, String textNotPresent) {
        this.navigation.login("admin", "admin");
        if (actionUrl.equals("/browse/")) {
            this.tester.gotoPage("/browse/HSP-1?atl_token=" + this.page.getXsrfToken());
        } else {
            this.tester.gotoPage("/secure/" + actionUrl + "id=" + RESTRICTED_ISSUE_ID + "&atl_token=" + this.page.getXsrfToken());
        }
        this.assertActionNotPresent(textNotPresent);
        this.tester.assertLinkNotPresentWithText(LOGIN);
        this.tester.assertLinkNotPresentWithText(SIGNUP);
        this.tester.assertTextPresent(textPresent);
    }

    private void assertActionIsInaccessibleToAdminForClosedIssue(String actionUrl, String textNotPresent, String error_desc) {
        this.navigation.login("admin", "admin");
        this.tester.gotoPage("/secure/" + actionUrl + "id=" + CLOSED_ISSUE_ID + "&atl_token=" + this.page.getXsrfToken());
        this.tester.assertTextPresent(error_desc);
        this.tester.assertLinkNotPresentWithText(LOGIN);
        this.tester.assertLinkNotPresentWithText(SIGNUP);
        this.assertActionNotPresent(textNotPresent);
    }

    private void assertActionNotPresent(String textNotPresent) {
        if (this.tester.getDialog().getElement("stalker") != null) {
            Assert.assertThat((Object)this.tester.getDialog().getElement("stalker").getTextContent(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)textNotPresent)));
        }
    }
}

