/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestIssueOperations
extends JIRAWebTest {
    private static final String ATTACHMENT_DOUBLE_QUOTES = "bigdummy\"\"Attachment";
    private static final String ISSUE_KEY_1 = "HSP-1";
    private static final String ISSUE_KEY_2 = "HSP-2";
    private static final String TEST_USER_1 = "testuser";
    private static final String TEST_USER_2 = "testuser2";

    public TestIssueOperations(String name) {
        super(name);
    }

    public void testIssueOperations() {
        this.restoreData("TestIssueOperations.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.administration.attachments().enable();
        this.issueOperationsWithWorkOnPermission(ISSUE_KEY_1);
        this.issueOperationWithUnassignableCurrentAssignee(ISSUE_KEY_1);
        this.issueOperationWithAssignPermission(ISSUE_KEY_1);
        this.issueOperationWithCreateAttachmentsPermission(ISSUE_KEY_1);
        this.issueOperationCacheControl(ISSUE_KEY_1);
    }

    public void testIssueLinksForOperations() {
        this.restoreData("TestIssueIconOperations.xml");
        this.login("fred");
        this.gotoIssue(ISSUE_KEY_1);
        this.assertLinkPresent("aszip");
        this.assertLinkPresent("manage-attachment-link");
        this.assertLinkPresent("add-attachments-link");
        this.assertLinkPresent("add-links-link");
        this.assertLinkPresent("log-work-link");
        this.clickLink("manage-attachment-link");
        this.assertTextSequence(new String[]{"Manage Attachments", "This page allows you to manage the attachments", "foobar.json"});
        this.assertLinkPresent("aszipbutton");
        this.gotoIssue(ISSUE_KEY_1);
        this.clickLink("add-attachments-link");
        this.assertTextSequence(new String[]{"Attach Files"});
        this.gotoIssue(ISSUE_KEY_1);
        this.gotoIssue(ISSUE_KEY_1);
        this.clickLink("add-links-link");
        this.assertTextSequence(new String[]{"Link"});
        this.gotoIssue(ISSUE_KEY_1);
        this.clickLink("log-work-link");
        this.assertTextSequence(new String[]{"Log Work"});
        this.login("user", "user");
        this.gotoIssue(ISSUE_KEY_1);
        this.assertLinkPresent("aszip");
        this.assertLinkNotPresent("manage-attachment-link");
        this.assertLinkNotPresent("add-attachments-link");
        this.assertLinkPresent("add-links-link");
        this.assertLinkNotPresent("log-work-link");
        this.login("admin");
        this.gotoIssue(ISSUE_KEY_1);
        this.assertLinkPresent("aszip");
        this.assertLinkPresent("manage-attachment-link");
        this.assertLinkNotPresent("add-attachments-link");
        this.assertLinkPresent("add-links-link");
        this.assertLinkNotPresent("log-work-link");
        this.administration.attachments().disableZipSupport();
        this.gotoIssue(ISSUE_KEY_1);
        this.assertLinkNotPresent("aszip");
        this.clickLink("manage-attachment-link");
        this.assertLinkNotPresent("aszipbutton");
    }

    public void issueOperationsWithWorkOnPermission(String issueKey) {
        TestIssueOperations.log("Issue Operation: Test availability of Log Work Link with 'Work On Issues' permission.");
        this.activateTimeTracking();
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.WORK_ON_ISSUES, "jira-developers");
        this.gotoIssue(issueKey);
        this.assertLinkNotPresent("log-work");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.WORK_ON_ISSUES, "jira-developers");
        this.gotoIssue(issueKey);
        this.assertLinkPresent("log-work");
        this.deactivateTimeTracking();
    }

    public void testLogWorkOperationTimeTrackingDisabled() {
        this.restoreData("TestIssueOperations.xml");
        this.deactivateTimeTracking();
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.gotoIssue(ISSUE_KEY_1);
        this.assertLinkNotPresent("log-work");
    }

    public void testLogWorkOperationAnonymous() {
        this.restoreData("TestIssueOperations.xml");
        this.activateTimeTracking();
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.clickLinkWithText("Default Permission Scheme");
        this.clickLink("add_perm_" + ProjectPermissions.BROWSE_PROJECTS.permissionKey());
        this.checkCheckbox("type", "group");
        this.submit(" Add ");
        this.logout();
        this.gotoPage("/browse/HSP-1");
        this.assertLinkNotPresent("log-work");
    }

    public void testLogWorkOperationIssueInNonEditableState() {
        this.restoreData("TestIssueOperations.xml");
        this.activateTimeTracking();
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.gotoIssue(ISSUE_KEY_1);
        this.clickLinkWithText("Close Issue");
        this.setWorkingForm("issue-workflow-transition");
        this.submit("Transition");
        this.assertLinkNotPresent("log-work");
    }

    public void testLogWorkOperationHappyPath() {
        this.restoreData("TestIssueOperations.xml");
        this.activateTimeTracking();
        this.gotoIssue(ISSUE_KEY_1);
        this.assertLinkPresent("log-work");
    }

    public void issueOperationWithUnassignableCurrentAssignee(String issueKey) {
        TestIssueOperations.log("Issue Operation: Attempt to set the assignee to be an unassignable user ...");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
        this.gotoIssue(issueKey);
        this.clickLink("assign-issue");
        this.setWorkingForm("assign-issue");
        this.submit();
        this.assertTextNotPresent("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
        this.assertTextPresent("Issue already assigned to Administrator (admin)");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
    }

    public void issueOperationWithAssignPermission(String issueKey) {
        TestIssueOperations.log("Issue Operation: Test the availability of the 'Assign Link' with 'Assign Issues' Permission.");
        this.gotoIssue(issueKey);
        this.assertLinkPresent("assign-issue");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.gotoIssue(issueKey);
        this.assertLinkNotPresent("assign-issue");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
    }

    public void issueOperationWithCreateAttachmentsPermission(String issueKey) {
        TestIssueOperations.log("Issue Operation: Test the availability of the 'Attach Link' with 'Create Attachments' Permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.CREATE_ATTACHMENTS, "jira-users");
        this.gotoIssue(issueKey);
        this.assertLinkNotPresent("attach-file");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.CREATE_ATTACHMENTS, "jira-users");
        this.gotoIssue(issueKey);
        this.assertLinkPresent("attach-file");
    }

    public void issueOperationCacheControl(String issueKey) {
        TestIssueOperations.log("Issue Operation: Test cache control for Issue Navigator pages.");
        this.navigation.issueNavigator().displayAllIssues();
        String cache = this.getDialog().getResponse().getHeaderField("Cache-Control");
        TestIssueOperations.assertEquals((String)cache, (String)"no-cache, no-store, must-revalidate");
        this.gotoIssue(issueKey);
        cache = this.getDialog().getResponse().getHeaderField("Cache-Control");
        TestIssueOperations.assertEquals((String)cache, (String)"no-cache, no-store, must-revalidate");
    }

    public void testIssueOperationManageWatcherList() {
        this.restoreData("TestIssueOperationsWithReporter.xml");
        this.administration.attachments().enable();
        this.administration.permissionSchemes().defaultScheme().grantPermissionToReporter(ProjectPermissions.MANAGE_WATCHERS);
        this.logout();
        this.login(TEST_USER_1, TEST_USER_1);
        this.gotoIssue(ISSUE_KEY_2);
        this.assertLinkPresent("manage-watchers");
        this.logout();
        this.login(TEST_USER_2, TEST_USER_2);
        this.assertLinkNotPresent("manage-watchers");
        this.logout();
    }

    public void testIssueOperationsWithLongNames() {
        this.restoreData("TestIssueOperationsWithLongTransitions.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.gotoIssue(ISSUE_KEY_1);
        IdLocator locator = new IdLocator(this.tester, "action_id_711");
        this.text.assertTextPresent(locator, "Another really long on...");
        TestIssueOperations.assertEquals((String)"Another really long one that has a description as well - Yep, this is the description", (String)locator.getNode().getAttributes().getNamedItem("title").getNodeValue());
        locator = new IdLocator(this.tester, "action_id_4");
        this.text.assertTextPresent(locator, "Start Progress that is...");
        TestIssueOperations.assertEquals((String)"Start Progress that is...", (String)locator.getNode().getTextContent());
        locator = new IdLocator(this.tester, "action_id_5");
        this.text.assertTextPresent(locator, "Resolve Issue");
        TestIssueOperations.assertEquals((String)"Resolve Issue - We can still give it a description", (String)locator.getNode().getAttributes().getNamedItem("title").getNodeValue());
        locator = new IdLocator(this.tester, "action_id_2");
        this.text.assertTextPresent(locator, "Close Issue");
        TestIssueOperations.assertEquals(null, (Object)locator.getNode().getAttributes().getNamedItem("title"));
    }
}

