/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rules.RestRule;
import com.atlassian.jira.webtests.util.issue.IssueInlineEdit;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestInlineEditIssueFieldsExceedingLimit
extends FuncTestCase {
    private RestRule restRule;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.restRule = new RestRule(this);
        this.restRule.before();
        this.administration.restoreData("TestInlineEditIssueFieldsExceedingLimit.xml");
        this.navigation.login("admin", "admin");
    }

    @Override
    public void tearDownTest() {
        this.restRule.after();
    }

    public void testInlineEditTextArea() throws Exception {
        this.testInlineEditField("customfield_10000", "customfield_10000-val");
    }

    public void testInlineEditTextField() throws Exception {
        this.testInlineEditField("customfield_10001", "customfield_10001-val");
    }

    public void testInlineEditUrlField() throws Exception {
        this.testInlineEditField("customfield_10002", "environment-val");
    }

    public void testInlineEditEnvironment() throws Exception {
        this.testInlineEditField("environment", "environment-val");
    }

    public void testInlineEditDescription() throws Exception {
        this.testInlineEditField("description", "description-val");
    }

    public void testInlineEditSummary() throws Exception {
        this.testInlineEditField("summary", "summary-val", false);
    }

    private void testInlineEditField(String fieldName, String fieldId) throws Exception {
        this.testInlineEditField(fieldName, fieldId, true);
    }

    private void testInlineEditField(String fieldName, String fieldId, boolean shouldFail) throws Exception {
        this.navigation.issue().gotoIssue("HSP-2");
        String oldValue = this.locator.id(fieldId).getText();
        String newValue = oldValue + "s";
        this.backdoor.advancedSettings().setTextFieldCharacterLengthLimit((long)oldValue.length());
        IssueInlineEdit inlineEdit = new IssueInlineEdit(this.locator, this.tester, new RestRule(this));
        inlineEdit.inlineEditField("10100", fieldName, newValue);
        this.navigation.issue().gotoIssue("HSP-2");
        if (shouldFail) {
            this.assertions.assertNodeByIdEquals(fieldId, oldValue);
        } else {
            this.assertions.assertNodeByIdEquals(fieldId, newValue);
        }
    }
}

