/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rules.RestRule;
import com.atlassian.jira.webtests.util.issue.IssueInlineEdit;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestInlineEditIssueFields
extends FuncTestCase {
    private RestRule restRule;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.restRule = new RestRule(this);
        this.restRule.before();
        this.administration.restoreData("TestEditIssueVersion.xml");
        this.navigation.login("admin", "admin");
    }

    @Override
    public void tearDownTest() {
        this.restRule.after();
    }

    public void testInlineEditIssueType() throws Exception {
        this.testInlineEditField("issuetype", "type-val", "Bug", "4", "Improvement");
    }

    public void testInlineEditPriority() throws Exception {
        this.testInlineEditField("priority", "priority-val", "Major", "4", "Minor");
    }

    public void testInlineEditDescription() throws Exception {
        this.testInlineEditField("description", "description-val", "oneoneoneoneoneoneoneoneone", "blablabla", "blablabla");
    }

    private void testInlineEditField(String fieldName, String fieldId, String oldValue, String newFormValue, String newTextValue) throws Exception {
        this.navigation.issue().gotoIssue("MK-1");
        this.assertions.assertNodeByIdHasText(fieldId, oldValue);
        IssueInlineEdit inlineEdit = new IssueInlineEdit(this.locator, this.tester, new RestRule(this));
        inlineEdit.inlineEditField("10020", fieldName, newFormValue);
        this.navigation.issue().gotoIssue("MK-1");
        this.assertions.assertNodeByIdDoesNotHaveText(fieldId, oldValue);
        this.assertions.assertNodeByIdHasText(fieldId, newTextValue);
    }
}

