/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.framework.parser.issue.ViewIssueDetails;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.webtests.JIRAWebTest;
import java.util.Map;
import java.util.TreeMap;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestEditIssue
extends JIRAWebTest {
    private static final String TEST_BACKUP_XML = "TestEditIssue.xml";
    private static final String COMMENT_1 = "This issue is resolved now.";
    private static final String COMMENT_2 = "Viewable by developers group.";
    private static final String COMMENT_3 = "Viewable by Developers role.";
    private static final String HSP_1 = "HSP-1";
    private static final String MKY_2 = "MKY-2";
    private static final String ADDED_COMPONENT = "oracle component";

    public TestEditIssue(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
        this.getBackdoor().darkFeatures().enableForSite("jira.no.frother.reporter.field");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    @Override
    public void tearDown() {
        this.getBackdoor().darkFeatures().disableForSite("jira.no.frother.reporter.field");
        super.tearDown();
    }

    public void testUpdateIssueWithVersionCF() throws Exception {
        this.restoreData(TEST_BACKUP_XML);
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.gotoAdmin();
        this.gotoCustomFields();
        this.clickLink("add_custom_fields");
        this.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:multiversion");
        this.submit("nextBtn");
        this.setFormElement("fieldName", "CF-A");
        this.submit("nextBtn");
        this.checkCheckbox("associatedScreens", "1");
        this.checkCheckbox("associatedScreens", "3");
        this.checkCheckbox("associatedScreens", "2");
        this.submit("Update");
        this.gotoIssue(HSP_1);
        this.clickLink("edit-issue");
        this.selectOption("customfield_10000", "New Version 1");
        this.submit("Update");
        this.issueTableAssertions.assertSearchWithResults("project=homosapien AND CF-A=\"New Version 1\"", HSP_1);
        this.gotoIssue(HSP_1);
        this.clickLink("edit-issue");
        this.getDialog().setFormParameter("customfield_10000", "-1");
        this.submit("Update");
        this.issueTableAssertions.assertSearchWithResults("project=homosapien AND CF-A=\"New Version 1\"", new String[0]);
    }

    public void testEditIssueUnknownReporter() throws Exception {
        this.restoreData(TEST_BACKUP_XML);
        this.getBackdoor().darkFeatures().enableForSite("jira.no.frother.reporter.field");
        this.gotoIssue(MKY_2);
        this.clickLink("edit-issue");
        this.submit("Update");
        this.assertTextPresent("The reporter specified is not a user.");
        this.setFormElement("assignee", "admin");
        this.setFormElement("reporter", "admin");
        this.submit("Update");
    }

    public void testEditIssue() {
        String issueKeyNormal = this.addIssue("homosapien", "HSP", "Bug", "test with components", "Minor", new String[]{"New Component 1"}, new String[]{"New Version 1"}, new String[]{"New Version 1"}, "Administrator", "test environment 1", "test description normal issue for editing", null, null, null);
        String issueKeyWithNoComponents = this.addIssue("homosapien", "HSP", "Bug", "test without components or versions", "Minor", null, null, null, "Administrator", "test environment 2", "test description issue with components", null, null, null);
        this.activateTimeTracking();
        String issueKeyWithTimeTracking = this.addIssue("homosapien", "HSP", "New Feature", "test with time tracking", "Critical", null, null, null, "Administrator", "test environment 3", "test description issue with time tracking", "1w", null, null);
        this.deactivateTimeTracking();
        this.editIssueWithTimeTracking(issueKeyNormal, issueKeyWithTimeTracking);
        this.editIssueWithoutSummary(issueKeyNormal);
        this.editIssueWithRequiredFields(issueKeyWithNoComponents);
        this.editIssueWithHiddenFields(issueKeyWithNoComponents);
        this.editIssueWithInvalidDueDate(issueKeyWithNoComponents);
        this.editIssueWithEditPermission(issueKeyNormal);
        this.editIssueWithSchedulePermission(issueKeyNormal);
        this.editIssueWithAssignPermission(issueKeyNormal);
        this.editIssueWithModifyReporterPermission(issueKeyNormal);
        this.editIssueWithAddCommentsPermission(issueKeyNormal);
    }

    private void editIssueWithoutSummary(String issueKey) {
        TestEditIssue.log("Edit Issue: omitting summary");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"summary", (Object)"test with components"), null, issueKey);
        this.gotoIssue(issueKey);
        this.clickLink("edit-issue");
        this.setFormElement("summary", "");
        this.submit();
        this.assertTextPresent("You must specify a summary of the issue.");
        this.setFormElement("summary", "test if index is updated");
        this.submit();
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"summary", (Object)"test if index is updated"), EasyMap.build((Object)"summary", (Object)"test with components"), issueKey);
    }

    private void editIssueWithRequiredFields(String issueKey) {
        this.setRequiredFields();
        TestEditIssue.log("Edit Issue: Editing issue with required fields.");
        this.gotoIssue(issueKey);
        this.clickLink("edit-issue");
        this.assertTextPresent("Edit Issue");
        this.submit("Update");
        this.assertTextPresent("Edit Issue");
        this.assertTextPresent("Component/s is required");
        this.assertTextPresent("Affects Version/s is required");
        this.assertTextPresent("Fix Version/s is required");
        this.resetFields();
    }

    private void editIssueWithHiddenFields(String issueKey) {
        this.setHiddenFields("Component/s");
        this.setHiddenFields("Affects Version/s");
        this.setHiddenFields("Fix Version/s");
        TestEditIssue.log("Edit Issue: Editing issue with Hidden fields.");
        this.gotoIssue(issueKey);
        this.clickLink("edit-issue");
        this.assertTextPresent("Edit Issue");
        this.assertLinkNotPresent("components");
        this.assertLinkNotPresent("versions");
        this.assertLinkNotPresent("fixVersions");
        this.resetFields();
    }

    private void editIssueWithInvalidDueDate(String issueKey) {
        TestEditIssue.log("Edit Issue: Editing issue with invalid due date");
        this.gotoIssue(issueKey);
        this.clickLink("edit-issue");
        this.assertTextPresent("Edit Issue");
        this.setFormElement("duedate", "stuff");
        this.submit();
        this.assertTextPresent("Edit Issue");
        this.assertTextPresent("You did not enter a valid date. Please enter the date in the format &quot;d/MMM/yy&quot;");
    }

    private void editIssueWithEditPermission(String issueKey) {
        TestEditIssue.log("Edit Issue: Test availability of 'Edit Issue' link with 'Edit Issue' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.EDIT_ISSUES, "jira-developers");
        this.gotoIssue(issueKey);
        this.assertLinkNotPresent("edit-issue");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.EDIT_ISSUES, "jira-developers");
        this.gotoIssue(issueKey);
        this.assertLinkPresent("edit-issue");
    }

    private void editIssueWithSchedulePermission(String issueKey) {
        TestEditIssue.log("Edit Issue: Test prescence of 'Due Date' field with 'Schedule Issue' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.SCHEDULE_ISSUES, "jira-developers");
        this.gotoIssue(issueKey);
        this.clickLink("edit-issue");
        this.assertTextNotPresent("Due Date");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.SCHEDULE_ISSUES, "jira-developers");
        this.gotoIssue(issueKey);
        this.clickLink("edit-issue");
        this.assertTextPresent("Due Date");
    }

    private void editIssueWithAssignPermission(String issueKey) {
        TestEditIssue.log("Edit Issue: Test ability to specify assignee with 'Assign Issue' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.gotoIssue(issueKey);
        this.clickLink("edit-issue");
        this.assertFormElementNotPresent("assignee");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.gotoIssue(issueKey);
        this.clickLink("edit-issue");
        this.assertFormElementPresent("assignee");
    }

    private void editIssueWithModifyReporterPermission(String issueKey) {
        TestEditIssue.log("Edit Issue: Test availability of Reporter with 'Modify Reporter' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.MODIFY_REPORTER, "jira-administrators");
        this.gotoIssue(issueKey);
        this.clickLink("edit-issue");
        this.assertFormElementNotPresent("reporter");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.MODIFY_REPORTER, "jira-administrators");
        this.gotoIssue(issueKey);
        this.clickLink("edit-issue");
        this.assertFormElementPresent("reporter");
    }

    private void editIssueWithAddCommentsPermission(String issueKey) {
        TestEditIssue.log("Edit Issue: Test availability of Comment field with 'Add Comments' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ADD_COMMENTS, "jira-users");
        this.gotoIssue(issueKey);
        this.assertLinkNotPresent("comment-issue");
        this.assertLinkNotPresent("footer-comment-button");
        this.clickLink("edit-issue");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.ADD_COMMENTS, "jira-users");
        this.gotoIssue(issueKey);
        this.assertLinkPresent("comment-issue");
        this.assertLinkPresent("footer-comment-button");
        this.clickLink("edit-issue");
    }

    public void testEditClosedIssue() {
        this.restoreData(TEST_BACKUP_XML);
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.EDIT_ISSUES, "jira-users");
        this.gotoIssue(HSP_1);
        this.assertLinkPresent("edit-issue");
        this.clickLinkWithText("Close Issue");
        this.setWorkingForm("issue-workflow-transition");
        this.submit("Transition");
        this.assertLinkNotPresentWithText("edit-issue");
        this.gotoPage("/secure/EditIssue!default.jspa?id=10000");
        this.assertTextPresent("You are not allowed to edit this issue due to its current status in the workflow.");
    }

    public void testEditIssueWithEditPermissionManualNavigation() {
        this.restoreData(TEST_BACKUP_XML);
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.EDIT_ISSUES, "jira-developers");
        this.gotoPage("/secure/EditIssue!default.jspa?id=10000");
        this.assertTextPresent("You do not have permission to edit issues in this project.");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.EDIT_ISSUES, "jira-users");
        this.gotoPage("/secure/EditIssue!default.jspa?id=10000");
        this.assertTextNotPresent("You do not have permission to edit issues in this project.");
    }

    public void testEditIssueWhileLoggedOut() {
        this.restoreData(TEST_BACKUP_XML);
        this.logout();
        this.gotoPage("/secure/EditIssue!default.jspa?id=10000");
        this.assertTextPresent("You are not logged in");
    }

    public void testEditIssueWithPermissionWhileLoggedOut() {
        this.restoreData(TEST_BACKUP_XML);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.EDIT_ISSUES);
        this.logout();
        this.gotoPage("secure/Dashboard.jspa");
        this.gotoIssue(HSP_1);
        this.assertLinkPresent("edit-issue");
    }

    public void testEditWithCommentVisibility() {
        this.restoreData(TEST_BACKUP_XML);
        this.enableCommentGroupVisibility(Boolean.TRUE);
        this.assertIndexedFieldCorrect("//item/comments", null, EasyMap.build((Object)"comment", (Object)COMMENT_1), HSP_1);
        this.gotoIssue(HSP_1);
        this.clickLink("edit-issue");
        this.setFormElement("comment", COMMENT_1);
        this.submit("Update");
        this.assertIndexedFieldCorrect("//item/comments", EasyMap.build((Object)"comment", (Object)COMMENT_1), null, HSP_1);
        this.assertIndexedFieldCorrect("//item/comments", null, EasyMap.build((Object)"comment", (Object)COMMENT_2), HSP_1);
        this.gotoIssue(HSP_1);
        this.clickLink("edit-issue");
        this.setFormElement("comment", COMMENT_2);
        this.selectOption("commentLevel", "jira-developers");
        this.submit("Update");
        this.assertIndexedFieldCorrect("//item/comments", EasyMap.build((Object)"comment", (Object)COMMENT_2), null, HSP_1);
        this.assertIndexedFieldCorrect("//item/comments", null, EasyMap.build((Object)"comment", (Object)COMMENT_3), HSP_1);
        this.gotoIssue(HSP_1);
        this.clickLink("edit-issue");
        this.setFormElement("comment", COMMENT_3);
        this.selectOption("commentLevel", "Developers");
        this.submit("Update");
        this.assertIndexedFieldCorrect("//item/comments", EasyMap.build((Object)"comment", (Object)COMMENT_3), null, HSP_1);
        this.login("fred", "fred");
        this.gotoIssue(HSP_1);
        this.assertTextPresent(COMMENT_1);
        this.assertTextNotPresent(COMMENT_2);
        this.assertTextNotPresent(COMMENT_3);
        this.login("admin", "admin");
        this.gotoIssue(HSP_1);
        this.assertTextPresent(COMMENT_1);
        this.assertTextPresent(COMMENT_2);
        this.assertTextPresent(COMMENT_3);
    }

    private void editIssueWithTimeTracking(String issueKey1, String issueKey2) {
        TestEditIssue.log("Edit Issue: Test availability of time tracking related fields");
        this.activateTimeTracking();
        this.gotoIssue(issueKey1);
        this.clickLink("edit-issue");
        this.assertFormElementPresent("timetracking");
        this.deactivateTimeTracking();
        this.activateTimeTracking();
        this.logWorkOnIssue(issueKey2, "1d");
        this.gotoIssue(issueKey2);
        this.clickLink("edit-issue");
        this.assertTextPresent("Remaining Estimate");
        this.assertFormElementPresent("timetracking");
        this.assertFormElementEquals("timetracking", "6d");
        this.reconfigureTimetracking("days");
        this.gotoIssue(issueKey2);
        this.clickLink("edit-issue");
        this.assertTextPresent("Remaining Estimate");
        this.assertFormElementPresent("timetracking");
        this.assertFormElementEquals("timetracking", "6d");
        this.reconfigureTimetracking("hours");
        this.gotoIssue(issueKey2);
        this.clickLink("edit-issue");
        this.assertTextPresent("Remaining Estimate");
        this.assertFormElementPresent("timetracking");
        this.assertFormElementEquals("timetracking", "144h");
        this.logWorkOnIssue(issueKey2, "11m");
        this.reconfigureTimetracking("pretty");
        this.gotoIssue(issueKey2);
        this.clickLink("edit-issue");
        this.assertTextPresent("Remaining Estimate");
        this.assertFormElementPresent("timetracking");
        this.assertFormElementEquals("timetracking", "5d 23h 49m");
        this.reconfigureTimetracking("days");
        this.gotoIssue(issueKey2);
        this.clickLink("edit-issue");
        this.assertTextPresent("Remaining Estimate");
        this.assertFormElementPresent("timetracking");
        this.assertFormElementEquals("timetracking", "5d 23h 49m");
        this.reconfigureTimetracking("hours");
        this.gotoIssue(issueKey2);
        this.clickLink("edit-issue");
        this.assertTextPresent("Remaining Estimate");
        this.assertFormElementPresent("timetracking");
        this.assertFormElementEquals("timetracking", "143h 49m");
        this.logWorkOnIssue(issueKey2, "19m");
        this.reconfigureTimetracking("pretty");
        this.gotoIssue(issueKey2);
        this.clickLink("edit-issue");
        this.assertTextPresent("Remaining Estimate");
        this.assertFormElementPresent("timetracking");
        this.assertFormElementEquals("timetracking", "5d 23h 30m");
        this.reconfigureTimetracking("days");
        this.gotoIssue(issueKey2);
        this.clickLink("edit-issue");
        this.assertTextPresent("Remaining Estimate");
        this.assertFormElementPresent("timetracking");
        this.assertFormElementEquals("timetracking", "5d 23.5h");
        this.reconfigureTimetracking("hours");
        this.gotoIssue(issueKey2);
        this.clickLink("edit-issue");
        this.assertTextPresent("Remaining Estimate");
        this.assertFormElementPresent("timetracking");
        this.assertFormElementEquals("timetracking", "143.5h");
        this.logWorkOnIssue(issueKey2, "11h 48m");
        this.reconfigureTimetracking("pretty");
        this.gotoIssue(issueKey2);
        this.clickLink("edit-issue");
        this.assertTextPresent("Remaining Estimate");
        this.assertFormElementPresent("timetracking");
        this.assertFormElementEquals("timetracking", "5d 11h 42m");
        this.reconfigureTimetracking("days");
        this.gotoIssue(issueKey2);
        this.clickLink("edit-issue");
        this.assertTextPresent("Remaining Estimate");
        this.assertFormElementPresent("timetracking");
        this.assertFormElementEquals("timetracking", "5d 11.7h");
        this.reconfigureTimetracking("hours");
        this.gotoIssue(issueKey2);
        this.clickLink("edit-issue");
        this.assertTextPresent("Remaining Estimate");
        this.assertFormElementPresent("timetracking");
        this.assertFormElementEquals("timetracking", "131.7h");
        this.deactivateTimeTracking();
    }

    public void testEditNewComponentAndIssueWithNoChanges() {
        this.restoreData("TestEditIssueWithNoChanges.xml");
        this.getBackdoor().darkFeatures().enableForSite("jira.no.frother.reporter.field");
        this.addComponent("homosapien", ADDED_COMPONENT);
        String issueKey = this.addIssue("homosapien", "HSP", "New Feature", "edit issue test summary", "Blocker", new String[]{ADDED_COMPONENT}, new String[]{"New Version 2"}, new String[]{"New Version 1", "New Version 3"}, "Administrator", "edit environment", "edit issue description", "5d", null, "14/Feb/07");
        this.gotoIssue(issueKey);
        this.assertNewComponentAndIssueViewPage();
        this.clickLink("edit-issue");
        this.setWorkingForm("issue-edit");
        this.assertFormElementHasValue("issue-edit", "summary", "edit issue test summary");
        this.assertFormTextAreaHasValue("issue-edit", "environment", "edit environment");
        this.assertFormTextAreaHasValue("issue-edit", "description", "edit issue description");
        this.assertions.getProjectFieldsAssertions().assertIssueTypeIsSelected("New Feature");
        this.assertOptionSelected("priority", "Blocker");
        this.assertFormElementHasValue("issue-edit", "duedate", "14/Feb/07");
        this.assertOptionSelected("components", ADDED_COMPONENT);
        this.assertOptionSelected("fixVersions", "New Version 1");
        this.assertOptionSelected("fixVersions", "New Version 3");
        this.assertOptionSelected("versions", "New Version 2");
        this.assertOptionSelected("assignee", "Administrator");
        this.assertFormElementHasValue("issue-edit", "reporter", "admin");
        this.assertFormElementHasValue("issue-edit", "timetracking", "5d");
        this.submit("Update");
        this.assertNewComponentAndIssueViewPage();
    }

    private void assertNewComponentAndIssueViewPage() {
        this.assertLinkPresentWithText("homosapien");
        this.assertTextPresentBeforeText("Type", "New Feature");
        this.assertTextPresent("edit issue test summary");
        this.assertTextPresentBeforeText("Priority", "Blocker");
        this.assertTextPresentBeforeText("Due", "14/Feb/07");
        this.assertTextPresentBeforeText("Component/s", ADDED_COMPONENT);
        this.assertTextPresentBeforeText("Affects Version/s", "New Version 2");
        this.assertTextPresentBeforeText("Fix Version/s", "New Version 1");
        this.assertTextPresentBeforeText("Fix Version/s", "New Version 3");
        this.assertTextPresentBeforeText("Assignee", "Administrator");
        this.assertTextPresentBeforeText("Reporter", "Administrator");
        this.assertTextPresentBeforeText("Environment", "edit environment");
        this.assertTextPresentBeforeText("Description", "edit issue description");
    }

    public void testEditIssueWithCustomFieldsAndNoChanges() {
        this.restoreData("TestEditIssueWithNoChanges.xml");
        this.getBackdoor().darkFeatures().enableForSite("jira.no.frother.reporter.field");
        this.gotoIssue(HSP_1);
        this.assertInitialViewIssueFieldValues();
        this.clickLink("edit-issue");
        this.assertInitialEditIssueFieldValues();
        this.setWorkingForm("issue-edit");
        this.submit();
        this.assertInitialViewIssueFieldValues();
    }

    public void testEditIssueWithCustomFieldsAndRemoveValues() {
        this.restoreData("TestEditIssueWithNoChanges.xml");
        this.getBackdoor().darkFeatures().enableForSite("jira.no.frother.reporter.field");
        this.gotoIssue(HSP_1);
        this.assertInitialViewIssueFieldValues();
        this.assertNoChangesForIssue(HSP_1);
        this.clickLink("edit-issue");
        this.assertInitialEditIssueFieldValues();
        this.navigation.issue().selectIssueType("Task", "issuetype");
        this.selectOption("priority", "Critical");
        this.selectOption("components", "Unknown");
        this.selectOption("versions", "Unknown");
        this.selectOption("fixVersions", "Unknown");
        this.setFormElement("description", "");
        this.setFormElement("environment", "");
        this.setFormElement("reporter", "admin");
        this.setFormElement("timetracking", "");
        this.selectOption("customfield_10000", "None");
        this.selectOption("customfield_10000:1", "None");
        this.setFormElement("customfield_10001", "");
        this.setFormElement("customfield_10002", "");
        this.setFormElement("customfield_10003", "");
        this.setFormElement("customfield_10004", "");
        this.uncheckCheckbox("customfield_10006", "10008");
        this.setFormElement("customfield_10007", "");
        this.selectOption("customfield_10008", "None");
        this.setFormElement("customfield_10009", "");
        this.setFormElement("customfield_10010", "");
        this.selectOption("customfield_10011", "None");
        this.checkCheckbox("customfield_10012", "-1");
        this.selectOption("customfield_10014", "None");
        this.selectOption("customfield_10015", "Unknown");
        this.setFormElement("customfield_10016", "");
        this.setFormElement("customfield_10017", "");
        this.setFormElement("customfield_10018", "");
        this.selectOption("customfield_10019", "Unknown");
        this.setWorkingForm("issue-edit");
        this.submit("Update");
        this.assertLastChangeHistoryIs(HSP_1, "Issue Type", "Improvement", "Task");
        this.assertLastChangeHistoryIs(HSP_1, "Text Field", "text field", "");
        this.assertLastChangeHistoryIs(HSP_1, "Environment", "test environment 1", "");
        this.assertLastChangeHistoryIs(HSP_1, "Project Picker", "monkey", "");
        this.assertLastChangeHistoryIs(HSP_1, "Group Picker", "jira-users", "");
        this.assertLastChangeHistoryIs(HSP_1, "Multi Select", "value 1", "");
        this.assertLastChangeHistoryIs(HSP_1, "Multi Select", "value 2", "");
        this.assertLastChangeHistoryIs(HSP_1, "Number Field", "12345", "");
        this.assertLastChangeHistoryIs(HSP_1, "Component/s", "New Component 1", "");
        this.assertLastChangeHistoryIs(HSP_1, "Component/s", "New Component 3", "");
        this.assertLastChangeHistoryIs(HSP_1, "Fix Version/s", "New Version 2", "");
        this.assertLastChangeHistoryIs(HSP_1, "Free Text Field", "this is a free text", "");
        this.assertLastChangeHistoryIs(HSP_1, "Multi User Picker", "admin", "");
        this.assertLastChangeHistoryIs(HSP_1, "Affects Version/s", "New Version 1", "");
        this.assertLastChangeHistoryIs(HSP_1, "Affects Version/s", "New Version 3", "");
        this.assertLastChangeHistoryIs(HSP_1, "User Picker", "admin", "");
        this.assertLastChangeHistoryIs(HSP_1, "Priority", "Trivial", "Critical");
        this.assertLastChangeHistoryIs(HSP_1, "URL Field", "http://www.atlassian.com", "");
        this.assertLastChangeHistoryIs(HSP_1, "Date Picker", "13/Feb/07", "");
        this.assertLastChangeHistoryIs(HSP_1, "Radio Buttons", "value 3", "");
        this.assertLastChangeHistoryIs(HSP_1, "Multi Group Picker", "jira-developers", "");
        this.assertLastChangeHistoryIs(HSP_1, "Multi Group Picker", "jira-users", "");
        this.assertLastChangeHistoryIs(HSP_1, "Cascading Select", "Parent values: value 1", "");
        this.assertLastChangeHistoryIs(HSP_1, "Cascading Select", "Level 1 values: value 1.2", "");
        this.assertLastChangeHistoryIs(HSP_1, "Remaining Estimate", "3 days", "");
        this.assertLastChangeHistoryIs(HSP_1, "Select List", "value 3", "");
        this.assertLastChangeHistoryIs(HSP_1, "Description", "test editing issue without any changes", "");
        this.assertLastChangeHistoryIs(HSP_1, "Date Time", "12/Feb/07 11:26 AM", "");
        this.assertLastChangeHistoryIs(HSP_1, "Multi Checkboxes", "value 3", "");
    }

    public void testEditIssueWithCustomFieldsAndChangeValues() {
        this.restoreData("TestEditIssueWithNoChanges.xml");
        this.getBackdoor().darkFeatures().enableForSite("jira.no.frother.reporter.field");
        this.gotoIssue(HSP_1);
        this.assertInitialViewIssueFieldValues();
        this.assertNoChangesForIssue(HSP_1);
        this.clickLink("edit-issue");
        this.assertInitialEditIssueFieldValues();
        this.setFormElement("summary", "new summary");
        this.setFormElement("description", "new description");
        this.setFormElement("environment", "new environment");
        this.navigation.issue().selectIssueType("Bug", "issuetype");
        this.selectOption("priority", "Minor");
        this.selectOption("components", "New Component 2");
        this.selectOption("versions", "New Version 2");
        this.selectOption("fixVersions", "New Version 1");
        this.selectOption("fixVersions", "New Version 1");
        this.setFormElement("timetracking", "1d");
        this.selectOption("customfield_10000", "value 2");
        this.selectOption("customfield_10000:1", "value 2.1");
        this.setFormElement("customfield_10001", "21/Feb/07");
        this.setFormElement("customfield_10002", "21/Feb/07 11:30 AM");
        this.setFormElement("customfield_10003", "new free text field");
        this.setFormElement("customfield_10004", "jira-developers");
        this.checkCheckbox("customfield_10006", "10007");
        this.setFormElement("customfield_10007", "jira-administrators, jira-users");
        this.selectMultiOption("customfield_10008", "value 3");
        this.selectMultiOption("customfield_10008", "value 2");
        this.setFormElement("customfield_10009", "fred");
        this.setFormElement("customfield_10010", "54321");
        this.selectOption("customfield_10011", "homosapien");
        this.checkCheckbox("customfield_10012", "10012");
        this.selectOption("customfield_10014", "value 2");
        this.selectOption("customfield_10015", "New Version 2");
        this.setFormElement("customfield_10016", "text field modified");
        this.setFormElement("customfield_10017", "http://www.atlassian.com/software/jira");
        this.setFormElement("customfield_10018", "fred");
        this.selectOption("customfield_10019", "New Version 2");
        this.submit("Update");
        this.assertLastChangeHistoryIs(HSP_1, "Issue Type", "Improvement", "Bug");
        this.assertLastChangeHistoryIs(HSP_1, "Text Field", "text field", "text field modified");
        this.assertLastChangeHistoryIs(HSP_1, "Environment", "test environment 1", "new environment");
        this.assertLastChangeHistoryIs(HSP_1, "Project Picker", "monkey", "homosapien");
        this.assertLastChangeHistoryIs(HSP_1, "Group Picker", "jira-users", "jira-developers");
        this.assertLastChangeHistoryIs(HSP_1, "Multi Select", "value 1", "value 3");
        this.assertLastChangeHistoryIs(HSP_1, "Multi Select", "value 2", "value 2");
        this.assertLastChangeHistoryIs(HSP_1, "Number Field", "12345", "54321");
        this.assertLastChangeHistoryIs(HSP_1, "Component/s", "New Component 1", "");
        this.assertLastChangeHistoryIs(HSP_1, "Component/s", "New Component 3", "");
        this.assertLastChangeHistoryIs(HSP_1, "Component/s", "", "New Component 2");
        this.assertLastChangeHistoryIs(HSP_1, "Fix Version/s", "New Version 2", "");
        this.assertLastChangeHistoryIs(HSP_1, "Fix Version/s", "", "New Version 1");
        this.assertLastChangeHistoryIs(HSP_1, "Free Text Field", "this is a free text", "new free text field");
        this.assertLastChangeHistoryIs(HSP_1, "Multi User Picker", "admin", "fred");
        this.assertLastChangeHistoryIs(HSP_1, "Affects Version/s", "New Version 1", "");
        this.assertLastChangeHistoryIs(HSP_1, "Affects Version/s", "New Version 3", "");
        this.assertLastChangeHistoryIs(HSP_1, "Affects Version/s", "", "New Version 2");
        this.assertLastChangeHistoryIs(HSP_1, "User Picker", "admin", "fred");
        this.assertLastChangeHistoryIs(HSP_1, "Priority", "Trivial", "Minor");
        this.assertLastChangeHistoryIs(HSP_1, "Summary", "test edit issue with no changes", "new summary");
        this.assertLastChangeHistoryIs(HSP_1, "URL Field", "http://www.atlassian.com", "http://www.atlassian.com/software/jira");
        this.assertLastChangeHistoryIs(HSP_1, "Date Picker", "13/Feb/07", "21/Feb/07");
        this.assertLastChangeHistoryIs(HSP_1, "Radio Buttons", "value 3", "value 1");
        this.assertLastChangeHistoryIs(HSP_1, "Multi Group Picker", "jira-developers", "jira-administrators");
        this.assertLastChangeHistoryIs(HSP_1, "Multi Group Picker", "jira-users", "jira-users");
        this.assertLastChangeHistoryIs(HSP_1, "Cascading Select", "Parent values: value 1", "Parent values: value 2");
        this.assertLastChangeHistoryIs(HSP_1, "Cascading Select", "Level 1 values: value 1.2", "Level 1 values: value 2.1");
        this.assertLastChangeHistoryIs(HSP_1, "Remaining Estimate", "3 days", "1 day");
        this.assertLastChangeHistoryIs(HSP_1, "Single Version Picker", "New Version 3", "New Version 2");
        this.assertLastChangeHistoryIs(HSP_1, "Version Picker", "New Version 1", "New Version 2");
        this.assertLastChangeHistoryIs(HSP_1, "Version Picker", "New Version 3", "New Version 2");
        this.assertLastChangeHistoryIs(HSP_1, "Select List", "value 3", "value 2");
        this.assertLastChangeHistoryIs(HSP_1, "Description", "test editing issue without any changes", "new description");
        this.assertLastChangeHistoryIs(HSP_1, "Date Time", "12/Feb/07 11:26 AM", "21/Feb/07 11:30 AM");
        this.assertLastChangeHistoryIs(HSP_1, "Multi Checkboxes", "value 3", "value 2");
    }

    private void assertInitialViewIssueFieldValues() {
        this.assertLinkPresentWithText("homosapien");
        this.assertTextPresentBeforeText("Type", "Improvement");
        this.assertTextPresent("test edit issue with no changes");
        this.assertTextPresentBeforeText("Priority", "Trivial");
        this.assertTextPresentBeforeText("Due", "14/Feb/07");
        this.assertTextPresentBeforeText("Component/s", "New Component 1");
        this.assertTextPresentBeforeText("Component/s", "New Component 3");
        this.assertTextPresentBeforeText("Affects Version/s", "New Version 1");
        this.assertTextPresentBeforeText("Affects Version/s", "New Version 3");
        this.assertTextPresentBeforeText("Fix Version/s", "New Version 2");
        this.assertTextPresentBeforeText("Assignee", "Administrator");
        this.assertTextPresentBeforeText("Reporter", "Administrator");
        this.assertTextPresentBeforeText("Environment", "test environment 1");
        this.assertTextPresentBeforeText("Description", "test editing issue without any changes");
        TreeMap<String, Object> fieldValues = new TreeMap<String, Object>();
        fieldValues.put("Cascading Select", new String[]{"value 1", "value 1.2"});
        fieldValues.put("Date Picker", "13/Feb/07");
        fieldValues.put("Date Time", "12/Feb/07 11:26 AM");
        fieldValues.put("Free Text Field", "this is a free text");
        fieldValues.put("Group Picker", "jira-users");
        fieldValues.put("Multi Checkboxes", "value 3");
        fieldValues.put("Multi Group Picker", new String[]{"jira-developers", "jira-users"});
        fieldValues.put("Multi Select", new String[]{"value 1", "value 2"});
        fieldValues.put("Multi User Picker", "Administrator");
        fieldValues.put("Number Field", "12,345");
        fieldValues.put("Project Picker", "monkey");
        fieldValues.put("Radio Buttons", "value 3");
        fieldValues.put("Select List", "value 3");
        fieldValues.put("Single Version Picker", "New Version 3");
        fieldValues.put("Text Field", "text field");
        fieldValues.put("URL Field", "http://www.atlassian.com");
        fieldValues.put("User Picker", "Administrator");
        fieldValues.put("Version Picker", new String[]{"New Version 1", "New Version 3"});
        ViewIssueDetails details = this.parse.issue().parseViewIssuePage();
        for (Map.Entry entry : fieldValues.entrySet()) {
            String actualValue = details.getCustomFields().get(entry.getKey());
            if (actualValue == null) {
                TestEditIssue.fail((String)("Unable to find a value for field '" + (String)entry.getKey() + "'."));
                continue;
            }
            if (entry.getValue() instanceof String[]) {
                for (String v : (String[])entry.getValue()) {
                    this.text.assertTextPresent(actualValue, v);
                }
                continue;
            }
            this.text.assertTextPresent(actualValue, entry.getValue().toString());
        }
    }

    private void assertInitialEditIssueFieldValues() {
        this.setWorkingForm("issue-edit");
        this.assertFormElementHasValue("issue-edit", "summary", "test edit issue with no changes");
        this.assertions.getProjectFieldsAssertions().assertIssueTypeIsSelected("Improvement");
        this.assertOptionSelected("priority", "Trivial");
        this.assertFormElementHasValue("issue-edit", "duedate", "14/Feb/07");
        this.assertOptionSelected("components", "New Component 1");
        this.assertOptionSelected("components", "New Component 3");
        this.assertOptionSelected("versions", "New Version 1");
        this.assertOptionSelected("versions", "New Version 3");
        this.assertOptionSelected("fixVersions", "New Version 2");
        this.assertOptionSelected("assignee", "Administrator");
        this.assertFormElementHasValue("issue-edit", "reporter", "admin");
        this.assertFormTextAreaHasValue("issue-edit", "environment", "test environment 1");
        this.assertFormTextAreaHasValue("issue-edit", "description", "test editing issue without any changes");
        this.assertFormElementHasValue("issue-edit", "timetracking", "3d");
        this.assertOptionSelected("customfield_10000", "value 1");
        this.assertOptionSelected("customfield_10000:1", "value 1.2");
        this.assertFormElementHasValue("issue-edit", "customfield_10001", "13/Feb/07");
        this.assertFormElementHasValue("issue-edit", "customfield_10002", "12/Feb/07 11:26 AM");
        this.assertFormTextAreaHasValue("issue-edit", "customfield_10003", "this is a free text");
        this.assertFormElementHasValue("issue-edit", "customfield_10004", "jira-users");
        this.checkCheckbox("customfield_10006", "10008");
        this.assertFormTextAreaHasValue("issue-edit", "customfield_10007", "jira-developers, jira-users");
        this.assertOptionSelected("customfield_10008", "value 1");
        this.assertOptionSelected("customfield_10008", "value 2");
        this.assertFormTextAreaHasValue("issue-edit", "customfield_10009", "admin");
        this.assertFormElementHasValue("issue-edit", "customfield_10010", "12345");
        this.assertOptionSelected("customfield_10011", "monkey");
        this.assertOptionSelectedById("customfield_10012", "10014");
        this.assertOptionSelected("customfield_10014", "value 3");
        this.assertOptionSelected("customfield_10015", "New Version 3");
        this.assertFormElementHasValue("issue-edit", "customfield_10016", "text field");
        this.assertFormElementHasValue("issue-edit", "customfield_10017", "http://www.atlassian.com");
        this.assertFormElementHasValue("issue-edit", "customfield_10018", "admin");
        this.assertOptionSelected("customfield_10019", "New Version 1");
        this.assertOptionSelected("customfield_10019", "New Version 3");
    }
}

