/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestCreateIssue
extends JIRAWebTest {
    private static final String PROJECT_MONKEY_ID = "10001";
    private static final String PROJECT_HOMOSAPIEN_ID = "10000";
    private static final String LOGIN = "log in";

    public TestCreateIssue(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.administration.restoreBlankInstance();
        this.getBackdoor().darkFeatures().enableForSite("jira.no.frother.reporter.field");
    }

    @Override
    public void tearDown() {
        this.getBackdoor().darkFeatures().disableForSite("jira.no.frother.reporter.field");
        super.tearDown();
    }

    public void testCreateIssueInJiraWithSingleProjectAndSingleIssueType() {
        this.tester.clickLink("create_link");
        this.assertTextPresent("Create Issue");
        this.assertTextNotPresent("CreateIssueDetails.jspa");
        this.assertFormElementPresent("pid");
        this.assertFormElementPresent("issuetype");
        this.assertFormElementNotPresent("summary");
        this.administration.restoreData("TestOneProjectWithOneIssueType.xml");
        this.tester.clickLink("create_link");
        this.assertTextPresent("CreateIssueDetails.jspa");
        this.assertTextSequence(new String[]{"Project", "homosapien", "Issue Type", "Bug"});
        this.assertFormElementPresent("summary");
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.tester.gotoPage("/secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.checkCheckbox("createType", "chooseScheme");
        this.tester.selectOption("schemeId", "Bugs & Sub-tasks");
        this.tester.submit();
        if (this.tester.getDialog().isLinkPresent("leave_admin")) {
            this.tester.clickLink("leave_admin");
        }
        this.tester.clickLink("create_link");
        this.assertTextPresent("CreateIssueDetails.jspa");
        this.assertTextSequence(new String[]{"Project", "homosapien", "Issue Type", "Bug"});
        this.assertFormElementPresent("summary");
    }

    public void testCreateIssue() {
        this.resetFields();
        String issueKey1 = this.createIssue();
        String issueKey2 = this.createIssueWithoutComponents();
        String issueKey3 = this.createIssueWithTimeTrackingDetails();
        String issueKey4 = this.createIssueWithoutAssignee();
        this.createIssueWithNoSummary();
        this.createIssueWithRequiredFields();
        this.createIssueWithHiddenFields();
        this.createIssueWithInvalidDueDate();
        this.createIssueWithCreatePermission();
        this.createIssueWithSchedulePermission();
        this.createIssueWithAssignPermission();
        this.createIssueWithModifyReporterPermission();
        this.createIssueWithTimeTracking();
        this.createIssueWithUnassignableUser();
        this.deleteCreatedIssue(issueKey1);
        this.deleteCreatedIssue(issueKey2);
        this.deleteCreatedIssue(issueKey3);
        this.deleteCreatedIssue(issueKey4);
        this.createIssueWithNoBrowsePermission();
    }

    public void testCreateIssueSkipStep1OnlyOneProjectAndOneIssueType() {
        String[] data;
        for (String dataBackup : data = new String[]{"TestCreateIssueOneProjectOneIssueType.xml", "TestCreateIssueOneIssueCreateProjectOneIssueType.xml"}) {
            this.navigation.gotoDashboard();
            this.administration.restoreData(dataBackup);
            this.assertRedirectAndFollow("/secure/CreateIssue!default.jspa", ".*CreateIssue\\.jspa\\?pid=10001&issuetype=3$");
            this.assertTextSequence(new String[]{"Create Issue", "CreateIssueDetails.jspa", "Project", "monkey", "Issue Type", "Task", "Summary"});
        }
    }

    public void testCreateIssueSkipStep1IssueTypeSchemeInfersOneProjectAndIssueType() {
        this.administration.restoreData("TestCreateMonkeyHasOneIssueType.xml");
        this.navigation.browseProject("MKY");
        this.tester.clickLink("create_link");
        this.assertRadioOptionSelected("pid", PROJECT_MONKEY_ID);
        this.assertTextSequence(new String[]{"Create Issue"});
        this.assertRedirectAndFollow("/secure/CreateIssue!default.jspa?pid=10001", ".*CreateIssue\\.jspa\\?pid=10001&issuetype=1$");
        this.assertTextSequence(new String[]{"Create Issue", "CreateIssueDetails.jspa", "Project", "monkey", "Issue Type", "Bug", "Summary"});
        this.tester.gotoPage("/secure/CreateIssue!default.jspa?pid=10000");
        this.assertRadioOptionSelected("pid", PROJECT_HOMOSAPIEN_ID);
        this.assertTextSequence(new String[]{"Create Issue"});
        this.navigation.logout();
        this.tester.gotoPage("/secure/CreateIssue!default.jspa?pid=10001");
        this.assertTextPresent("You are not logged in, and do not have the permissions required to create an issue in this project as a guest.");
        this.tester.clickLinkWithText(LOGIN);
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        this.assertTextSequence(new String[]{"Create Issue", "CreateIssueDetails.jspa", "Project", "monkey", "Issue Type", "Bug", "Summary"});
    }

    public void testCreateIssueUserHasNoCreateIssuePermission() {
        this.administration.restoreData("TestCreateIssueOneProjectOneIssueType.xml");
        this.navigation.login("fred");
        this.assertLinkNotPresent("create_link");
        this.navigation.browseProject("MKY");
        this.assertLinkNotPresentWithText("Create a new issue in project monkey");
        this.tester.gotoPage("/secure/CreateIssue!default.jspa?pid=10001");
        this.assertTextPresent("Error");
        this.assertTextPresent("You do not have permission to create issues in this project.");
        this.tester.gotoPage("/secure/CreateIssue!default.jspa");
        this.tester.assertTitleEquals("Error - jWebTest JIRA installation");
        this.text.assertTextPresent(new CssLocator(this.tester, "#content .error"), "You have not selected a valid project to create an issue in.");
    }

    public void testCreateIssueWithNoPidInUrlOneProjectAvailableIssueTypeInUrl() {
        this.administration.restoreData("TestCreateIssueOneProjectThreeIssueTypes.xml");
        this.tester.clickLink("create_link");
        this.assertTextSequence(new String[]{"Create Issue"});
        String monkeyTask = ".*CreateIssue\\.jspa\\?pid=10001&issuetype=3$";
        this.assertRedirectAndFollow("/secure/CreateIssue!default.jspa?issuetype=3", ".*CreateIssue\\.jspa\\?pid=10001&issuetype=3$");
        this.assertTextSequence(new String[]{"Create Issue", "CreateIssueDetails.jspa", "Project", "monkey", "Issue Type", "Task", "Summary"});
    }

    private void deleteCreatedIssue(String issueKey) {
        this.navigation.issue().deleteIssue(issueKey);
        this.assertPageDoesNotExist("The issue has not been removed from the index.", "/si/jira.issueviews:issue-xml/" + issueKey + "/" + issueKey + ".xml?jira.issue.searchlocation=index");
    }

    public String createIssue() {
        String issueKey = this.addIssue("homosapien", "HSP", "Bug", "test 1", "Minor", new String[]{"New Component 1"}, new String[]{"New Version 1"}, new String[]{"New Version 1"}, "Administrator", "test environment 1", "test description 1 for test create issue", null, null, null);
        this.assertTextPresent("test 1");
        this.assertTextPresent("Bug");
        this.assertTextPresent("Minor");
        this.assertIndexedFieldCorrect("//item", (Map)ImmutableMap.of((Object)"summary", (Object)"test 1"), null, issueKey);
        this.assertIndexedFieldCorrect("//item", (Map)ImmutableMap.of((Object)"key", (Object)issueKey), null, issueKey);
        return issueKey;
    }

    public String createIssueWithoutComponents() {
        String issueKey = this.addIssue("homosapien", "HSP", "Improvement", "test 2", "Major", null, null, null, "Administrator", "test environment 2", "test description 2 for test create issue", null, null, null);
        this.assertTextPresent("test 2");
        this.assertTextPresent("Improvement");
        this.assertTextPresent("Major");
        this.assertIndexedFieldCorrect("//item", (Map)ImmutableMap.of((Object)"type", (Object)"Improvement"), null, issueKey);
        this.assertIndexedFieldCorrect("//item", (Map)ImmutableMap.of((Object)"summary", (Object)"test 2"), null, issueKey);
        return issueKey;
    }

    public String createIssueWithTimeTrackingDetails() {
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        String issueKey = this.addIssue("homosapien", "HSP", "New Feature", "test 3", "Critical", null, null, null, "Administrator", "test environment 3", "test description 3 for test create issue", "1w", null, null);
        this.assertTextPresent("test 3");
        this.assertTextPresent("New Feature");
        this.assertTextPresent("Critical");
        this.assertTextPresent("Original Estimate");
        this.assertTextPresent("1 week");
        this.assertIndexedFieldCorrect("//item", (Map)ImmutableMap.of((Object)"priority", (Object)"Critical"), null, issueKey);
        this.assertIndexedFieldCorrect("//item", (Map)ImmutableMap.of((Object)"type", (Object)"New Feature"), null, issueKey);
        this.administration.timeTracking().disable();
        return issueKey;
    }

    public String createIssueWithoutAssignee() {
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
        String issueKey = this.addIssue("homosapien", "HSP", "Task", "test 4", "Blocker", new String[]{"New Component 1"}, null, null, "Unassigned", "test environment 4", "test description 4 for test create issue", null, null, null);
        this.assertTextPresent("test 4");
        this.assertTextPresent("Task");
        this.assertTextPresent("Blocker");
        this.assertTextPresentBeforeText("Assignee:", "Unassigned");
        this.assertIndexedFieldCorrect("//item", (Map)ImmutableMap.of((Object)"priority", (Object)"Blocker"), null, issueKey);
        this.assertIndexedFieldCorrect("//item", (Map)ImmutableMap.of((Object)"environment", (Object)"test environment 4"), null, issueKey);
        this.navigation.issue().assignIssue(issueKey, "Assigning issue to ADMIN", "Administrator");
        this.administration.generalConfiguration().setAllowUnassignedIssues(false);
        return issueKey;
    }

    public void createIssueWithNoSummary() {
        TestCreateIssue.log("Create Issue: Adding issue without summary");
        this.createIssueStep1();
        this.tester.selectOption("priority", "Minor");
        this.tester.submit();
        this.assertTextPresent("CreateIssueDetails.jspa");
        this.assertTextPresent("You must specify a summary of the issue.");
    }

    public void createIssueWithRequiredFields() {
        this.setRequiredFields();
        TestCreateIssue.log("Create Issue: Test the creation of an issue using required fields");
        this.createIssueStep1();
        this.tester.setFormElement("summary", "This is a new summary");
        this.tester.setFormElement("reporter", "");
        this.tester.submit("Create");
        this.assertTextPresent("CreateIssueDetails.jspa");
        this.assertTextPresent("Component/s is required");
        this.assertTextPresent("Affects Version/s is required");
        this.assertTextPresent("Fix Version/s is required");
        this.resetFields();
    }

    public void createIssueWithHiddenFields() {
        this.setHiddenFields("Component/s");
        this.setHiddenFields("Affects Version/s");
        this.setHiddenFields("Fix Version/s");
        TestCreateIssue.log("Create Issue: Test the creation of am issue using hidden fields");
        this.createIssueStep1();
        this.assertFormElementNotPresent("components");
        this.assertFormElementNotPresent("versions");
        this.assertFormElementNotPresent("fixVersions");
        this.resetFields();
    }

    public void createIssueWithInvalidDueDate() {
        TestCreateIssue.log("Create Issue: Adding issue with invalid due date");
        this.createIssueStep1();
        this.assertTextPresent("CreateIssueDetails.jspa");
        this.tester.setFormElement("summary", "stuff");
        this.tester.setFormElement("duedate", "stuff");
        this.tester.submit("Create");
        this.assertTextPresent("CreateIssueDetails.jspa");
        this.assertTextPresent("You did not enter a valid date. Please enter the date in the format &quot;d/MMM/yy&quot;");
    }

    public void createIssueWithCreatePermission() {
        TestCreateIssue.log("Create Issue: Test availability of 'Create Issue' link with 'Create Issue' permission.");
        this.administration.permissionSchemes().defaultScheme().removePermission(ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.getNavigation().gotoDashboard();
        this.assertLinkNotPresent("create_link");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.getNavigation().gotoDashboard();
        this.assertLinkPresent("create_link");
    }

    public void createIssueWithSchedulePermission() {
        TestCreateIssue.log("Create Issue: Test prescence of 'Due Date' field with 'Schedule Issue' permission.");
        this.administration.permissionSchemes().defaultScheme().removePermission(ProjectPermissions.SCHEDULE_ISSUES, "jira-developers");
        this.createIssueStep1();
        this.assertTextNotPresent("Due Date");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.SCHEDULE_ISSUES, "jira-developers");
        this.createIssueStep1();
        this.assertTextPresent("Due Date");
    }

    public void createIssueWithAssignPermission() {
        TestCreateIssue.log("Create Issue: Test ability to specify assignee with 'Assign Issue' permission.");
        this.administration.permissionSchemes().defaultScheme().removePermission(ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.createIssueStep1();
        this.assertFormElementNotPresent("assignee");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.createIssueStep1();
        this.assertFormElementPresent("assignee");
    }

    public void createIssueWithModifyReporterPermission() {
        TestCreateIssue.log("Create Issue: Test availability of Reporter with 'Modify Reporter' permission.");
        this.administration.permissionSchemes().defaultScheme().removePermission(ProjectPermissions.MODIFY_REPORTER, "jira-administrators");
        this.createIssueStep1();
        this.assertFormElementNotPresent("reporter");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.MODIFY_REPORTER, "jira-administrators");
        this.createIssueStep1();
        this.assertFormElementPresent("reporter");
    }

    public void createIssueWithTimeTracking() {
        TestCreateIssue.log("Create Issue: Test availability of time tracking ...");
        this.administration.timeTracking().disable();
        this.createIssueStep1();
        this.assertFormElementNotPresent("timetracking");
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.createIssueStep1();
        this.assertFormElementPresent("timetracking");
        this.administration.timeTracking().disable();
    }

    public void createIssueWithUnassignableUser() {
        TestCreateIssue.log("Create Issue: Attempt to set the assignee to be an unassignable user ...");
        this.administration.permissionSchemes().defaultScheme().removePermission(ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
        this.createIssueStep1();
        this.tester.submit("Create");
        this.tester.setFormElement("summary", "Test summary");
        this.assertTextPresent("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
    }

    public void createIssueWithNoBrowsePermission() {
        TestCreateIssue.log("Create Issue: Adding issue with no browse permission for user");
        this.administration.restoreData("TestCantViewCreatedIssue.xml");
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.addIssueOnly("noBrowseProject", "NBP", "Bug", "test1", "Minor", null, null, null, null, null, "description", null, null, null);
        this.assertIssueCreatedButCannotView(false);
        this.tester.clickLinkWithText(LOGIN);
        this.tester.setFormElement("os_username", "nobrowseuser");
        this.tester.setFormElement("os_password", "nobrowseuser");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        this.assertIssueCreatedButCannotView(true);
        this.addIssueOnly("noBrowseProject", "NBP", "Bug", "test1", "Minor", null, null, null, null, null, "description", null, null, null);
        this.assertIssueCreatedButCannotView(true);
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.addIssueOnly("noBrowseProject", "NBP", "Bug", "test1", "Minor", null, null, null, null, null, "description", null, null, null);
        this.assertIssueCreatedButCannotView(false);
        this.tester.clickLinkWithText(LOGIN);
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        this.assertTextNotPresent("Issue Created Successfully");
        this.assertLinkNotPresentWithText(LOGIN);
        this.assertTextPresent("Details");
        this.administration.restoreBlankInstance();
    }

    public void testEscapeProjectNameOnFirstScreenOfCreateIssue() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.tester.clickLink("add_project");
        this.tester.setFormElement("name", "Xss Project &trade;");
        this.tester.setFormElement("key", "XP");
        this.tester.setFormElement("lead", "admin");
        this.tester.submit("Add");
        if (this.tester.getDialog().isLinkPresent("leave_admin")) {
            this.tester.clickLink("leave_admin");
        }
        this.tester.clickLink("create_link");
        this.assertTextNotPresent("&trade;");
        this.assertTextPresent("&amp;trade;");
    }

    public void testXssInDueDate() {
        String value = "\"><script>";
        String valueEncoded = "&quot;&gt;&lt;script&gt;";
        String expectedFormElement = "<input class=\"text medium-field\" id=\"duedate\" name=\"duedate\" type=\"text\" value=\"";
        String notExpected = "<input class=\"text medium-field\" id=\"duedate\" name=\"duedate\" type=\"text\" value=\"\"><script>\"";
        String expected = "<input class=\"text medium-field\" id=\"duedate\" name=\"duedate\" type=\"text\" value=\"&quot;&gt;&lt;script&gt;\"";
        this.tester.clickLink("create_link");
        this.tester.submit("Next");
        this.tester.setFormElement("duedate", "\"><script>");
        this.tester.submit("Create");
        this.text.assertTextPresent(this.locator.page().getHTML(), "<input class=\"text medium-field\" id=\"duedate\" name=\"duedate\" type=\"text\" value=\"&quot;&gt;&lt;script&gt;\"");
        this.text.assertTextNotPresent(this.locator.page().getHTML(), "<input class=\"text medium-field\" id=\"duedate\" name=\"duedate\" type=\"text\" value=\"\"><script>\"");
    }

    private void assertIssueCreatedButCannotView(boolean loggedIn) {
        this.assertTextPresent("Issue Created Successfully");
        this.assertTextPresentBeforeText("You have successfully created the issue (", "), however you do not have the permission to view the created issue.");
        if (!loggedIn) {
            this.assertLinkPresentWithText(LOGIN);
        }
    }

    public void testCreateButtonEncoding() {
        this.navigation.userProfile().changeUserLanguage("fran\u00e7ais (France)");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bogue");
        this.assertions.assertNodeHasText(this.xpath("//input[@id='issue-create-submit']/@value"), "Cr\u00e9er");
        this.navigation.userProfile().changeUserLanguageToJiraDefault();
    }
}

