/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.navigator.IssueTypeCondition;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW, Category.ISSUES, Category.CLONE_ISSUE})
public class TestCloneIssueWithValidation
extends FuncTestCase {
    private static final String TEST_WORKFLOW_NAME = "TEST_WORKFLOW";
    private static final String TEST_PROJECT_NAME = "TEST_PROJECT";
    private static final String TEST_PROJECT_KEY = "TEST";
    private static final String ORIGINAL_ISSUE_SUMMARY = "OriginalIssue";
    private static final String DEFAULT_USERNAME_PREFIX = "steve";
    private static final String PERMISSION_REQUIRED_WORKFLOW_VALIDATOR = "com.atlassian.jira.plugin.system.workflow:permission-validator";
    public static final String WORKFLOW_SCHEME_NAME = "SCHEME_NAME";
    public static final String WORKFLOW_SCHEME_DESC = "This is created intentionally for testing";
    private Long projectId;
    private String originalIssueId;
    private Long workflowSchemeId;

    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    @Override
    protected void tearDownTest() {
        super.tearDownTest();
        this.loginAsAdmin();
        this.administration.usersAndGroups().deleteUser(DEFAULT_USERNAME_PREFIX);
        this.administration.project().deleteProject(this.projectId);
        this.backdoor.workflowSchemes().deleteScheme(this.workflowSchemeId.longValue());
        this.administration.workflows().goTo().delete(TEST_WORKFLOW_NAME);
    }

    public void testShouldStopCloneOperation_IfThereIsAnyValidationFailureInCreateTransition() {
        if (!this.administration.usersAndGroups().userExists(DEFAULT_USERNAME_PREFIX)) {
            this.createUsers(DEFAULT_USERNAME_PREFIX);
        }
        this.givenPermissionRequiredValidatorInCreateTransition();
        this.createIssueWhichWillBeClonedLater();
        this.loginAsUserWithoutAdministratorPermission();
        this.goToIssue(this.originalIssueId).andClone();
        this.assertErrorMessageShownUp().goToIssue(this.originalIssueId).assertSelfReferenceCloneLinkNotPresent();
    }

    private void givenPermissionRequiredValidatorInCreateTransition() {
        this.loginAsAdmin();
        this.administration.workflows().goTo().copyWorkflow("jira", TEST_WORKFLOW_NAME);
        this.projectId = this.backdoor.project().addProject(TEST_PROJECT_NAME, TEST_PROJECT_KEY, "admin");
        this.workflowSchemeId = this.backdoor.workflowSchemes().createScheme(TestCloneIssueWithValidation.newWorkflowScheme(WORKFLOW_SCHEME_NAME, WORKFLOW_SCHEME_DESC)).getId();
        this.backdoor.workflowSchemes().updateScheme(this.workflowScheme(this.workflowSchemeId).setDefaultWorkflow(TEST_WORKFLOW_NAME));
        this.backdoor.workflowSchemes().updateScheme(this.workflowScheme(this.workflowSchemeId).setMapping(IssueTypeCondition.IssueType.NEW_FEATURE.getName(), TEST_WORKFLOW_NAME));
        this.administration.project().associateWorkflowScheme(TEST_PROJECT_NAME, WORKFLOW_SCHEME_NAME);
        this.administration.workflows().goTo().workflowInitialStep(TEST_WORKFLOW_NAME).createTransition();
        this.tester.clickLinkWithText("Add validator");
        this.tester.setWorkingForm("jiraform");
        this.tester.checkCheckbox("type", PERMISSION_REQUIRED_WORKFLOW_VALIDATOR);
        this.tester.submit("Add");
        this.tester.selectOption("permissionKey", "Administer Projects");
        this.tester.submit("Add");
        this.tester.clickLink("publish_draft_workflow");
        this.tester.setWorkingForm("publish-workflow");
        this.tester.checkRadioOption("enableBackup", "false");
        this.tester.submit("Publish");
    }

    private static WorkflowSchemeData newWorkflowScheme(String workflowSchemeName, String description) {
        WorkflowSchemeData newWorkflowScheme = new WorkflowSchemeData();
        newWorkflowScheme.setActive(true);
        newWorkflowScheme.setDescription(description);
        newWorkflowScheme.setName(workflowSchemeName);
        return newWorkflowScheme;
    }

    private WorkflowSchemeData workflowScheme(Long id) {
        return this.backdoor.workflowSchemes().getWorkflowScheme(id.longValue());
    }

    private void createIssueWhichWillBeClonedLater() {
        this.loginAsAdmin();
        this.originalIssueId = this.navigation.issue().createIssue(TEST_PROJECT_NAME, IssueTypeCondition.IssueType.NEW_FEATURE.getName(), ORIGINAL_ISSUE_SUMMARY);
    }

    private void loginAsAdmin() {
        this.navigation.logout();
        this.navigation.login("admin");
    }

    private void loginAsUserWithoutAdministratorPermission() {
        this.navigation.logout();
        this.navigation.login(DEFAULT_USERNAME_PREFIX);
    }

    private void createUsers(String ... usernames) {
        if (usernames.length == 0) {
            this.createTenDefaultUsers();
        } else {
            for (String username : usernames) {
                this.administration.usersAndGroups().addUser(username);
            }
        }
    }

    private void createTenDefaultUsers() {
        for (int i = 1; i <= 10; ++i) {
            this.administration.usersAndGroups().addUser(DEFAULT_USERNAME_PREFIX + i);
        }
    }

    private TestCloneIssueWithValidation goToIssue(String issueKey) {
        this.navigation.issue().gotoIssue(issueKey);
        return this;
    }

    private TestCloneIssueWithValidation andClone() {
        this.tester.clickLink("clone-issue");
        this.tester.setWorkingForm("assign-issue");
        this.tester.getDialog().submit();
        return this;
    }

    private TestCloneIssueWithValidation assertSelfReferenceCloneLinkNotPresent() {
        this.tester.assertElementNotPresent("internal-" + this.backdoor.issues().getIssue((String)this.originalIssueId).id + "_10001");
        return this;
    }

    private TestCloneIssueWithValidation assertErrorMessageShownUp() {
        this.tester.assertTextInElement("assign-issue", "User 'steve' doesn't have the 'Administer Projects' permission");
        return this;
    }
}

