/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.webtests.JIRAWebTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.CLONE_ISSUE, Category.ISSUES, Category.SUB_TASKS})
public class TestCloneIssueWithSubTasks
extends JIRAWebTest {
    protected static final String CLONE_LINKS_CHECKBOX_LABEL = "Clone Links";
    protected static final String CLONE_SUBTASKS_CHECKBOX_LABEL = "Clone Sub Tasks";
    protected static final String CLONE_SUMMARY_PREFIX = "CLONE - ";
    protected static final String SUMMARY_FIELD_NAME = "summary";
    protected static final String SUBTASKS_TEXT = "Sub-Tasks";
    protected static final String LINKS_TEXT = "Issue Links";
    protected static final String CLONE_LINKS_CHECKBOX_NAME = "cloneLinks";
    private static final String CLONE_SUBTASKS_CHECKBOX_NAME = "cloneSubTasks";

    public TestCloneIssueWithSubTasks(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestCloneIssueWithSubTasks.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    public void testCloneNoLinks() {
        this.gotoIssueAndClickClone("HSP-1");
        this.assertTextNotPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.assertTextNotPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        String cloneKey = this.cloneIssue("HSP", "Test Issue", false);
        this.assertTextPresentBeforeText("Type", "Task");
        this.assertTextPresentBeforeText("Status", "Open");
        this.assertTextPresentBeforeText("Priority", "Minor");
        this.assertTextPresentBeforeText("Assignee", "Administrator");
        this.assertTextPresentBeforeText("Reporter", "Administrator");
        this.assertTextPresentBeforeText("Vote", "0");
        this.assertTextPresentBeforeText("Watch", "0");
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 2"});
        this.assertTextSequence(new String[]{"Affects Version/s", "New Version 1", "New Version 4"});
        this.assertTextSequence(new String[]{"Fix Version/s", "New Version 4", "New Version 5"});
        this.assertTextSequence(new String[]{"Original Estimate", "4 days", "Remaining Estimate", "4 days", "Time Spent", "Not Specified"});
        this.assertTextSequence(new String[]{"Environment", "Test Environment"});
        this.assertTextPresentBeforeText("Description", "Test Description");
        this.assertTextNotPresent(SUBTASKS_TEXT);
        this.assertTextNotPresent(LINKS_TEXT);
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"type", (Object)"Task", (Object)"status", (Object)"Open", (Object)"priority", (Object)"Minor", (Object)"votes", (Object)"0", (Object)"description", (Object)"Test Description"), null, cloneKey);
    }

    public void testClonePermission() {
        this.gotoIssue("HSP-1");
        this.assertLinkPresent("clone-issue");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.gotoIssue("HSP-1");
        this.assertLinkNotPresent("clone-issue");
    }

    public void testCloneWithLinks() {
        this.gotoIssueAndClickClone("HSP-2");
        this.assertTextPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.assertTextNotPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        this.checkCheckbox(CLONE_LINKS_CHECKBOX_NAME, "true");
        String clonedKey = this.cloneIssue("HSP", "Test Issue with link", false);
        this.assertTextNotPresent(SUBTASKS_TEXT);
        this.assertTextPresent(LINKS_TEXT);
        this.assertTextSequence(new String[]{"out", "HSP-3"});
        this.assertTextSequence(new String[]{"in", "HSP-4"});
        this.assertTextSequence(new String[]{"outward", "HSP-5"});
        this.assertTextSequence(new String[]{"inward", "HSP-6"});
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)SUMMARY_FIELD_NAME, (Object)"CLONE - Test Issue with link", (Object)"resolution", (Object)"Unresolved"), null, clonedKey);
        this.assertIndexedFieldCorrect("//item/issuelinks/issuelinktype", EasyMap.build((Object)"name", (Object)"Test Link 1"), null, clonedKey);
    }

    public void testCloneIssueLinksDisabled() {
        this.disableIssueLinks();
        this.gotoIssueAndClickClone("HSP-2");
        this.assertTextNotPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.cloneIssue("HSP", "Test Issue with link", false);
        this.assertTextNotPresent(LINKS_TEXT);
    }

    public void testCloneWithClonersLink() {
        this.createClonersLinkType();
        String originalIssueKey = "HSP-1";
        this.gotoIssueAndClickClone(originalIssueKey);
        this.assertTextNotPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.assertTextNotPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        String cloneIssueKey = this.cloneIssue("HSP", "Test Issue", true);
        this.assertTextNotPresent(SUBTASKS_TEXT);
        this.assertTextPresent(LINKS_TEXT);
        this.assertTextSequence(new String[]{"clones", originalIssueKey});
        this.gotoIssue(originalIssueKey);
        this.assertTextPresent(LINKS_TEXT);
        this.assertTextSequence(new String[]{"is cloned by", cloneIssueKey});
    }

    protected void gotoIssueAndClickClone(String issueKey) {
        this.gotoIssue(issueKey);
        this.clickLink("clone-issue");
    }

    protected String cloneIssue(String projectKey, String summary, boolean cloneLinkPresent) {
        summary = CLONE_SUMMARY_PREFIX + summary;
        this.assertFormElementEquals(SUMMARY_FIELD_NAME, summary);
        if (cloneLinkPresent) {
            this.assertTextNotPresent("The clone link type \"Cloners\" does not exist. A link to the original issue will not be created.");
        } else {
            this.assertTextPresent("The clone link type \"Cloners\" does not exist. A link to the original issue will not be created.");
        }
        this.submit();
        TestCloneIssueWithSubTasks.assertTrue((this.getDialog().getResponse().getURL().getPath().indexOf("/browse") > -1 ? 1 : 0) != 0);
        this.assertTextPresent(summary);
        try {
            return this.extractIssueKey(projectKey);
        }
        catch (Exception e) {
            TestCloneIssueWithSubTasks.fail((String)("Unable to retrieve issue key" + e.getMessage()));
            return "fail";
        }
    }

    public void testCloneNoLinksWithSubTask() {
        this.gotoIssueAndClickClone("HSP-7");
        this.assertTextNotPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.assertTextPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        this.assertFormElementEquals(CLONE_SUBTASKS_CHECKBOX_NAME, "true");
        this.cloneIssue("HSP", "Test Issue with sub task", false);
        this.assertTextNotPresent(LINKS_TEXT);
        this.assertTextPresent(SUBTASKS_TEXT);
        this.assertTextPresent("Test Sub task");
        this.assertTextPresent("Another Sub Task");
    }

    public void testCloneWithLinksAndSubTasks() {
        this.gotoIssueAndClickClone("HSP-10");
        this.assertTextPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.assertTextPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        this.checkCheckbox(CLONE_LINKS_CHECKBOX_NAME, "true");
        this.cloneIssue("HSP", "Issue with link and sub-task", false);
        this.assertTextPresent(LINKS_TEXT);
        this.assertTextSequence(new String[]{"out", "HSP-3"});
        this.assertTextSequence(new String[]{"inward", "HSP-6"});
        this.assertTextPresent(SUBTASKS_TEXT);
        this.assertTextPresent("Another test subtask");
        this.assertTextPresent("Second sub-task");
    }

    public void testCloneIssueWithLinksAndSubTasksNoLinks() {
        this.gotoIssueAndClickClone("HSP-10");
        this.assertTextPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.assertTextPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        this.cloneIssue("HSP", "Issue with link and sub-task", false);
        this.assertTextNotPresent(LINKS_TEXT);
        this.assertTextPresent(SUBTASKS_TEXT);
        this.assertTextPresent("Another test subtask");
        this.assertTextPresent("Second sub-task");
    }

    public void testCloneIssueWithLinksAndSubTasksNoSubTasks() {
        this.gotoIssueAndClickClone("HSP-10");
        this.assertTextPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.assertTextPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        this.checkCheckbox(CLONE_LINKS_CHECKBOX_NAME, "true");
        this.uncheckCheckbox(CLONE_SUBTASKS_CHECKBOX_NAME);
        this.cloneIssue("HSP", "Issue with link and sub-task", false);
        this.assertTextPresent(LINKS_TEXT);
        this.assertTextSequence(new String[]{"out", "HSP-3"});
        this.assertTextSequence(new String[]{"inward", "HSP-6"});
        this.assertTextNotPresent(SUBTASKS_TEXT);
    }

    public void testCloneIssueWithLinksAndSubTasksNoSubTasksNoLinks() {
        this.gotoIssueAndClickClone("HSP-10");
        this.assertTextPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.assertTextPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        this.uncheckCheckbox(CLONE_SUBTASKS_CHECKBOX_NAME);
        this.cloneIssue("HSP", "Issue with link and sub-task", false);
        this.assertTextNotPresent(LINKS_TEXT);
        this.assertTextNotPresent(SUBTASKS_TEXT);
    }

    public void testCloneIssueWithSubTaskWithLink() {
        this.gotoIssueAndClickClone("HSP-13");
        this.assertTextPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.assertTextPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        this.checkCheckbox(CLONE_LINKS_CHECKBOX_NAME, "true");
        this.cloneIssue("HSP", "Test issue with subtask which has a link", false);
        this.assertTextNotPresent(LINKS_TEXT);
        this.assertTextPresent(SUBTASKS_TEXT);
        String subTaskWithLinkSummary = "Sub task with link";
        this.assertTextPresent(subTaskWithLinkSummary);
        this.assertTextPresent("One more subtask");
        this.clickLinkWithText(subTaskWithLinkSummary);
        this.assertTextPresent(LINKS_TEXT);
        this.assertTextSequence(new String[]{"in", "HSP-4"});
        this.assertTextSequence(new String[]{"outward", "HSP-5"});
    }

    public void testCloneIssueLinksDisabledWithSubTasks() {
        this.disableIssueLinks();
        this.gotoIssueAndClickClone("HSP-10");
        this.assertTextNotPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.assertTextPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        this.cloneIssue("HSP", "Issue with link and sub-task", false);
        this.assertTextNotPresent(LINKS_TEXT);
        this.assertTextPresent(SUBTASKS_TEXT);
        this.assertTextPresent("Another test subtask");
        this.assertTextPresent("Second sub-task");
    }

    public void testCloneResolvedIssueClearsResolutionDate() {
        this.gotoIssue("HSP-1");
        this.tester.clickLink("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.setFormElement("comment", "This issue is now done!");
        this.tester.submit("Transition");
        this.assertTextSequence(new String[]{"Test Issue", "Due", "Created", "Updated", "Resolved"});
        this.tester.clickLink("clone-issue");
        this.tester.setFormElement(SUMMARY_FIELD_NAME, "CLONE - Test Issue");
        this.tester.submit("Create");
        this.tester.assertTextPresent("HSP-17");
        this.assertTextSequence(new String[]{"CLONE - Test Issue", "Due", "Created", "Updated"});
        Assert.assertThat((Object)this.tester.getDialog().getElement("status-val").getTextContent(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Resolved")));
    }
}

