/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.indexing;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Instruments;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.text.ParseException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.INDEXING})
public class TestIndexingResources
extends FuncTestCase {
    private Instruments instruments;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestOneProjectWithOneIssueType.xml");
        this.instruments = new Instruments(this.navigation, this.page);
    }

    public void testReindexingShouldNotChangeNumberOfOpenLuceneIndexes() throws ParseException {
        this.backdoor.issues().createIssue("HSP", "issue1");
        this.administration.reIndex();
        long initialLuceneOpenIndexesCount = this.getCurrentOpenLuceneIndexesCount();
        Assert.assertThat((String)"no open indexes", (Object)initialLuceneOpenIndexesCount, (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L))));
        this.administration.reIndex();
        long finalLuceneOpenIndexesCount = this.getCurrentOpenLuceneIndexesCount();
        Assert.assertThat((String)"number of opened indexes changed", (Object)finalLuceneOpenIndexesCount, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)initialLuceneOpenIndexesCount)));
    }

    private long getCurrentOpenLuceneIndexesCount() throws ParseException {
        Instruments.Counters currentCounters = this.instruments.readAllCounters();
        long luceneOpenCount = (Long)currentCounters.getCounter("searcher.lucene.open").getValue().or((Object)0L);
        long luceneCloseCount = (Long)currentCounters.getCounter("searcher.lucene.close").getValue().or((Object)0L);
        return luceneOpenCount - luceneCloseCount;
    }
}

