/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.imports.properties;

import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.IMPORT_EXPORT})
public class TestImportExportExcludedEntities
extends FuncTestCase {
    private static final String BS_BACKUP_TEST_FILE_XML = "BS_BackupTestFile.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExcludedEntityNotImported() throws IOException, ParserConfigurationException, SAXException {
        String backupFile = "TestImportEntityPropertyIndexDocument.xml";
        try (InputStreamReader reader = null;){
            reader = new FileReader(new File(this.environmentData.getXMLDataLocation().getAbsolutePath() + File.separator + "TestImportEntityPropertyIndexDocument.xml"));
            Document doc = XMLUnit.buildControlDocument((InputSource)new InputSource(reader));
            NodeList entityPropertyIndexDocument = doc.getElementsByTagName("EntityPropertyIndexDocument");
            Assert.assertThat((Object)entityPropertyIndexDocument.getLength(), (Matcher)Matchers.is((Object)1));
            this.administration.restoreData("TestImportEntityPropertyIndexDocument.xml");
            Assert.assertThat(this.backdoor.getPluginIndexConfigurationControl().getDocumentsForEntity(EntityPropertyType.ISSUE_PROPERTY.getDbEntityName()), (Matcher)Matchers.hasSize((int)0));
            this.administration.restoreDataWithPluginsReload("TestImportEntityPropertyIndexDocument.xml");
            Assert.assertThat(this.backdoor.getPluginIndexConfigurationControl().getDocumentsForEntity(EntityPropertyType.ISSUE_PROPERTY.getDbEntityName()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"com.atlassian.jira.dev.func-test-plugin:index-doc-conf", "com.atlassian.jira.dev.reference-plugin:IssueProperty", "com.atlassian.jira.plugins.jira-development-integration-plugin:jira-issue-fusion-jql"}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExcludedEntityNotExported() throws IOException, ParserConfigurationException, SAXException {
        File backupFile = null;
        try {
            this.backdoor.getPluginIndexConfigurationControl().putDocumentConfiguration("pluginKey", "moduleKey", this.getConfiguration());
            Assert.assertThat(this.backdoor.getPluginIndexConfigurationControl().getDocumentsForEntity(EntityPropertyType.ISSUE_PROPERTY.getDbEntityName()), (Matcher)Matchers.hasItem((Object)"pluginKey:moduleKey"));
            this.deleteBackupFileIfPresent(BS_BACKUP_TEST_FILE_XML);
            backupFile = this.administration.exportDataToFile(BS_BACKUP_TEST_FILE_XML);
            TestImportExportExcludedEntities.assertTrue((String)"The backup file must exist", (boolean)backupFile.exists());
            Document doc = XMLUnit.buildControlDocument((InputSource)new InputSource(new ZipFile(backupFile).getInputStream(new ZipEntry("entities.xml"))));
            NodeList entityPropertyIndexDocument = doc.getElementsByTagName("EntityPropertyIndexDocument");
            Assert.assertThat((Object)entityPropertyIndexDocument.getLength(), (Matcher)Matchers.is((Object)0));
        }
        finally {
            if (backupFile != null) {
                backupFile.delete();
            }
        }
    }

    private void deleteBackupFileIfPresent(String fileName) {
        File backupFile = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/" + fileName);
        if (backupFile.exists()) {
            backupFile.delete();
        }
    }

    @Override
    public void tearDownTest() {
        this.backdoor.plugins().enablePlugin("com.atlassian.jira.dev.reference-plugin");
    }

    private String getConfiguration() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<index-document-configuration entity-key=\"IssueProperty\"><key property-key=\"foo.bar\"><extract path=\"foo1.bar2\" type=\"STRING\"/></key><key property-key=\"foo.bar\"><extract path=\"foo1.bar2\" type=\"DATE\"/></key></index-document-configuration>";
    }
}

