/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.imports.project;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rules.RemoveAttachmentsRule;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.Attachment;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.Project;
import com.atlassian.jira.webtests.ztests.imports.project.AbstractProjectImportTestCase;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableWithSize;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.matchers.JUnitMatchers;

@WebTest(value={Category.FUNC_TEST, Category.PROJECT_IMPORT, Category.DATABASE})
public class TestProjectImportWithProjectKeyRename
extends AbstractProjectImportTestCase {
    protected RemoveAttachmentsRule removeAttachmentsRule;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.backdoor.attachments().enable();
        this.removeAttachmentsRule = new RemoveAttachmentsRule(this);
        this.removeAttachmentsRule.before();
    }

    @Override
    protected void tearDownTest() {
        this.removeAttachmentsRule.after();
        super.tearDownTest();
    }

    private void copyAttachmentFilesToJiraHome() {
        File jiraAttachmentsPath = new File(this.administration.getJiraHomeDirectory(), "import/attachments");
        File testAttachmentsPath = new File(this.environmentData.getXMLDataLocation(), "TestProjectImportWithProjectKeyRename/attachments");
        try {
            FileUtils.copyDirectory((File)testAttachmentsPath, (File)jiraAttachmentsPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportAttachmentsFromOldPlace() throws Exception {
        this.copyAttachmentFilesToJiraHome();
        File tempFile = null;
        try {
            String errorsAttachmentId;
            String detailsAttachmentId;
            tempFile = this.doProjectImport("TestProjectImportWithProjectKeyRename/TestProjectImportWithProjectKeyRename.xml", "TestProjectImportStandardSimpleDataNoProject.xml");
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/ul");
            String projectDetailsResults = xPathLocator.getText();
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MYK"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Description: This is a description for a monkey project."));
            xPathLocator = new XPathLocator(this.tester, "//div[@id='customfields']/ul");
            String customDetailsResults = xPathLocator.getText();
            Assert.assertThat((Object)customDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Attachments: 2 out of 2"));
            this.tester.clickLinkWithText("MYK");
            this.assertions.assertNodeByIdHasText("project-config-header-name", "monkey");
            JiraRestClient restClient = this.createRestClient();
            Project project = (Project)restClient.getProjectClient().getProject("MYK").claim();
            TestProjectImportWithProjectKeyRename.assertEquals((String)"monkey", (String)project.getName());
            TestProjectImportWithProjectKeyRename.assertEquals((String)"This is a description for a monkey project.", (String)project.getDescription());
            TestProjectImportWithProjectKeyRename.assertNotNull((Object)project.getUri());
            TestProjectImportWithProjectKeyRename.assertEquals((String)"http://monkeyproject.example.com", (String)project.getUri().toString());
            TestProjectImportWithProjectKeyRename.assertEquals((String)"Fred Normal", (String)project.getLead().getDisplayName());
            Issue issue = (Issue)restClient.getIssueClient().getIssue("MYK-1").claim();
            Assert.assertThat((Object)issue.getAttachments(), (Matcher)IsIterableWithSize.iterableWithSize((int)2));
            if (((Attachment)Iterables.getFirst((Iterable)issue.getAttachments(), null)).getFilename().equals("details.png")) {
                detailsAttachmentId = this.getAttachmentId(issue, 0);
                errorsAttachmentId = this.getAttachmentId(issue, 1);
            } else {
                detailsAttachmentId = this.getAttachmentId(issue, 1);
                errorsAttachmentId = this.getAttachmentId(issue, 0);
            }
            TestProjectImportWithProjectKeyRename.assertFilesEqual(new File(this.administration.getJiraHomeDirectory(), "import/attachments/MKY/MKY-1/10010"), new File(this.administration.getJiraHomeDirectory(), "data/attachments/MYK/MYK-1/" + detailsAttachmentId));
            TestProjectImportWithProjectKeyRename.assertFilesEqual(new File(this.administration.getJiraHomeDirectory(), "import/attachments/MKY/MKY-1/10011"), new File(this.administration.getJiraHomeDirectory(), "data/attachments/MYK/MYK-1/" + errorsAttachmentId));
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    protected String getAttachmentId(Issue issue, int i) {
        String attachmentUrl = ((Attachment)Iterables.get((Iterable)issue.getAttachments(), (int)i)).getSelf().toString();
        return attachmentUrl.substring(attachmentUrl.lastIndexOf(47));
    }

    public static void assertFilesEqual(File sourceFile, File destinationFile) throws IOException {
        Assert.assertThat((Object)destinationFile.length(), (Matcher)IsEqual.equalTo((Object)sourceFile.length()));
        TestProjectImportWithProjectKeyRename.assertTrue((String)"both files should be the same", (boolean)FileUtils.contentEquals((File)sourceFile, (File)destinationFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportWhenExistingProjectUsedKeyInThePast() {
        File tempFile = this.doProjectImport("TestProjectImportWithProjectKeyRename/TestProjectImportWithProjectKeyRename.xml", "TestProjectImportStandardSimpleDataNoProject.xml");
        try {
            long projectId = this.backdoor.project().addProject("Test", "TES", "admin");
            this.backdoor.project().addProjectKey(projectId, "MYK");
            this.backdoor.attachments().enable();
            this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
            this.tester.setWorkingForm("project-import");
            this.tester.assertTextPresent("Project Import: Select Backup File");
            this.tester.setFormElement("backupXmlPath", tempFile.getAbsolutePath());
            this.tester.submit();
            this.advanceThroughWaitingPage();
            this.tester.assertTextPresent("Project Import: Select Project to Import");
            this.tester.selectOption("projectKey", "monkey");
            this.text.assertTextPresentHtmlEncoded("The existing project 'Test' used key 'MYK' in the past. You can not re-use the key for a backup project.");
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }
}

