/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.imports.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public abstract class AbstractProjectImportTestCase
extends FuncTestCase {
    public void advanceThroughWaitingPage() {
        int count = 0;
        while (this.tester.getDialog().getResponseText().indexOf("Project Import: Progress") != -1) {
            this.tester.submit("Refresh");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (++count < 100) continue;
            AbstractProjectImportTestCase.fail((String)"Our project import backup selection has taken too long!");
        }
    }

    public File doProjectImport(String backupFileName, String currentSystemXML) {
        return this.doProjectImport(backupFileName, currentSystemXML, false);
    }

    public File doProjectImport(String backupFileName, String currentSystemXML, boolean doPluginsRefresh) {
        File tempFile = this.importAndExportBackupAndSetupCurrentInstance(backupFileName, currentSystemXML, doPluginsRefresh);
        this.importToPreImportSummaryPage(tempFile);
        return tempFile;
    }

    protected File copyFileToJiraImportDirectory(File file) {
        File jiraImportDirectory = new File(this.administration.getJiraHomeDirectory(), "import");
        if (file.getParentFile().equals(jiraImportDirectory)) {
            return file;
        }
        try {
            FileUtils.copyFileToDirectory((File)file, (File)jiraImportDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy file " + file.getAbsolutePath() + " to the import directory in jira home " + jiraImportDirectory, e);
        }
        return new File(jiraImportDirectory, file.getName());
    }

    public void importToPreImportSummaryPage(File tempFile) {
        this.copyFileToJiraImportDirectory(tempFile);
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", tempFile.getName());
        this.tester.submit();
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
    }

    public File importAndExportBackupAndSetupCurrentInstance(String backupFileName, String currentSystemXML) {
        return this.importAndExportBackupAndSetupCurrentInstance(backupFileName, currentSystemXML, false);
    }

    public File importAndExportBackupAndSetupCurrentInstance(String backupFileName, String currentSystemXML, boolean doPluginsRefresh) {
        if (doPluginsRefresh) {
            this.administration.restoreDataSlowOldWay(backupFileName);
        } else {
            this.administration.restoreData(backupFileName, false);
        }
        File backupFile = this.administration.exportDataToFile(FilenameUtils.removeExtension((String)backupFileName) + "_out.xml");
        backupFile = this.copyFileToJiraImportDirectory(backupFile);
        this.administration.restoreData(currentSystemXML, false);
        this.administration.attachments().enable();
        return backupFile;
    }
}

