/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.i18n;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.I18N})
public class TestTranslateSubTasks
extends FuncTestCase {
    @Override
    public void tearDownTest() {
        this.administration.generalConfiguration().setJiraLocaleToSystemDefault();
        super.tearDownTest();
    }

    public void testShowsLanguageListInDefaultLanguage() {
        this.administration.restoreData("TestTranslateSubTasks.xml");
        this.administration.subtasks().enable();
        this.administration.generalConfiguration().setJiraLocale("Deutsch (Deutschland)");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SUBTASKS);
        this.tester.clickLink("translate_sub_tasks");
        this.text.assertTextPresent("Sprache: Deutsch (Deutschland)");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected("selectedLocale", "Deutsch (Deutschland)");
    }

    public void testShowsLanguageListInTheUsersLanguage() {
        this.administration.restoreData("TestTranslateSubTasks.xml");
        this.administration.subtasks().enable();
        this.administration.generalConfiguration().setJiraLocale("Deutsch (Deutschland)");
        this.navigation.login("fred");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SUBTASKS);
        this.tester.clickLink("translate_sub_tasks");
        this.text.assertTextPresent("Lenguaje: espa\u00f1ol (Espa\u00f1a)");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected("selectedLocale", "espa\u00f1ol (Espa\u00f1a)");
    }
}

