/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.i18n;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.I18N})
public class TestI18n500Page
extends FuncTestCase {
    public static final String USERNAME_NON_SYS_ADMIN = "admin_non_sysadmin";
    public static final String PASSWORD_NON_SYS_ADMIN = "admin_non_sysadmin";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreI18nData("TestI18n.xml");
    }

    @Override
    public void tearDownTest() {
        this.administration.generalConfiguration().setJiraLocaleToSystemDefault();
        super.tearDownTest();
    }

    public void testShowsLanguageListInDefaultLanguage() {
        this.administration.restoreData("TestUserProfileI18n.xml");
        this.administration.generalConfiguration().setJiraLocale("Deutsch (Deutschland)");
        this.tester.gotoPage("/internal-error");
        int lastRow = this.page.getHtmlTable("language-info").getRowCount() - 1;
        this.text.assertTextPresent(new TableCellLocator(this.tester, "language-info", lastRow, 1), "Deutsch (Deutschland)");
    }

    public void testShowsLanguageListInTheUsersLanguage() {
        this.administration.restoreData("TestUserProfileI18n.xml");
        this.administration.generalConfiguration().setJiraLocale("Deutsch (Deutschland)");
        this.navigation.login("fred");
        this.tester.gotoPage("/internal-error");
        int lastRow = this.page.getHtmlTable("language-info").getRowCount() - 1;
        this.text.assertTextPresent(new TableCellLocator(this.tester, "language-info", lastRow, 1), "alem\u00e1n (Alemania)");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "language-info", lastRow - 1, 0), "espa\u00f1ol (Espa\u00f1a)");
    }
}

