/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter.management;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestSharedFilterSearchingByAdmins
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestSharedFilterSearchingByAdmins.xml");
    }

    public void testAnAdminIsAbleToSearchForFiltersSharedWithAGroupHeDoesNotBelongTo() {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10006L).name("Shared Filter With Group jira-developers owned by developer").owner("Developer").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().filters().list();
        TestSharedFilterSearchingByAdmins.assertNotNull(actualFilterItems);
        TestSharedFilterSearchingByAdmins.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        TestSharedFilterSearchingByAdmins.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
    }

    public void testAnAdminIsAbleToSearchForFiltersSharedWithAGroupHeBelongsTo() throws Exception {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10010L).name("Shared Filter with Anyone owned by developer").owner("Developer").build(), (Object)new FilterItem.Builder().id(10009L).name("Shared Filter With group jira-administrators owned by admin").owner("Administrator").build(), (Object)new FilterItem.Builder().id(10002L).name("Shared Filter With Group jira-users owned by fred").owner("Fred Normal").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().filters().list();
        TestSharedFilterSearchingByAdmins.assertNotNull(actualFilterItems);
        TestSharedFilterSearchingByAdmins.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        TestSharedFilterSearchingByAdmins.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
    }

    public void testAnAdminIsAbleToSearchForFiltersSharedWithARoleHeIsNotPartOf() throws Exception {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10004L).name("Shared Filter With Role Developers on homosapien owned by developer").owner("Developer").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().filters().list();
        TestSharedFilterSearchingByAdmins.assertNotNull(actualFilterItems);
        TestSharedFilterSearchingByAdmins.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        TestSharedFilterSearchingByAdmins.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
    }

    public void testAnAdminIsAbleToSearchForFiltersSharedWithARoleHeIsPartOf() throws Exception {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10001L).name("Shared Filter With Role Users on homosapien owned by fred").owner("Fred Normal").build(), (Object)new FilterItem.Builder().id(10007L).name("Shared Filter With All Roles on monkey owned by developer").owner("Developer").build(), (Object)new FilterItem.Builder().id(10005L).name("Shared Filter With Role Developers on monkey owned by developer").owner("Developer").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().filters().list();
        TestSharedFilterSearchingByAdmins.assertNotNull(actualFilterItems);
        TestSharedFilterSearchingByAdmins.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        TestSharedFilterSearchingByAdmins.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
    }

    public void testAnAdminIsNotAbleToSearchForFiltersThatArePrivate() throws Exception {
        ImmutableList nonExpectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10003L).name("Private Filter Owned by developer").owner("Developer").build(), (Object)new FilterItem.Builder().id(10000L).name("Private Filter Owned by fred").owner("Fred Normal").build(), (Object)new FilterItem.Builder().id(10008L).name("Private Filter owned by admin").owner("Administrator").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().filters().list();
        TestSharedFilterSearchingByAdmins.assertNotNull(actualFilterItems);
        TestSharedFilterSearchingByAdmins.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        TestSharedFilterSearchingByAdmins.assertTrue((boolean)Iterables.all((Iterable)nonExpectedFilterItems, (Predicate)Predicates.not((Predicate)Predicates.in(actualFilterItems))));
    }
}

