/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.FilterNavigation;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.WebTestSharePermission;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import junit.framework.Assert;
import org.apache.commons.collections.Closure;
import org.apache.commons.lang.StringUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestSearchFilters
extends FuncTestCase {
    private static final Logger log = LoggerFactory.getLogger(TestSearchFilters.class);
    private List<FilterItem> expectedList;
    private List<FilterItem> actualList;
    private String currentUserName;
    private static final int DEV_ID_1 = 10040;
    private static final List<WebTestSharePermission> GLOBAL_SHARE = ImmutableList.of((Object)new WebTestSharePermission("global", null, null));
    private static final String DEVELOPER_THE_GREAT = "developer the great and wise (developer)";
    private static final String ADMINISTRATOR_ADMIN = "Administrator (admin)";
    private static final String SEARCH_TABLE_ID = "mf_browse";
    private static final DecimalFormat ZEROZERO_FORMAT = new DecimalFormat("00");
    private static final String PREVIOUS = "<< Previous";
    private static final String NEXT = "Next >>";
    private static final String DEVELOPER_FILTER = "developer filter";
    private FilterNavigation[] filterNavigationScreen;
    static final String[] SORT_COL_NAMES = new String[]{"Name", "Owner", "Popularity"};
    static final String[] SORT_PARAM_VALUES = new String[]{"name", "owner", "favcount"};
    static final int[] SORT_TD_OFFSETS = new int[]{1, 2, 5};
    static final boolean[] SORT_DEFAULT_SORTING = new boolean[]{true, true, false};

    @Override
    protected void setUpTest() {
        this.currentUserName = "admin";
        this.filterNavigationScreen = new FilterNavigation[]{this.navigation.manageFilters(), this.navigation.filterPickerPopup()};
    }

    @Override
    protected void tearDownTest() {
        this.currentUserName = null;
        this.actualList = null;
        this.expectedList = null;
        this.filterNavigationScreen = null;
        super.tearDownTest();
    }

    public void testInitialScreenAppearance() throws Exception {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreen) {
            this.testInitialScreenAppearance(aFilterNavigationScreen);
        }
    }

    public void testNoSearchYet() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreen) {
            this.testNoSearchYet(aFilterNavigationScreen);
        }
    }

    public void testBasicNameSearch() throws Exception {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreen) {
            this.testBasicNameSearch(aFilterNavigationScreen);
        }
    }

    public void testBasicPaging() throws Exception {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreen) {
            this.testBasicPaging(aFilterNavigationScreen);
        }
    }

    public void testMultiPageSort() throws Exception {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreen) {
            this.testMultiPageSort(aFilterNavigationScreen);
        }
    }

    public void testBasicSorting() throws Exception {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreen) {
            this.testBasicSorting(aFilterNavigationScreen);
        }
    }

    public void testSortingByUserName() throws Exception {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreen) {
            this.testSortingByUserName(aFilterNavigationScreen);
        }
    }

    public void testInitialScreenAppearance(FilterNavigation filterNavigation) throws Exception {
        this.administration.restoreData("BaseProfessionalFilters.xml");
        filterNavigation.searchFilters();
        this.assertInputSearchFormHasThisShape("");
        this.submitSimpleSearch("", filterNavigation);
        this.submitSimpleSearch("cat", filterNavigation);
        this.submitSimpleSearch("dog", filterNavigation);
    }

    public void testNoSearchYet(FilterNavigation filterNavigation) {
        this.administration.restoreBlankInstance();
        filterNavigation.searchFilters();
        this.submitSimpleSearch("zz", filterNavigation);
        this.tester.assertTextPresent("Your search criteria did not match any filters.");
    }

    public void testXss() throws Exception {
        for (FilterNavigation navigation1 : this.filterNavigationScreen) {
            this.testXss(navigation1);
        }
    }

    public void testXss(FilterNavigation filterNavigation) throws Exception {
        log.info("doing testXss with " + filterNavigation);
        this.navigation.gotoDashboard();
        this.administration.restoreData("BaseProfessionalFiltersWithXSS.xml");
        filterNavigation.searchFilters();
        String baseURL = filterNavigation.getActionBaseUrl() + "?filterView=search&searchName=&searchOwnerUserName=&searchShareType=&groupShare=&projectShare=&roleShare=&Search=Search";
        String url = StringUtils.replace((String)baseURL, (String)"searchShareType=&", (String)"searchShareType=group&");
        url = StringUtils.replace((String)url, (String)"groupShare=&", (String)"groupShare=<script>alert('XSSGroup')</script>&");
        this.tester.gotoPage(url);
        this.actualList = this.parse.filter().parseFilterList(SEARCH_TABLE_ID).getFilterItems();
        List<Object> expectedFilters = Lists.newArrayList();
        WebTestSharePermission groupShare = new WebTestSharePermission("group", "<script>alert('XSSGroup')</script>", null);
        FilterItem groupFilterItem = new FilterItem(10040L, "xss group filter", "", ADMINISTRATOR_ADMIN, Collections.singletonList(groupShare), true, 0L, null, 1L);
        expectedFilters.add(groupFilterItem);
        expectedFilters = filterNavigation.sanitiseSearchFilterItems((List<FilterItem>)expectedFilters);
        this.assertions.assertEquals("Filter List is wrongo", expectedFilters, this.actualList);
        url = StringUtils.replace((String)baseURL, (String)"searchShareType=&", (String)"searchShareType=project&");
        url = StringUtils.replace((String)url, (String)"projectShare=&", (String)"projectShare=10000&");
        url = StringUtils.replace((String)url, (String)"roleShare=&", (String)"roleShare=10020&");
        this.tester.gotoPage(url);
        this.actualList = this.parse.filter().parseFilterList(SEARCH_TABLE_ID).getFilterItems();
        WebTestSharePermission roleShare = new WebTestSharePermission("project", "homosapien", "<script>alert('XSSRole')</script>");
        expectedFilters = Lists.newArrayList();
        FilterItem roleFilterItem = new FilterItem(10041L, "xss project role filter", "", ADMINISTRATOR_ADMIN, (List<WebTestSharePermission>)ImmutableList.of((Object)roleShare), true, 0L, null, 1L);
        expectedFilters.add(roleFilterItem);
        expectedFilters = filterNavigation.sanitiseSearchFilterItems(expectedFilters);
        this.assertions.assertEquals("Filter list is wrong", expectedFilters, this.actualList);
    }

    public void testBasicNameSearch(final FilterNavigation filterNavigation) throws Exception {
        this.administration.restoreData("BaseProfessionalFilters.xml");
        Closure basicNameSearchTest1 = new Closure(){

            public void execute(Object userNameObj) {
                TestSearchFilters.this.login(userNameObj);
                TestSearchFilters.this.navigation.manageFilters().searchFilters();
                TestSearchFilters.this.submitSimpleSearch("z", filterNavigation);
                TestSearchFilters.this.expectedList = (List)ImmutableList.of((Object)TestSearchFilters.this.newFI('z'));
                TestSearchFilters.this.assertFilterItemLists();
                TestSearchFilters.this.submitSimpleSearch("b", filterNavigation);
                TestSearchFilters.this.expectedList = (List)ImmutableList.of((Object)TestSearchFilters.this.newFI('b'));
                TestSearchFilters.this.assertFilterItemLists();
                TestSearchFilters.this.submitSimpleSearch("the evil zurg", filterNavigation);
                TestSearchFilters.this.assertInputSearchFormHasThisShape("the evil zurg");
                Assert.assertNull((String)"Should have found nothing", (Object)TestSearchFilters.this.parse.filter().parseFilterList(TestSearchFilters.SEARCH_TABLE_ID));
                TestSearchFilters.this.submitSimpleSearch("b m w", filterNavigation);
                TestSearchFilters.this.expectedList = (List)ImmutableList.of((Object)TestSearchFilters.this.newFI('b'), (Object)TestSearchFilters.this.newFI('m'), (Object)TestSearchFilters.this.newFI('w'));
                TestSearchFilters.this.assertFilterItemLists();
            }
        };
        basicNameSearchTest1.execute(null);
        basicNameSearchTest1.execute((Object)"admin");
        this.administration.restoreData("BaseProfessionalFiltersWithDeveloper.xml");
        final AtomicBoolean favFlag = new AtomicBoolean(false);
        final AtomicBoolean devFavFlag = new AtomicBoolean(false);
        Closure basicNameSearchTest2 = new Closure(){

            public void execute(Object userNameObj) {
                TestSearchFilters.this.login(userNameObj);
                TestSearchFilters.this.navigation.manageFilters().searchFilters();
                TestSearchFilters.this.submitSimpleSearch("b d* m z", filterNavigation);
                boolean isFav = favFlag.get();
                boolean isDevFav = devFavFlag.get();
                TestSearchFilters.this.expectedList = (List)ImmutableList.of((Object)TestSearchFilters.this.newFI('b').setFav(isFav), (Object)TestSearchFilters.this.newFI('d').setFav(isFav), (Object)TestSearchFilters.this.newFI(10040L, TestSearchFilters.DEVELOPER_FILTER, TestSearchFilters.DEVELOPER_THE_GREAT).setFav(isDevFav), (Object)TestSearchFilters.this.newFI('m').setFav(isFav), (Object)TestSearchFilters.this.newFI('z').setFav(isFav));
                TestSearchFilters.this.assertFilterItemLists();
            }
        };
        favFlag.set(false);
        devFavFlag.set(false);
        basicNameSearchTest2.execute(null);
        favFlag.set(false);
        devFavFlag.set(true);
        basicNameSearchTest2.execute((Object)"developer");
        favFlag.set(true);
        devFavFlag.set(false);
        basicNameSearchTest2.execute((Object)"admin");
    }

    public void testBasicPaging(final FilterNavigation filterNavigation) throws Exception {
        this.navigation.gotoDashboard();
        this.administration.restoreData("BaseProfessionalFilters.xml");
        Closure basicPagingTest = new Closure(){

            public void execute(Object userNameObj) {
                TestSearchFilters.this.login(userNameObj);
                TestSearchFilters.this.navigation.manageFilters().searchFilters();
                TestSearchFilters.this.submitSimpleSearch("", filterNavigation);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('a', 't');
                TestSearchFilters.this.assertFilterItemLists();
                String pageURL = TestSearchFilters.this.assertSinglePagingLinksPresent(1, 2, TestSearchFilters.NEXT, "1 - 20 of 26", "");
                TestSearchFilters.this.tester.gotoPage(pageURL);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('u', 'z');
                TestSearchFilters.this.assertFilterItemLists();
                pageURL = TestSearchFilters.this.assertSinglePagingLinksPresent(0, 2, TestSearchFilters.PREVIOUS, "21 - 26 of 26", "");
                TestSearchFilters.this.tester.gotoPage(pageURL);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('a', 't');
                TestSearchFilters.this.assertFilterItemLists();
                pageURL = TestSearchFilters.this.assertSinglePagingLinksPresent(1, 2, TestSearchFilters.NEXT, "1 - 20 of 26", "");
                TestSearchFilters.this.tester.gotoPage(pageURL);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('u', 'z');
                TestSearchFilters.this.assertFilterItemLists();
                TestSearchFilters.this.assertSinglePagingLinksPresent(0, 2, TestSearchFilters.PREVIOUS, "21 - 26 of 26", "");
            }
        };
        basicPagingTest.execute(null);
        basicPagingTest.execute((Object)"admin");
    }

    public void testMultiPageSort(final FilterNavigation filterNavigation) throws Exception {
        this.administration.restoreData("BaseProfessionalFiltersWithDeveloperZFilters.xml");
        Closure multiPageSortTest = new Closure(){

            public void execute(Object userNameObj) {
                TestSearchFilters.this.login(userNameObj);
                TestSearchFilters.this.navigation.manageFilters().searchFilters();
                TestSearchFilters.this.submitSimpleSearch("", filterNavigation);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('a', 't');
                TestSearchFilters.this.assertFilterItemLists();
                TestSearchFilters.this.assertSinglePagingLinksPresent(1, 2, TestSearchFilters.NEXT, "1 - 20 of 45", "");
                TestSearchFilters.this.tester.clickLinkWithText(TestSearchFilters.NEXT);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('u', 'z');
                TestSearchFilters.this.addDeveloperZSeriesFilters(TestSearchFilters.this.expectedList, 0, 13);
                TestSearchFilters.this.assertFilterItemLists();
                TestSearchFilters.this.assertDualPagingLinksPresent(2, 2, "21 - 40 of 45", "", "");
                TestSearchFilters.this.tester.clickLinkWithText(TestSearchFilters.NEXT);
                TestSearchFilters.this.expectedList = Lists.newArrayList();
                TestSearchFilters.this.addDeveloperZSeriesFilters(TestSearchFilters.this.expectedList, 14, 18);
                TestSearchFilters.this.assertFilterItemLists();
                TestSearchFilters.this.assertSinglePagingLinksPresent(1, 2, TestSearchFilters.PREVIOUS, "41 - 45 of 45", "");
                TestSearchFilters.this.tester.clickLinkWithText(TestSearchFilters.PREVIOUS);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('u', 'z');
                TestSearchFilters.this.addDeveloperZSeriesFilters(TestSearchFilters.this.expectedList, 0, 13);
                TestSearchFilters.this.assertFilterItemLists();
                TestSearchFilters.this.assertDualPagingLinksPresent(2, 2, "21 - 40 of 45", "", "");
                TestSearchFilters.this.tester.clickLinkWithText(TestSearchFilters.PREVIOUS);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('a', 't');
                TestSearchFilters.this.assertFilterItemLists();
                TestSearchFilters.this.assertSinglePagingLinksPresent(1, 2, TestSearchFilters.NEXT, "1 - 20 of 45", "");
            }
        };
        multiPageSortTest.execute(null);
        multiPageSortTest.execute((Object)"admin");
    }

    public void testBasicSorting(FilterNavigation filterNavigation) throws Exception {
        this.navigation.gotoDashboard();
        this.administration.restoreData("BaseProfessionalFilters.xml");
        this.navigation.manageFilters().searchFilters();
        this.submitSimpleSearch("", filterNavigation);
        this.expectedList = this.buildExpectedList('a', 't');
        this.assertFilterItemLists();
        String sortURL = this.assertSortUrls("Name", false, "");
        TestSearchFilters.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        this.expectedList = this.buildExpectedList('z', 'g');
        this.assertFilterItemLists();
        sortURL = this.assertSortUrls("Name", true, "");
        TestSearchFilters.assertNotNull((Object)sortURL);
        sortURL = this.getSortURL("Owner");
        TestSearchFilters.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        this.expectedList = this.buildExpectedList('a', 't');
        this.assertFilterItemLists();
        sortURL = this.assertSortUrls("Owner", false, "");
        TestSearchFilters.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        this.expectedList = this.buildExpectedList('a', 't');
        this.assertFilterItemLists();
        sortURL = this.assertSortUrls("Author", true, "");
        TestSearchFilters.assertNotNull((Object)sortURL);
        sortURL = this.getSortURL("Popularity");
        TestSearchFilters.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        this.expectedList = this.buildExpectedList('a', 't');
        this.assertFilterItemLists();
        sortURL = this.assertSortUrls("Popularity", true, "");
        TestSearchFilters.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        this.expectedList = this.buildExpectedList('a', 't');
        this.assertFilterItemLists();
        sortURL = this.assertSortUrls("Popularity", false, "");
        TestSearchFilters.assertNotNull((Object)sortURL);
        this.navigation.manageFilters().removeFavourite(this.getEntityId('a'));
        this.navigation.manageFilters().searchFilters();
        this.submitSimpleSearch("", filterNavigation);
        sortURL = this.getSortURL("Popularity");
        TestSearchFilters.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        this.tester.gotoPage(sortURL);
        this.expectedList = this.buildExpectedList('b', 'u');
        this.assertFilterItemLists();
        this.tester.clickLinkWithText(NEXT);
        ImmutableList suffixList = ImmutableList.of((Object)this.newFI('a').setFav(false).setFavCount(0L));
        this.expectedList = this.buildExpectedList(null, 'v', 'z', (List<FilterItem>)suffixList);
        this.assertFilterItemLists();
        this.tester.clickLinkWithText(PREVIOUS);
        this.expectedList = this.buildExpectedList('b', 'u');
        this.assertFilterItemLists();
        sortURL = this.getSortURL("Popularity");
        TestSearchFilters.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        ImmutableList prependList = ImmutableList.of((Object)this.newFI('a').setFav(false).setFavCount(0L));
        this.expectedList = this.buildExpectedList((List<FilterItem>)prependList, 'b', 't', null);
        this.assertFilterItemLists();
        this.tester.clickLinkWithText(NEXT);
        this.expectedList = this.buildExpectedList('u', 'z');
        this.assertFilterItemLists();
    }

    public void testSortingByUserName(final FilterNavigation filterNavigation) throws Exception {
        this.navigation.gotoDashboard();
        this.administration.restoreData("BaseProfessionalFiltersWithDeveloper.xml");
        Closure sortingByUserNameTest1 = new Closure(){

            public void execute(Object userNameObj) {
                TestSearchFilters.this.login(userNameObj);
                TestSearchFilters.this.navigation.manageFilters().searchFilters();
                TestSearchFilters.this.submitSimpleSearch("", filterNavigation);
                FilterItem developerFI = TestSearchFilters.this.newFI(10040L, TestSearchFilters.DEVELOPER_FILTER, TestSearchFilters.DEVELOPER_THE_GREAT).setFav(false);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('a', 'd');
                TestSearchFilters.this.expectedList.add(developerFI);
                TestSearchFilters.this.expectedList.addAll(TestSearchFilters.this.buildExpectedList('e', 's'));
                TestSearchFilters.this.assertFilterItemLists();
                String sortURL = TestSearchFilters.this.assertSortUrls("Name", false, "");
                Assert.assertNotNull((Object)sortURL);
                sortURL = TestSearchFilters.this.getSortURL("Owner");
                TestSearchFilters.this.tester.gotoPage(sortURL);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('a', 't');
                TestSearchFilters.this.assertFilterItemLists();
                TestSearchFilters.this.tester.clickLinkWithText(TestSearchFilters.NEXT);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('u', 'z');
                TestSearchFilters.this.expectedList.add(developerFI);
                TestSearchFilters.this.assertFilterItemLists();
                sortURL = TestSearchFilters.this.getSortURL("Owner");
                TestSearchFilters.this.tester.gotoPage(sortURL);
                TestSearchFilters.this.expectedList = Lists.newArrayList();
                TestSearchFilters.this.expectedList.add(developerFI);
                TestSearchFilters.this.expectedList.addAll(TestSearchFilters.this.buildExpectedList('a', 's'));
                TestSearchFilters.this.assertFilterItemLists();
            }
        };
        sortingByUserNameTest1.execute(null);
        sortingByUserNameTest1.execute((Object)"admin");
    }

    public void testDummyXmlResponse() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.administration.restoreData("TestSearchRequestURLHandler.xml");
        this.navigation.login("fred", "fred");
        String searchURL = "/sr/jira.issueviews:searchrequest-xml/10000/SearchRequest-10000.xml?tempMax=1000";
        this.tester.gotoPage(searchURL);
        String responseText = this.tester.getDialog().getResponseText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        XMLAssert.assertXpathExists((String)"/rss/channel/build-info", (Document)doc);
        XMLAssert.assertXpathExists((String)"/rss/channel/build-info/version", (Document)doc);
        XMLAssert.assertXpathExists((String)"/rss/channel/build-info/build-number", (Document)doc);
        XMLAssert.assertXpathExists((String)"/rss/channel/build-info/build-date", (Document)doc);
    }

    private void assertDualPagingLinksPresent(int expectedNextPageOffset, int expectedLinks, String expectedXOfY, String searchName, String searchOwnerUserName) {
        int i;
        XPathLocator pageLocator = this.xPathLocator("//div[@class='pagination aui-item']/a/span[text() = 'Next >>']");
        TestSearchFilters.assertEquals((int)expectedLinks, (int)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            TestSearchFilters.assertEquals((String)NEXT, (String)pageLocator.getText(pageLocator.getNodes()[i]));
        }
        pageLocator = this.xPathLocator("//div[@class='pagination aui-item']/a/span[text() = '<< Previous']");
        TestSearchFilters.assertEquals((int)expectedLinks, (int)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            TestSearchFilters.assertEquals((String)PREVIOUS, (String)pageLocator.getText(pageLocator.getNodes()[i]));
        }
        pageLocator = this.xPathLocator("//div[@class='pagination aui-item']/span");
        TestSearchFilters.assertEquals((int)expectedLinks, (int)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            String actualXOfY = pageLocator.getText(pageLocator.getNodes()[i]);
            TestSearchFilters.assertEquals((String)expectedXOfY, (String)actualXOfY);
        }
        this.assertSortUrls("Name", false, searchName);
        pageLocator = this.xPathLocator("//div[@class='pagination aui-item']/a[contains(@class, 'icon-next')]/@href");
        TestSearchFilters.assertEquals((int)expectedLinks, (int)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            String hrefUrl = pageLocator.getText(pageLocator.getNodes()[i]);
            TestSearchFilters.assertNotNull((Object)hrefUrl);
            TestSearchFilters.assertTrue((boolean)hrefUrl.contains("&filterView=search"));
            TestSearchFilters.assertTrue((String)("Next URL does not have right page offset : " + expectedNextPageOffset), (boolean)hrefUrl.contains("&pagingOffset=" + expectedNextPageOffset));
            TestSearchFilters.assertTrue((boolean)hrefUrl.contains("&pagingOffset=" + expectedNextPageOffset));
            TestSearchFilters.assertTrue((boolean)hrefUrl.contains("&searchName=" + searchName + "&"));
            TestSearchFilters.assertTrue((boolean)hrefUrl.contains("&searchOwnerUserName=" + searchOwnerUserName + "&"));
        }
        pageLocator = this.xPathLocator("//div[@class='pagination aui-item']/a[contains(@class, 'icon-previous')]/@href");
        TestSearchFilters.assertEquals((int)expectedLinks, (int)pageLocator.getNodes().length);
        int expectedPrevOffset = expectedNextPageOffset - 2;
        for (int i2 = 0; i2 < expectedLinks; ++i2) {
            String hrefUrl = pageLocator.getText(pageLocator.getNodes()[i2]);
            TestSearchFilters.assertNotNull((Object)hrefUrl);
            TestSearchFilters.assertTrue((boolean)hrefUrl.contains("&filterView=search"));
            TestSearchFilters.assertTrue((String)("Previous URL does not have right page offset : " + expectedPrevOffset), (boolean)hrefUrl.contains("&pagingOffset=" + expectedPrevOffset));
            TestSearchFilters.assertTrue((boolean)hrefUrl.contains("&searchName=" + searchName + "&"));
            TestSearchFilters.assertTrue((boolean)hrefUrl.contains("&searchOwnerUserName=" + searchOwnerUserName + "&"));
        }
    }

    private String assertSinglePagingLinksPresent(int expectedPageOffset, int expectedLinks, String expectedLinkText, String expectedXOfY, String searchName) {
        int i;
        String returnURL = "/this/will/fail/unless/it/changes";
        XPathLocator pageLocator = this.xPathLocator("//div[@class='pagination aui-item']//a");
        TestSearchFilters.assertEquals((int)expectedLinks, (int)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            TestSearchFilters.assertEquals((String)expectedLinkText, (String)pageLocator.getText(pageLocator.getNodes()[i]));
        }
        pageLocator = this.xPathLocator("//div[@class='pagination aui-item']/span");
        TestSearchFilters.assertEquals((int)expectedLinks, (int)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            TestSearchFilters.assertEquals((String)expectedXOfY, (String)pageLocator.getText(pageLocator.getNodes()[i]));
        }
        this.assertSortUrls("Name", false, searchName);
        pageLocator = this.xPathLocator("//div[@class='pagination aui-item']//a/@href");
        TestSearchFilters.assertEquals((int)expectedLinks, (int)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            String hrefUrl;
            returnURL = hrefUrl = pageLocator.getText(pageLocator.getNodes()[i]);
            TestSearchFilters.assertNotNull((Object)hrefUrl);
            TestSearchFilters.assertTrue((boolean)hrefUrl.contains("&filterView=search"));
            TestSearchFilters.assertTrue((String)("Does not have expected pagingOffset : " + expectedPageOffset), (boolean)hrefUrl.contains("&pagingOffset=" + expectedPageOffset));
            TestSearchFilters.assertTrue((boolean)hrefUrl.contains("&searchName=" + searchName + "&"));
        }
        return returnURL;
    }

    private String getSortURL(String selectedColumnName) {
        int offset = 0;
        for (int i = 0; i < SORT_COL_NAMES.length; ++i) {
            if (!SORT_COL_NAMES[i].equalsIgnoreCase(selectedColumnName)) continue;
            offset = SORT_TD_OFFSETS[i];
            break;
        }
        XPathLocator colNameLocator = this.xPathLocator("//table[@id='mf_browse']/thead/tr/th[" + offset + "]/a");
        TestSearchFilters.assertEquals((String)selectedColumnName, (String)colNameLocator.getText());
        return ((Element)colNameLocator.getNode()).getAttribute("href");
    }

    private String assertSortUrls(String selectedColumnName, boolean selectedSortAscending, String searchName) {
        String returnURL = "/this/will/fail/unless/set";
        for (int i = 0; i < SORT_COL_NAMES.length; ++i) {
            String columnName = SORT_COL_NAMES[i];
            XPathLocator colNameLocator = this.xPathLocator("//table[@id='mf_browse']/thead/tr/th[" + SORT_TD_OFFSETS[i] + "]/a");
            TestSearchFilters.assertEquals((String)columnName, (String)colNameLocator.getText());
            String hrefUrl = ((Element)colNameLocator.getNode()).getAttribute("href");
            TestSearchFilters.assertNotNull((Object)hrefUrl);
            this.text.assertTextPresent(hrefUrl, "filterView=search");
            this.text.assertTextPresent(hrefUrl, "pagingOffset=0");
            this.text.assertTextPresent(hrefUrl, "pagingOffset=0");
            this.text.assertTextPresent(hrefUrl, "searchName=" + searchName + "&");
            this.text.assertTextPresent(hrefUrl, "sortColumn=" + SORT_PARAM_VALUES[i]);
            if (columnName.equalsIgnoreCase(selectedColumnName)) {
                this.text.assertTextPresent(hrefUrl, "sortAscending=" + String.valueOf(selectedSortAscending));
                returnURL = hrefUrl;
                continue;
            }
            this.text.assertTextPresent(hrefUrl, "sortAscending=" + String.valueOf(SORT_DEFAULT_SORTING[i]));
        }
        return returnURL;
    }

    private List<FilterItem> buildExpectedList(char startC, char endCInclusive) {
        return this.buildExpectedList(null, startC, endCInclusive, null);
    }

    private List<FilterItem> buildExpectedList(List<FilterItem> prependList, char startC, char endCInclusive, List<FilterItem> suffixList) {
        ArrayList finalList = Lists.newArrayList();
        if (prependList != null) {
            finalList.addAll(prependList);
        }
        ArrayList expectedList = Lists.newArrayList();
        int sC = startC;
        int eC = endCInclusive;
        if (startC > endCInclusive) {
            sC = endCInclusive;
            eC = startC;
        }
        for (int i = sC; i <= eC; ++i) {
            expectedList.add(this.newFI((char)i));
        }
        if (startC > endCInclusive) {
            Collections.reverse(expectedList);
        }
        finalList.addAll(expectedList);
        if (suffixList != null) {
            finalList.addAll(suffixList);
        }
        return finalList;
    }

    private void submitSimpleSearch(String searchName, FilterNavigation filterNavigation) {
        filterNavigation.findFilters(searchName);
        this.assertInputSearchFormHasThisShape(searchName);
    }

    private void assertInputSearchFormHasThisShape(String searchName) {
        this.text.assertTextPresent(this.xPathLocator("//form[@id='filterSearchForm']"), "Search");
        TestSearchFilters.assertTrue((boolean)this.xPathLocator("//form[@id='filterSearchForm']//input[@name='searchName']").hasNodes());
        TestSearchFilters.assertEquals((String)searchName, (String)this.tester.getDialog().getFormParameterValue("searchName"));
        this.text.assertTextPresent(this.xPathLocator("//form[@id='filterSearchForm']"), "Owner");
        TestSearchFilters.assertTrue((boolean)this.xPathLocator("//form[@id='filterSearchForm']//*[@name='searchOwnerUserName']").hasNodes());
        if (this.currentUserName != null) {
            TestSearchFilters.assertTrue((boolean)this.xPathLocator("//form[@id='filterSearchForm']//select[@name='searchShareType']").hasNodes());
            TestSearchFilters.assertTrue((boolean)this.xPathLocator("//form[@id='filterSearchForm']//select[@name='groupShare']").hasNodes());
            TestSearchFilters.assertTrue((boolean)this.xPathLocator("//form[@id='filterSearchForm']//select[@name='projectShare']").hasNodes());
            TestSearchFilters.assertTrue((boolean)this.xPathLocator("//form[@id='filterSearchForm']//select[@name='roleShare']").hasNodes());
        }
        TestSearchFilters.assertTrue((boolean)this.xPathLocator("//form[@id='filterSearchForm']//input[@name='Search']").hasNodes());
    }

    private void assertFilterItemLists() {
        this.actualList = this.parse.filter().parseFilterList(SEARCH_TABLE_ID).getFilterItems();
        if (this.expectedList == null || this.actualList == null) {
            TestSearchFilters.assertTrue((String)"If one filter list is null they both should be", (this.actualList == null && this.expectedList == null ? 1 : 0) != 0);
            return;
        }
        TestSearchFilters.assertEquals((String)"The filter lists should have the same size", (int)this.expectedList.size(), (int)this.actualList.size());
        if (this.currentUserName == null) {
            for (FilterItem filterItem : this.expectedList) {
                filterItem.setFav(false);
            }
        }
        int index = 0;
        for (FilterItem expectedFI : this.expectedList) {
            FilterItem actualFI = this.actualList.get(index++);
            TestSearchFilters.assertEquals((String)"The FilterItems are not equal", (Object)expectedFI, (Object)actualFI);
        }
    }

    private int getEntityId(char filterName) {
        return 10005 + Math.abs(97 - filterName);
    }

    private XPathLocator xPathLocator(String xpathStr) {
        return new XPathLocator(this.tester, xpathStr);
    }

    private FilterItem newFI(long filterId, String filterName, String authorName) {
        return new FilterItem(filterId, filterName, "", authorName, GLOBAL_SHARE, Boolean.TRUE, 0L, null, 1L);
    }

    private FilterItem newFI(char filterName) {
        return this.newFI(filterName, ADMINISTRATOR_ADMIN, Boolean.TRUE);
    }

    private FilterItem newFI(char filterName, String authorName, Boolean isFavourited) {
        Long id = this.getEntityId(filterName);
        return new FilterItem(id, Character.toString(filterName), "", authorName, GLOBAL_SHARE, isFavourited, 0L, null, 1L);
    }

    private void addDeveloperZSeriesFilters(List<FilterItem> expectedList, int startFilterNum, int endFilterNumInclusive) {
        for (int i = startFilterNum; i <= endFilterNumInclusive; ++i) {
            String filterName = "z" + ZEROZERO_FORMAT.format(i);
            long id = 10040 + i;
            expectedList.add(this.newFI(id, filterName, DEVELOPER_THE_GREAT).setFav(false));
        }
    }

    private void login(Object userNameObj) {
        this.logout();
        if (userNameObj != null) {
            this.currentUserName = String.valueOf(userNameObj);
            this.navigation.login(this.currentUserName, this.currentUserName);
        }
    }

    private void logout() {
        this.navigation.logout();
        this.currentUserName = null;
    }
}

