/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestFilterWarnings
extends FuncTestCase {
    private static final String NO_MAIL_SERVER_IS_CURRENTLY_CONFIGURED = "No mail server is currently configured. Notifications will not be sent.";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
        String filter = this.backdoor.filters().createFilter("", "Test Filter");
        this.navigation.manageFilters().addSubscription(Integer.parseInt(filter, 10));
    }

    private void addSubscription() {
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "daysOfMonth");
        this.tester.submit("Subscribe");
    }

    public void testMailNotConfiguredWarning() {
        this.addSubscription();
        this.navigation.manageFilters().goToDefault();
        this.navigation.manageFilters().manageSubscriptions(10000);
        this.text.assertTextPresent(this.locator.page(), NO_MAIL_SERVER_IS_CURRENTLY_CONFIGURED);
        this.text.assertTextNotPresent(this.locator.page(), "Run now");
    }

    public void testMailConfiguredNoWarning() {
        this.addSubscription();
        this.navigation.gotoDashboard();
        this.administration.mailServers().Smtp().goTo().add("testserver", "admin@example.com", "JIRA", "mail.example.com");
        this.navigation.manageFilters().goToDefault();
        this.navigation.manageFilters().manageSubscriptions(10000);
        this.text.assertTextNotPresent(this.locator.page(), NO_MAIL_SERVER_IS_CURRENTLY_CONFIGURED);
        this.text.assertTextPresent(this.locator.page(), "Run now");
    }

    public void testNoMailServerNoSubscriptions() {
        this.navigation.manageFilters().goToDefault();
        this.text.assertTextNotPresent(this.locator.page(), NO_MAIL_SERVER_IS_CURRENTLY_CONFIGURED);
    }
}

