/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.FilterList;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.atlassian.jira.webtests.ztests.filter.TestFavouriteAndMyFilters;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestFilterPicker
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    public void testNoSearchYet() {
        this.navigation.filterPickerPopup().searchFilters();
        this.navigation.filterPickerPopup().findFilters("zz");
        this.tester.assertTextPresent("Your search criteria did not match any filters.");
    }

    public void testTabStickinessNotStandard() {
        this.navigation.filterPickerPopup().goToDefault();
        this.assertTabState("Search", "Popular", "Favourite");
        this.navigation.manageFilters().goToDefault();
        this.backdoor.filters().createFilter("", "Vic 20", true);
        this.navigation.filterPickerPopup().goToDefault();
        this.assertTabState("Favourite", "Search", "Popular");
        this.navigation.filterPickerPopup().popularFilters();
        this.assertTabState("Popular", "Favourite", "Search");
        this.navigation.filterPickerPopup().searchFilters();
        this.assertTabState("Search", "Popular", "Favourite");
        this.assertTabNavigation("Search", "Favourite", "Popular");
        this.assertTabNavigation("Favourite", "Popular", "Search");
        this.assertTabNavigation("Popular", "Search", "Favourite");
        this.assertTabNavigation("Search", "Popular", "Favourite");
        this.assertTabNavigation("Popular", "Favourite", "Search");
        this.assertTabNavigation("Favourite", "Search", "Popular");
    }

    public void testFilterViews() {
        this.administration.restoreData("TestDeleteUserForFiltersAndSubscriptions.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.login("admin", "admin");
        this.navigation.filterPickerPopup().goToDefault();
        List<FilterItem> expectedFavourites = this.navigation.filterPickerPopup().sanitiseFavouriteFilterItems((List<FilterItem>)ImmutableList.of((Object)TestFavouriteAndMyFilters.FILTER_10001, (Object)TestFavouriteAndMyFilters.FILTER_10020));
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List<FilterItem> filterList = filters.getFilterItems();
        TestFilterPicker.assertEquals(expectedFavourites, filterList);
        this.navigation.filterPickerPopup().popularFilters();
        List<FilterItem> expectedPopulars = this.navigation.filterPickerPopup().sanitiseSearchFilterItems((List<FilterItem>)ImmutableList.of((Object)TestFavouriteAndMyFilters.FILTER_10001, (Object)TestFavouriteAndMyFilters.FILTER_10020, (Object)TestFavouriteAndMyFilters.FILTER_10000, (Object)TestFavouriteAndMyFilters.FILTER_10010));
        filters = this.parse.filter().parseFilterList("mf_popular");
        filterList = filters.getFilterItems();
        TestFilterPicker.assertEquals(expectedPopulars, filterList);
        List<FilterItem> compareList = this.navigation.filterPickerPopup().sanitiseSearchFilterItems((List<FilterItem>)ImmutableList.of((Object)TestFavouriteAndMyFilters.FILTER_10000, (Object)TestFavouriteAndMyFilters.FILTER_10001, (Object)TestFavouriteAndMyFilters.FILTER_10020, (Object)TestFavouriteAndMyFilters.FILTER_10010));
        this.navigation.filterPickerPopup().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        TestFilterPicker.assertEquals(compareList, filterList);
    }

    private void assertTabNavigation(String currentlyOnTab, String navigateToTab, String notOnTab) {
        this.assertTabState(currentlyOnTab, navigateToTab, notOnTab);
        this.tester.clickLinkWithText(navigateToTab);
        this.assertTabState(navigateToTab, currentlyOnTab, notOnTab);
    }

    public void testNoOperationsColumnsPresent() {
        this.navigation.manageFilters().goToDefault();
        this.backdoor.filters().createFilter("", "metafilter", true);
        this.navigation.filterPickerPopup().goToDefault();
        this.tester.assertTextPresent("metafilter");
        this.tester.assertTextNotPresent("Operations");
        this.tester.assertTextNotPresent("Subscriptions");
        this.tester.assertTextNotPresent("Edit");
        this.tester.assertTextNotPresent("Delete");
        this.tester.assertTextNotPresent("Columns");
    }

    public void testAnonymousUser() {
        this.navigation.logout();
        this.navigation.filterPickerPopup().goToDefault();
        this.tester.assertTextPresent("emember my login on this computer");
        this.tester.assertTextPresent("sername");
        this.tester.assertTextPresent("assword");
        this.tester.assertTextPresent("Log In");
    }

    private void assertTabState(String onTab, String notOn1, String notOn2) {
        this.tester.assertTextPresent(onTab);
        this.tester.assertLinkNotPresentWithText(onTab);
        this.tester.assertLinkPresentWithText(notOn1);
        this.tester.assertLinkPresentWithText(notOn2);
        this.tester.assertTextNotPresent("My");
    }

    public void testProjectTabNonEnterprise() {
        this.navigation.filterPickerPopup().projects();
        String[] expectedNoCatRows = new String[]{"Project Key Project Lead", "homosapien project for homosapiens HSP Administrator (admin)", "monkey project for monkeys MKY Administrator (admin)"};
        this.assertTableRows(expectedNoCatRows, "//table[@id='nocat_projects']//tr");
        this.tester.assertTextNotPresent("Category");
    }

    public void testProjectTabCategories() {
        this.administration.restoreData("TestFilterPickerManyProjectsInCategories.xml");
        this.navigation.filterPickerPopup().projects();
        WebPageLocator pageLocator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(pageLocator.getHTML(), new String[]{"Projects", "Category", ":", "sideview", "Project", "Key", "Project Lead", "Category", ":", "topdown", "Project", "Key", "Project Lead", "Project", "Key", "Project Lead"});
        String[] expectedSideViewRows = new String[]{"Category : sideview", "Project Key Project Lead", "Dig Dug DIG Administrator (admin)", "Moon Patrol Jump your six-wheeled buggy over ditches & rocks and shoot stuff for points. MNP Administrator (admin)", "Space Invaders SPV Administrator (admin)"};
        this.assertTableRows(expectedSideViewRows, "//table[@id='cat_10011_projects']//tr");
        String[] expectedTopDownRows = new String[]{"Category : topdown", "Project Key Project Lead", "Ladybug LDB Administrator (admin)", "Pacman Eat power pills. PAC Administrator (admin)"};
        this.assertTableRows(expectedTopDownRows, "//table[@id='cat_10010_projects']//tr");
        String[] expectedNoCatRows = new String[]{"Project Key Project Lead", "Star Wars classic vector game STAR Administrator (admin)"};
        this.assertTableRows(expectedNoCatRows, "//table[@id='nocat_projects']//tr");
        XPathLocator cancelButtonLocator = new XPathLocator(this.tester, "//button[@onclick='window.close();']");
        TestFilterPicker.assertEquals((String)"Cancel", (String)((Text)cancelButtonLocator.getNode().getFirstChild()).getData());
    }

    public void testNoProjects() {
        this.administration.restoreData("EmptyJira.xml");
        this.navigation.filterPickerPopup().projects();
        this.tester.assertTextNotPresent("AMIGO");
        this.tester.assertTextNotPresent("Category");
        this.tester.assertTextPresent("There are no projects created.");
    }

    private void assertTableRows(String[] expectedRows, String xpathToTableRows) {
        XPathLocator rows = new XPathLocator(this.tester, xpathToTableRows);
        Node[] nodes = rows.getNodes();
        this.assertNodesAsText(expectedRows, nodes);
    }

    private void assertNodesAsText(String[] strings, Node[] trs) {
        for (int i = 0; i < strings.length; ++i) {
            if (i >= trs.length) {
                TestFilterPicker.fail((String)("ran out of nodes to check at position " + i));
            }
            TestFilterPicker.assertEquals((String)strings[i], (String)DomKit.getCollapsedText(trs[i]));
        }
        if (trs.length > strings.length) {
            TestFilterPicker.fail((String)"leftover nodes");
        }
    }
}

