/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.HttpUnitOptions;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestFilterPageNavigation
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("sharedfilters/SharedFiltersBase.xml");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
    }

    @Override
    protected void tearDownTest() {
        super.tearDownTest();
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    public void testBasicNavigationPage() throws Exception {
        this.tester.gotoPage("secure/ManageFilters.jspa");
        this.tester.clickLink("edit_filter_10000");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLink("edit_filter_10000");
        this.tester.setWorkingForm("filter-edit");
        this.tester.setFormElement("filterName", "Nothing in The Session Filter");
        this.tester.submit("Save");
        this.assertOnManageFiltersPage();
        this.tester.clickLink("edit_filter_10000");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLink("edit_filter_10000");
        this.tester.setWorkingForm("filter-edit");
        this.tester.setFormElement("filterName", "Now Its In The Session Filter");
        this.tester.submit("Save");
        this.assertOnManageFiltersPage();
        this.tester.clickLink("filterlink_10000");
        this.tester.gotoPage("secure/EditFilter!default.jspa");
        this.pressCancel();
        this.assertOnIssueNavPage("Now Its In The Session Filter");
        this.tester.gotoPage("secure/EditFilter!default.jspa");
        this.tester.setWorkingForm("filter-edit");
        this.tester.setFormElement("filterName", "Now has New Name");
        this.tester.submit("Save");
        this.assertOnIssueNavPage("Now has New Name");
        this.tester.gotoPage("secure/ManageFilters.jspa");
        this.tester.clickLinkWithText("Delete");
        this.tester.clickLinkWithText("Cancel");
        this.assertOnManageFiltersPage();
    }

    public void testEditValidationFailures() throws Exception {
        this.tester.gotoPage("secure/ManageFilters.jspa");
        this.tester.clickLink("edit_filter_10000");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLink("edit_filter_10000");
        this.tester.setWorkingForm("filter-edit");
        this.tester.setFormElement("filterName", "");
        this.tester.submit("Save");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLink("edit_filter_10000");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLink("edit_filter_10000");
        this.tester.setWorkingForm("filter-edit");
        this.tester.setFormElement("filterName", "");
        this.tester.submit("Save");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLink("edit_filter_10000");
        this.tester.setWorkingForm("filter-edit");
        this.tester.setFormElement("filterName", "Now Its In The Session Filter");
        this.tester.submit("Save");
        this.assertOnManageFiltersPage();
        this.tester.clickLink("filterlink_10000");
        this.tester.gotoPage("secure/EditFilter!default.jspa");
        this.pressCancel();
        this.assertOnIssueNavPage("Now Its In The Session Filter");
        this.tester.gotoPage("secure/EditFilter!default.jspa");
        this.tester.setWorkingForm("filter-edit");
        this.tester.setFormElement("filterName", "");
        this.tester.submit("Save");
        this.tester.setWorkingForm("filter-edit");
        this.tester.setFormElement("filterName", "Now has New Name");
        this.tester.submit("Save");
        this.assertOnIssueNavPage("Now has New Name");
    }

    private void assertOnIssueNavPage(String pageName) {
        this.tester.gotoPage("/rest/api/2/filter/10000");
        this.tester.assertTextPresent(pageName);
    }

    private void assertOnManageFiltersPage() {
        CssLocator mfLocator = new CssLocator(this.tester, "#content > header h1");
        TestFilterPageNavigation.assertEquals((String)"Manage Filters", (String)mfLocator.getText());
    }

    private void pressCancel() {
        TestFilterPageNavigation.assertTrue((String)"Scripting must be enabled in the HttpUnit for cancel to work correctly", (boolean)HttpUnitOptions.isScriptingEnabled());
        this.tester.setWorkingForm("filter-edit");
        this.tester.clickLink("filter-edit-cancel");
    }
}

