/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.CustomFieldValue;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestFilterActions
extends JIRAWebTest {
    private static final String NO_COLUMN_ORDER = "has no associated Column Order";
    private static final String REMOVE_COLUMN_ORDER = "Remove Filter's Column Order";
    private static final String LOGIN = "log in";
    private static final int numberOfIssues = 10;
    private static Collection<String> issues = Lists.newArrayList();
    private static final String COLUMN_NAME_VOTES = "Votes";
    private static final String COLUMN_NAME_CREATED = "Created";
    private static final String FILTER_NAME_WITH_VOTE_COL = "filter with a vote column";
    private static final String FILTER_NAME_WITHOUT_VOTE_COL = "filter without a vote column";
    private static final String CUSTOM_FIELD_NAME_SELECT = "Custom Field Select";
    private static final String CUSTOM_FIELD_NAME_RADIO = "Custom Field Radio";
    private static final String CUSTOM_FIELD_NAME_MULTI_SELECT = "Custom Field Multi Select";
    private static final String CUSTOM_FIELD_NAME_MULTI_CHECKBOX = "Custom Field Multi Checkbox";
    private static final String CUSTOM_FIELD_NAME_TEXT_FIELD = "Custom Field Text Fields";
    private static final String FILTER_PRIVATE = "/secure/IssueNavigator.jspa?requestId=10000";
    private static final String FILTER_PUBLIC = "/secure/IssueNavigator.jspa?requestId=10001";
    private static final String FILTER_DEV = "/secure/IssueNavigator.jspa?requestId=10030";
    private static final String FILTER_INVALID = "/secure/IssueNavigator.jspa?requestId=10005";
    private static final String DELETE_FILTER_DEV = "/secure/DeleteFilter.jspa?filterId=10030";
    private static final String DELETE_FILTER_DEV_URL_HACK = "/secure/DeleteFilter.jspa?filterId=10030&Delete=delete";
    private static final String DELETE_FILTER_PUBLIC = "/secure/DeleteFilter.jspa?filterId=10001";
    private static final String DELETE_FILTER_PUBLIC_URL_HACK = "/secure/DeleteFilter.jspa?filterId=10001&Delete=delete";
    private static final String ERROR_MSG_NO_PERM_TO_VIEW_FILTER = "The selected filter with id '10000' does not exist.";
    private static final String ERROR_MSG_FILTER_DOES_NOT_EXIST = "The selected filter with id '10005' does not exist.";
    private static final String ERROR_MSG_CANNOT_DELETE_FILTER = "You do not have permission to delete this filter or this filter may not exist.";

    public TestFilterActions(String name) {
        super(name);
    }

    public void testCustomFilterActions() throws IOException, SAXException {
        this.administration.restoreData("TestFilterActionsCustomFilterActions.xml");
        for (int key = 1; key <= 20; ++key) {
            issues.add("HSP-" + key);
        }
        this.filterActionsWithCustomFields();
    }

    public void testFilterResultVisibility() {
        this.administration.restoreData("TestFilterResultVisibility.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "dev");
        this.navigation.logout();
        this.assertTextPresentOnFilterView(FILTER_PRIVATE, ERROR_MSG_NO_PERM_TO_VIEW_FILTER, LOGIN);
        this.assertLinkPresentOnFilterView(FILTER_PUBLIC, "HSP-1");
        this.assertTextPresentOnFilterView(FILTER_DEV, "The selected filter with id '10030' does not exist.", LOGIN);
        this.assertTextPresentOnFilterView(FILTER_INVALID, ERROR_MSG_FILTER_DOES_NOT_EXIST, LOGIN);
        this.navigation.login("dev");
        this.tester.beginAt(FILTER_PRIVATE);
        this.tester.assertElementNotPresent("issuetable");
        this.tester.assertLinkNotPresentWithText(LOGIN);
        this.assertTextPresentOnFilterView(FILTER_PUBLIC, "all public", "HSP-1");
        this.assertTextPresentOnFilterView(FILTER_DEV, "all dev", "HSP-1");
        this.beginAt(FILTER_INVALID);
        this.tester.assertElementNotPresent("issuetable");
        this.assertLinkNotPresentWithText(LOGIN);
        this.navigation.login("admin", "admin");
        this.assertTextPresentOnFilterView(FILTER_PRIVATE, "all private", "HSP-1");
        this.assertTextPresentOnFilterView(FILTER_PUBLIC, "all public", "HSP-1");
        this.assertTextPresentOnFilterView(FILTER_DEV, "all dev", "HSP-1");
        this.tester.beginAt(FILTER_INVALID);
        this.tester.assertElementNotPresent("issuetable");
        this.assertLinkNotPresentWithText(LOGIN);
    }

    public void testDeleteFilterPermissions() {
        this.administration.restoreData("TestFilterResultVisibility.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "dev");
        this.navigation.login("dev");
        this.assertCannotDeleteFilter(DELETE_FILTER_DEV);
        this.assertCannotDeleteFilter(DELETE_FILTER_DEV_URL_HACK);
        this.assertCannotDeleteFilter(DELETE_FILTER_PUBLIC);
        this.assertCannotDeleteFilter(DELETE_FILTER_PUBLIC_URL_HACK);
        this.navigation.login("admin");
    }

    private void assertCannotDeleteFilter(String filterUrl) {
        this.tester.gotoPage(this.page.addXsrfToken(filterUrl));
        this.text.assertTextPresent(this.locator.page(), ERROR_MSG_CANNOT_DELETE_FILTER);
    }

    private void assertLinkPresentOnFilterView(String filterURL, String expectedLink) {
        this.tester.beginAt(filterURL);
        this.tester.assertLinkPresentWithText(expectedLink);
    }

    private void assertTextPresentOnFilterView(String filterURL, String expectedMessage, String expectedLink) {
        this.tester.beginAt(filterURL);
        if (!expectedMessage.contains("all")) {
            this.tester.assertElementNotPresent("issuetable");
        } else {
            this.tester.assertElementPresent("issuetable");
        }
        this.tester.assertLinkPresentWithText(expectedLink);
    }

    private void filterActionsWithCustomFields() throws SAXException, IOException {
        ImmutableList cfList = ImmutableList.of((Object)new CustomFieldValue("10000", "radiobuttons", "10000"), (Object)new CustomFieldValue("10001", "select", "abc"), (Object)new CustomFieldValue("10002", "multiselect", "batman"), (Object)new CustomFieldValue("10003", "multicheckboxes", "10009"), (Object)new CustomFieldValue("10004", "textfield", "'release 1'"));
        String[] customFieldNames = new String[]{CUSTOM_FIELD_NAME_RADIO, CUSTOM_FIELD_NAME_SELECT, CUSTOM_FIELD_NAME_TEXT_FIELD, CUSTOM_FIELD_NAME_MULTI_CHECKBOX, CUSTOM_FIELD_NAME_MULTI_SELECT};
        this.addFieldsToFieldScreen("Default Screen", customFieldNames);
        int i = 0;
        for (String anIssue : issues) {
            TestFilterActions.log("editing issues to include custom fields for issue: " + anIssue);
            if (++i % 2 != 0) continue;
            this.editIssueWithCustomFields(anIssue, (List<CustomFieldValue>)cfList);
        }
        this.removeFieldFromFieldScreen("Default Screen", customFieldNames);
        for (CustomFieldValue cfValue : cfList) {
            TestFilterActions.log("Checking portlets for " + cfValue.getCfType());
            this.createFilterWithFields(cfValue.getCfId(), cfValue.getCfValue(), cfValue.getCfType());
            this.sortIssues("issuekey", "ASC");
            this.assertIssuesPresent(10, 2);
        }
    }

    private void addColumnOrder(int filterId, String columnName, String columnVal) {
        this.gotoManageFilterColumnOrder(filterId);
        this.tester.selectOption("fieldId", columnVal);
        this.tester.submit("add");
        this.text.assertTextPresent(this.locator.page(), columnName);
    }

    private void configureColumnOrder(int filterId, String columnName, String operation) {
        this.gotoManageFilterColumnOrder(filterId);
        try {
            WebTable fieldTable = this.tester.getDialog().getResponse().getTableWithID("issuetable");
            for (int i = 0; i < fieldTable.getColumnCount(); ++i) {
                String field = fieldTable.getCellAsText(0, i);
                if (!field.contains(columnName)) continue;
                TableCell linkCell = fieldTable.getTableCell(1, i);
                WebLink link = linkCell.getLinkWithImageText(operation);
                if (link == null) {
                    TestFilterActions.fail((String)("No link with image '" + operation + "'."));
                }
                link.click();
                return;
            }
            TestFilterActions.log("Field '" + columnName + "' not in table.");
        }
        catch (SAXException e) {
            TestFilterActions.fail((String)"Cannot find table with id 'issuetable'.");
        }
        catch (IOException e) {
            TestFilterActions.fail((String)("Could not click link with image '" + operation + "'."));
        }
    }

    public void gotoManageFilterColumnOrder(int filterId) {
        this.navigation.manageFilters().myFilters();
        this.tester.clickLink("colOrder_" + filterId);
    }

    private void createFilterWithFields(String fieldId, String fieldValue, String fieldType) {
        String jql = "cf[" + fieldId + "] = " + fieldValue;
        this.log.log((Object)("Creating filter with jql = " + jql));
        this.backdoor.filters().createFilter(jql, "jql", true);
    }

    private void assertIssuesPresent(int numberOfIssues, int gap) {
        TestFilterActions.log("checking if all issues are present in filter");
        int i = 0;
        for (String anIssue : issues) {
            if (++i >= numberOfIssues || i % gap != 0) continue;
            this.tester.assertLinkPresentWithText(anIssue);
        }
    }
}

