/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.fields;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.AbstractLocator;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.FIELDS, Category.ISSUE_NAVIGATOR, Category.ISSUES})
public class TestResolutionDateField
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestResolutionDateField.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    public void testViewIssuePage() {
        this.navigation.issue().viewIssue("HSP-1");
        AbstractLocator locator = new XPathLocator(this.tester, "//header//h1");
        this.text.assertTextPresent(locator, "First test issue");
        locator = new IdLocator(this.tester, "status-val");
        this.text.assertTextNotPresent(locator, "Resolved");
        this.navigation.issue().viewIssue("HSP-2");
        locator = new XPathLocator(this.tester, "//header//h1");
        this.text.assertTextPresent(locator, "Second test issue");
        locator = new IdLocator(this.tester, "status-val");
        this.text.assertTextPresent(locator, "Resolved");
    }

    public void testResolveIssueUpdatesDate() {
        this.navigation.issue().viewIssue("HSP-1");
        AbstractLocator locator = new XPathLocator(this.tester, "//header//h1");
        this.text.assertTextPresent(locator, "First test issue");
        locator = new IdLocator(this.tester, "status-val");
        this.text.assertTextNotPresent(locator, "Resolved");
        this.tester.clickLink("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        locator = new XPathLocator(this.tester, "//header//h1");
        this.text.assertTextPresent(locator, "First test issue");
        locator = new IdLocator(this.tester, "status-val");
        this.text.assertTextPresent(locator, "Resolved");
        this.navigation.issueNavigator().displayAllIssues();
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 2, 1), "HSP-1");
        String resolvedCell = this.tester.getDialog().getWebTableBySummaryOrId("issuetable").getCellAsText(2, 11).trim();
        TestResolutionDateField.assertTrue((resolvedCell.length() > 0 ? 1 : 0) != 0);
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLink("action_id_3");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        locator = new XPathLocator(this.tester, "//header//h1");
        this.text.assertTextPresent(locator, "First test issue");
        locator = new IdLocator(this.tester, "status-val");
        this.text.assertTextNotPresent(locator, "Resolved");
        this.navigation.issueNavigator().displayAllIssues();
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 2, 1), "HSP-1");
        this.assertTableCellEmpty("issuetable", 2, 11);
    }

    public void testIssueNavigatorColumns() {
        this.navigation.issueNavigator().displayAllIssues();
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 0, 11), "Resolved");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 1, 1), "HSP-2");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 1, 11), "14/Oct/08");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 2, 1), "HSP-1");
        this.assertTableCellEmpty("issuetable", 2, 11);
    }

    public void testIssueViews() {
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLinkWithText("Printable");
        this.tester.assertTextNotPresent("Resolved:");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.clickLinkWithText("Printable");
        this.tester.assertTextPresent("Resolved:");
    }

    private void assertTableCellEmpty(String tableId, int row, int col) {
        String resolvedCell = this.tester.getDialog().getWebTableBySummaryOrId(tableId).getCellAsText(row, col).trim();
        TestResolutionDateField.assertTrue((resolvedCell.length() == 0 ? 1 : 0) != 0);
    }
}

