/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.fields;

import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import java.io.IOException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.FIELDS, Category.ISSUE_TYPES, Category.SCREENS})
public class TestFieldScreens
extends JIRAWebTest {
    private String issueKey;
    private String issueKey2;
    private String customFieldId;
    private String customFieldId2;
    private static final String ADDED_SCREEN_NAME = "Test Add Screen";
    private static final String COPIED_SCREEN_NAME = "Test Copy Screen";
    private static final String ADDED_SCREEN_SCHEME_NAME = "Test Add Screen Scheme";
    private static final String COPIED_SCREEN_SCHEME_NAME = "Test Copy Screen Scheme";
    private static final String ADDED_ISSUE_TYPE_SCREEN_SCHEME_NAME = "Test Add Issue Type Screen Scheme";
    private static final String COPIED_ISSUE_TYPE_SCREEN_SCHEME_NAME = "Test Copy Issue Tyep Screen Scheme";
    private static final String CUSTOM_FIELD_NAME = "Animal";
    private static final String CUSTOM_FIELD_NAME_TWO = "Approval Rating";
    private static final String TAB_NAME = "Tab for Testing";
    private static final String DEFAULT_TAB_NAME = "Field Tab";

    public TestFieldScreens(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.navigation.login("admin");
        this.getBackdoor().restoreBlankInstance();
        this.resetSettings();
        this.customFieldId = this.addCustomField("textfield", "global", CUSTOM_FIELD_NAME, "custom field 1", null, null, null);
        this.customFieldId2 = this.addCustomField("textfield", "global", CUSTOM_FIELD_NAME_TWO, "custom field 2", null, null, null);
        this.issueKey = this.addIssue("homosapien", "HSP", "Bug", "test field screen", "Minor", null, null, null, "Administrator", "priority is added to assign issue screen", "test description for field screens", null, null, null);
        this.createIssueWithCustomField();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() {
        try {
            this.deleteAllIssuesInAllPages();
            this.removeAllCustomFields();
            super.tearDown();
        }
        catch (Throwable t) {
            TestFieldScreens.log("Some problem in tear down of " + this.getClass().getName(), t);
        }
        finally {
            this.customFieldId = null;
            this.customFieldId2 = null;
            this.issueKey = null;
        }
    }

    public void testFieldScreens() {
        this.fieldScreensAddFieldToFieldScreen();
        this.fieldScreensSetFieldInWorkflow();
        this.fieldScreensRemoveFieldFromFieldScreen();
        this.fieldScreensAddScreen();
        this.fieldScreensAddScreenCancel();
        this.fieldScreensAddScreenWithDuplicateName();
        this.fieldScreensAddScreenWithInvalidName();
        this.fieldScreensStandardScreens();
        this.fieldScreensAddScreenScheme();
        this.fieldScreensAddScreenSchemeWithDuplicateName();
        this.fieldScreensAddScreenSchemeWithInvalidName();
        this.fieldScreensAddIssueTypeScreenScheme();
        this.fieldScreensAddIssueTypeScreenSchemeWithDuplicateName();
        this.fieldScreensAddIssueTypeToScreenAssociation();
        this.fieldScreensProjectScreenSchemes();
        this.fieldScreensIssueTypeScreenSchemes();
        this.fieldScreensCopyIssueTypeScreenSchemes();
        this.fieldScreensDeleteIssueTypeScreenSchemes();
        this.fieldScreensCopyScreenScheme();
        this.fieldScreensDeleteScreenScheme();
        this.fieldScreensDeleteScreen();
    }

    public void testDeleteIssueTypeSchemeFailsWhenAssignedToProject() {
        Long issueTypeScreenSchemeId = this.getBackdoor().issueTypeScreenSchemes().createScheme("DELETEME", "blah", 1L);
        this.gotoIssueTypeScreenSchemes();
        this.getBackdoor().project().setIssueTypeScreenScheme(10000L, issueTypeScreenSchemeId);
        this.tester.clickLink("delete_issuetypescreenscheme_10000");
        this.tester.assertTextPresent("Cannot delete an issue type screen scheme that is being used by a project");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Cannot delete an issue type screen scheme that is being used by a project");
    }

    private void fieldScreensAddFieldToFieldScreen() {
        this.addFieldToFieldScreen("Workflow Screen", CUSTOM_FIELD_NAME);
        this.addFieldToFieldScreen("Workflow Screen", "Issue Type", "2");
    }

    private void fieldScreensAddFieldToFieldScreenWithInvalidPosition() {
        this.addFieldToFieldScreen("Workflow Screen", "Affects Version/s", "0");
    }

    private void fieldScreensSetFieldInWorkflow() {
        this.navigation.issue().gotoIssue(this.issueKey);
        this.tester.clickLinkWithText("Close Issue");
        this.tester.assertFormElementNotPresent("customfield_" + this.customFieldId);
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.tester.clickLinkWithText("Reopen Issue");
        this.tester.setFormElement("customfield_" + this.customFieldId, "Polar Bear");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
    }

    private void fieldScreensRemoveFieldFromFieldScreen() {
        String[] fieldNames = new String[]{CUSTOM_FIELD_NAME, "Issue Type"};
        this.removeFieldFromFieldScreen("Workflow Screen", fieldNames);
        for (String fieldName : fieldNames) {
            if (this.findRowWithName("field_table", 1, fieldName) == null) continue;
            TestFieldScreens.fail((String)("Field " + fieldName + " was not removed"));
        }
    }

    private void fieldScreensAddScreen() {
        this.addScreen(ADDED_SCREEN_NAME, "");
        this.gotoFieldScreens();
        this.tester.assertLinkPresent("delete_fieldscreen_Test Add Screen");
    }

    private void fieldScreensAddScreenCancel() {
        this.gotoFieldScreens();
        this.tester.clickLink("add-field-screen");
        this.tester.clickLink("field-screen-add-cancel");
        this.text.assertTextPresent(this.locator.css("header h2"), "View Screens");
    }

    private void fieldScreensAddScreenWithDuplicateName() {
        this.addScreen(ADDED_SCREEN_NAME, "");
        this.tester.assertTextPresent("A Screen with this name already exists.");
    }

    private void fieldScreensAddScreenWithInvalidName() {
        this.addScreen("", "");
        this.tester.assertTextPresent("You must enter a valid name.");
    }

    private void fieldScreensDeleteScreen() {
        this.deleteScreen(ADDED_SCREEN_NAME);
        this.assertLinkNotPresent("delete_fieldscreen_Test Add Screen");
    }

    private void fieldScreensAddScreenScheme() {
        this.addFieldScreenScheme(ADDED_SCREEN_SCHEME_NAME, "", "Default Screen");
        this.gotoFieldScreenSchemes();
        this.tester.assertLinkPresent("delete_fieldscreenscheme_Test Add Screen Scheme");
    }

    private void fieldScreensAddScreenSchemeWithDuplicateName() {
        this.addFieldScreenScheme(ADDED_SCREEN_SCHEME_NAME, "", "Default Screen");
        this.tester.assertTextPresent("A Screen Scheme with this name already exists.");
    }

    private void fieldScreensAddScreenSchemeWithInvalidName() {
        this.addFieldScreenScheme("", "", "Default Screen");
        this.tester.assertTextPresent("You must enter a valid name.");
    }

    private void fieldScreensCopyScreenScheme() {
        this.copyFieldScreenScheme(ADDED_SCREEN_SCHEME_NAME, COPIED_SCREEN_SCHEME_NAME, "");
        this.tester.clickLink("configure_fieldscreenscheme_Test Copy Screen Scheme");
        this.tester.assertLinkPresent("edit_fieldscreenscheme_Default");
    }

    private void fieldScreensDeleteScreenScheme() {
        this.deleteFieldScreenScheme(COPIED_SCREEN_SCHEME_NAME);
        this.tester.assertLinkNotPresent("delete_fieldscreenscheme_Test Copy Screen Scheme");
        this.deleteFieldScreenScheme(ADDED_SCREEN_SCHEME_NAME);
        this.tester.assertLinkNotPresent("delete_fieldscreenscheme_Test Add Screen Scheme");
    }

    private void fieldScreensAddIssueTypeScreenScheme() {
        this.addIssueTypeFieldScreenScheme(ADDED_ISSUE_TYPE_SCREEN_SCHEME_NAME, "", "Default Screen Scheme");
    }

    private void fieldScreensAddIssueTypeScreenSchemeWithDuplicateName() {
        this.addIssueTypeFieldScreenScheme(ADDED_ISSUE_TYPE_SCREEN_SCHEME_NAME, "", "Default Screen Scheme");
        this.tester.assertTextPresent("A scheme with this name already exists.");
    }

    private void fieldScreensAddIssueTypeToScreenAssociation() {
        this.addIssueTypeToScreenAssociation("10000", "Bug", ADDED_SCREEN_SCHEME_NAME);
        this.tester.assertLinkPresent("delete_issuetypescreenschemeentity_Bug");
    }

    private void fieldScreensCopyIssueTypeScreenSchemes() {
        this.copyIssueTypeFieldScreenSchemeName("10000", COPIED_ISSUE_TYPE_SCREEN_SCHEME_NAME, "");
        this.tester.clickLink("configure_issuetypescreenscheme_10001");
        this.tester.assertLinkPresent("edit_issuetypescreenschemeentity_default");
        this.tester.assertLinkPresent("edit_issuetypescreenschemeentity_Bug");
    }

    private void fieldScreensDeleteIssueTypeScreenSchemes() {
        this.deleteIssueTypeFieldScreenScheme("10001");
        this.tester.assertLinkNotPresent("delete_issuetypescreenscheme_10001");
        this.associateIssueTypeScreenSchemeToProject("neanderthal", "Default Issue Type Screen Scheme");
        this.deleteIssueTypeFieldScreenScheme("10000");
        this.tester.assertLinkNotPresent("delete_issuetypescreenscheme_10000");
    }

    private void fieldScreensAddTab() {
        TestFieldScreens.log("Adding tabs");
        this.addTabToScreen(ADDED_SCREEN_NAME, TAB_NAME);
        this.tester.assertTextPresent(TAB_NAME);
        this.tester.assertLinkPresentWithText(DEFAULT_TAB_NAME);
    }

    private void fieldScreensDeleteTab() {
        TestFieldScreens.log("Deleting tabs");
        this.deleteTabFromScreen(ADDED_SCREEN_NAME, TAB_NAME);
        this.tester.assertLinkNotPresentWithText(TAB_NAME);
    }

    private void fieldScreensAddFieldToTab() {
        this.addFieldToFieldScreenTab(ADDED_SCREEN_NAME, TAB_NAME, CUSTOM_FIELD_NAME, "");
        if (this.findRowWithName("field_table", 1, CUSTOM_FIELD_NAME) == null) {
            TestFieldScreens.fail((String)"Field was not added to tab");
        }
        this.addFieldToFieldScreenTab(ADDED_SCREEN_NAME, DEFAULT_TAB_NAME, CUSTOM_FIELD_NAME_TWO, "");
        this.addFieldToFieldScreenTab(ADDED_SCREEN_NAME, DEFAULT_TAB_NAME, "Summary", "");
    }

    private void fieldScreensAddTabWithDuplicateName() {
        this.addTabToScreen(ADDED_SCREEN_NAME, TAB_NAME);
        this.tester.assertTextPresent("Field Tab with this name already exists.");
    }

    private void fieldScreensAddTabWithInvalidName() {
        this.addTabToScreen(ADDED_SCREEN_NAME, "");
        this.tester.assertTextPresent("You must enter a valid name.");
    }

    private void fieldScreensRemoveFieldFromTab() {
        this.removeFieldFromFieldScreenTab(ADDED_SCREEN_NAME, TAB_NAME, new String[]{CUSTOM_FIELD_NAME});
        if (this.findRowWithName("field_table", 1, CUSTOM_FIELD_NAME) != null) {
            TestFieldScreens.fail((String)"Fields not deleted.");
        }
        this.removeFieldFromFieldScreenTab(ADDED_SCREEN_NAME, DEFAULT_TAB_NAME, new String[]{"Summary", CUSTOM_FIELD_NAME_TWO});
        if (this.findRowWithName("field_table", 1, CUSTOM_FIELD_NAME_TWO) != null) {
            TestFieldScreens.fail((String)"Fields not deleted.");
        }
    }

    private void fieldScreensIssueTypeScreenSchemes() {
        TestFieldScreens.log("Check schemes using issue type based schemes");
        this.associateIssueTypeScreenSchemeToProject("neanderthal", ADDED_ISSUE_TYPE_SCREEN_SCHEME_NAME);
        this.addFieldToFieldScreen(ADDED_SCREEN_NAME, "Summary");
        this.addFieldToFieldScreen(ADDED_SCREEN_NAME, CUSTOM_FIELD_NAME);
        String issueKeyCustomField = this.checkCreateIssueScreenScheme(ADDED_SCREEN_SCHEME_NAME, "neanderthal", "NDT", "Bug");
        this.checkViewIssueScreenScheme(ADDED_SCREEN_SCHEME_NAME, "neanderthal", "Bug", issueKeyCustomField);
        this.checkEditIssueScreenScheme(ADDED_SCREEN_SCHEME_NAME, "neanderthal", "Bug", issueKeyCustomField);
        this.addIssueOperationToScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "Create Issue", ADDED_SCREEN_NAME);
        this.addIssueOperationToScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "View Issue", ADDED_SCREEN_NAME);
        this.addIssueOperationToScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "Edit Issue", ADDED_SCREEN_NAME);
        this.checkNoScreenScheme("neanderthal", "Improvement", this.issueKey2);
        this.deleteIssueOperationFromScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "Create Issue");
        this.deleteIssueOperationFromScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "View Issue");
        this.deleteIssueOperationFromScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "Edit Issue");
        this.checkNoScreenScheme("neanderthal", "Bug", issueKeyCustomField);
        this.removeFieldFromFieldScreen(ADDED_SCREEN_NAME, new String[]{"Summary", CUSTOM_FIELD_NAME});
        this.associateIssueTypeScreenSchemeToProject("neanderthal", "Default Issue Type Screen Scheme");
    }

    private void fieldScreensProjectScreenSchemes() {
        TestFieldScreens.log("Check screens using project based schemes");
        this.associateIssueTypeScreenSchemeToProject("homosapien", ADDED_ISSUE_TYPE_SCREEN_SCHEME_NAME);
        this.addFieldToFieldScreen(ADDED_SCREEN_NAME, "Summary");
        this.addFieldToFieldScreen(ADDED_SCREEN_NAME, CUSTOM_FIELD_NAME);
        String issueKeyCustomField = this.checkCreateIssueScreenScheme(ADDED_SCREEN_SCHEME_NAME, "homosapien", "HSP", "Bug");
        this.checkViewIssueScreenScheme(ADDED_SCREEN_SCHEME_NAME, "homosapien", "Bug", issueKeyCustomField);
        this.checkEditIssueScreenScheme(ADDED_SCREEN_SCHEME_NAME, "homosapien", "Bug", issueKeyCustomField);
        this.addIssueOperationToScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "Create Issue", ADDED_SCREEN_NAME);
        this.addIssueOperationToScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "View Issue", ADDED_SCREEN_NAME);
        this.addIssueOperationToScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "Edit Issue", ADDED_SCREEN_NAME);
        this.checkNoScreenScheme("neanderthal", "Bug", this.issueKey2);
        this.deleteIssueOperationFromScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "Create Issue");
        this.deleteIssueOperationFromScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "View Issue");
        this.deleteIssueOperationFromScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "Edit Issue");
        this.removeFieldFromFieldScreen(ADDED_SCREEN_NAME, new String[]{"Summary", CUSTOM_FIELD_NAME});
        this.checkNoScreenScheme("homosapien", "Bug", issueKeyCustomField);
        this.associateIssueTypeScreenSchemeToProject("homosapien", "Default Issue Type Screen Scheme");
    }

    private void fieldScreensStandardScreens() {
        TestFieldScreens.log("Check screens for standard settings");
        this.addFieldToFieldScreen(ADDED_SCREEN_NAME, "Summary");
        this.addFieldToFieldScreen(ADDED_SCREEN_NAME, CUSTOM_FIELD_NAME);
        String issueKeyCustomField = this.checkCreateIssueScreenScheme("Default Screen Scheme", "homosapien", "HSP", "Bug");
        this.checkViewIssueScreenScheme("Default Screen Scheme", "homosapien", "Bug", issueKeyCustomField);
        this.checkEditIssueScreenScheme("Default Screen Scheme", "homosapien", "Bug", issueKeyCustomField);
        this.removeFieldFromFieldScreen(ADDED_SCREEN_NAME, new String[]{"Summary", CUSTOM_FIELD_NAME});
        this.checkNoScreenScheme("homosapien", "Bug", issueKeyCustomField);
    }

    protected void fieldScreensTabViews() {
        this.addIssueOperationToScreenAssociation("Default Screen Scheme", "Create Issue", ADDED_SCREEN_NAME);
        this.addIssueOperationToScreenAssociation("Default Screen Scheme", "View Issue", ADDED_SCREEN_NAME);
        this.addIssueOperationToScreenAssociation("Default Screen Scheme", "Edit Issue", ADDED_SCREEN_NAME);
        this.createIssueStep1();
        this.tester.setFormElement("customfield_" + this.customFieldId2, "High");
        this.tester.setFormElement("summary", "This is a test issue");
        this.tester.setFormElement("customfield_" + this.customFieldId, "Rhino");
        this.tester.submit("Create");
        this.text.assertTextPresent(this.getCustomFieldLabel(1, 1), CUSTOM_FIELD_NAME_TWO);
        this.text.assertTextPresent(this.getCustomFieldValue(1, 1), "High");
        this.text.assertTextPresent(this.getCustomFieldLabel(2, 1), CUSTOM_FIELD_NAME);
        this.text.assertTextPresent(this.getCustomFieldValue(2, 1), "Rhino");
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("customfield_" + this.customFieldId2, "Low");
        this.tester.setFormElement("customfield_" + this.customFieldId, "Tiger");
        this.tester.submit("Update");
        this.text.assertTextPresent(this.getCustomFieldLabel(1, 1), CUSTOM_FIELD_NAME_TWO);
        this.text.assertTextPresent(this.getCustomFieldValue(1, 1), "Low");
        this.text.assertTextPresent(this.getCustomFieldLabel(2, 1), CUSTOM_FIELD_NAME);
        this.text.assertTextPresent(this.getCustomFieldValue(2, 1), "Tiger");
        this.deleteIssueOperationFromScreenAssociation("Default Screen Scheme", "Create Issue");
        this.deleteIssueOperationFromScreenAssociation("Default Screen Scheme", "View Issue");
        this.deleteIssueOperationFromScreenAssociation("Default Screen Scheme", "Edit Issue");
    }

    private Locator getCustomFieldLabel(int customfieldTabIndex, int fieldIndex) {
        return this.locator.xpath(String.format("//[@id='customfield-panel-%d']//li[@class='item']//*[@class='name']", customfieldTabIndex, fieldIndex));
    }

    private Locator getCustomFieldValue(int customfieldTabIndex, int fieldIndex) {
        return this.locator.xpath(String.format("//[@id='customfield-panel-%d']//li[@class='item']//*[@class='value']", customfieldTabIndex, fieldIndex));
    }

    private void resetSettings() {
        if (this.projectExists("homosapien")) {
            TestFieldScreens.log("Project homosapien exists");
        } else {
            this.administration.project().addProject("homosapien", "HSP", "admin");
        }
        if (this.projectExists("neanderthal")) {
            TestFieldScreens.log("Project: neanderthal exists");
        } else {
            this.administration.project().addProject("neanderthal", "NDT", "admin");
        }
        this.associateIssueTypeScreenSchemeToProject("homosapien", "Default Issue Type Screen Scheme");
        this.associateIssueTypeScreenSchemeToProject("neanderthal", "Default Issue Type Screen Scheme");
        this.removeAllIssueTypeScreenSchemes();
        this.removeAllCustomFields();
        this.removeAllScreenAssociationsFromDefault();
        this.removeAllFieldScreenSchemes();
        this.removeAllFieldScreens();
    }

    private void createIssueWithCustomField() {
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME);
        this.navigation.issue().goToCreateIssueForm("neanderthal", "Improvement");
        this.tester.setFormElement("summary", "This is an issue in project 2 with a custom field");
        this.tester.setFormElement("customfield_" + this.customFieldId, "Elephant");
        this.tester.submit();
        this.issueKey2 = this.getIssueKey("NDT");
        this.removeFieldFromFieldScreen("Default Screen", new String[]{CUSTOM_FIELD_NAME});
    }

    private String getIssueKey(String projectKey) {
        try {
            String text = this.tester.getDialog().getResponse().getText();
            int projectIdLocation = text.indexOf("[" + projectKey) + 1;
            int endOfIssueKey = text.indexOf("]", projectIdLocation);
            String issueKeyCustomField = text.substring(projectIdLocation, endOfIssueKey);
            return issueKeyCustomField;
        }
        catch (IOException e) {
            TestFieldScreens.fail((String)("Unable to retrieve issue key" + e.getMessage()));
            return null;
        }
    }

    private void checkNoScreenScheme(String project, String issueType, String issueKeyCustomField) {
        TestFieldScreens.log("Checking scheme association for with no scheme selected");
        this.createIssueStep1(project, issueType);
        this.tester.assertFormElementNotPresent("customfield_" + this.customFieldId);
        this.tester.submit();
        this.navigation.issue().gotoIssue(issueKeyCustomField);
        this.tester.assertTextNotPresent(CUSTOM_FIELD_NAME);
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementNotPresent("customfield_" + this.customFieldId);
    }

    private String checkCreateIssueScreenScheme(String screenScheme, String project, String project_key, String issueType) {
        TestFieldScreens.log("Checking scheme association for Create");
        this.addIssueOperationToScreenAssociation(screenScheme, "Create Issue", ADDED_SCREEN_NAME);
        this.createIssueStep1(project, issueType);
        this.tester.setFormElement("summary", "This is a test to see if field is shown");
        this.tester.setFormElement("customfield_" + this.customFieldId, "Elephant");
        this.tester.submit();
        this.tester.assertTextNotPresent("Elephant");
        this.tester.assertTextNotPresent(CUSTOM_FIELD_NAME);
        String issueKeyCustomField = this.getIssueKey(project_key);
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementNotPresent("customfield_" + this.customFieldId);
        this.deleteIssueOperationFromScreenAssociation(screenScheme, "Create Issue");
        return issueKeyCustomField;
    }

    private void checkViewIssueScreenScheme(String screenScheme, String project, String issueType, String issueKeyCustomField) {
        TestFieldScreens.log("Checking scheme association for View");
        this.addIssueOperationToScreenAssociation(screenScheme, "View Issue", ADDED_SCREEN_NAME);
        this.createIssueStep1(project, issueType);
        this.tester.assertFormElementNotPresent("customfield_" + this.customFieldId);
        this.gotoIssue(issueKeyCustomField);
        this.tester.assertTextPresent("Elephant");
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME);
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementNotPresent("customfield_" + this.customFieldId);
        this.deleteIssueOperationFromScreenAssociation(screenScheme, "View Issue");
    }

    private void checkEditIssueScreenScheme(String screenScheme, String project, String issueType, String issueKeyCustomField) {
        TestFieldScreens.log("Checking scheme association for Edit");
        this.addIssueOperationToScreenAssociation(screenScheme, "Edit Issue", ADDED_SCREEN_NAME);
        this.createIssueStep1(project, issueType);
        this.tester.assertFormElementNotPresent("customfield_" + this.customFieldId);
        this.navigation.issue().gotoIssue(issueKeyCustomField);
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("customfield_" + this.customFieldId, "Whale");
        this.tester.submit();
        this.tester.assertTextNotPresent("Whale");
        this.tester.assertTextNotPresent(CUSTOM_FIELD_NAME);
        this.deleteIssueOperationFromScreenAssociation(screenScheme, "Edit Issue");
    }
}

