/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.fields;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.projects.pageobjects.backdoor.SidebarDarkFeatureControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.google.common.collect.Lists;
import com.meterware.httpunit.WebTable;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.FIELDS, Category.SCHEMES})
public class TestFieldConfigurationSchemes
extends JIRAWebTest {
    private static final String FIELD_CONFIGURATION_NAME_ONE = "Test Field Configuration One";
    private SidebarDarkFeatureControl sidebarDarkFeatureControl;

    public TestFieldConfigurationSchemes(String name) {
        super(name);
        this.sidebarDarkFeatureControl = new SidebarDarkFeatureControl((JIRAEnvironmentData)this.environmentData);
    }

    public void testAssociateFieldConfigurationSchemeWhenNoSchemeExists() {
        String name = "New testAssociateFieldLayoutSchemeWhenNoSchemeExists Scheme";
        this.administration.restoreBlankInstance();
        this.tester.gotoPage("/secure/admin/SelectFieldLayoutScheme!default.jspa?projectId=10000");
        this.tester.clickLink("add-new-scheme");
        this.tester.setFormElement("fieldLayoutSchemeName", "New testAssociateFieldLayoutSchemeWhenNoSchemeExists Scheme");
        this.tester.submit("Add");
        this.tester.assertLinkPresent("add-issue-type-field-configuration-association");
        TestFieldConfigurationSchemes.assertEquals((String)"New testAssociateFieldLayoutSchemeWhenNoSchemeExists Scheme", (String)this.locator.xpath("//span[@data-scheme-field='name']").getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFieldConfigurationSchemes() {
        this.administration.restoreBlankInstance();
        boolean sidebarWasEnabled = this.sidebarDarkFeatureControl.isEnabledForSite();
        try {
            if (sidebarWasEnabled) {
                this.sidebarDarkFeatureControl.disableSidebarForSite();
            }
            if (this.projectExists("homosapien")) {
                TestFieldConfigurationSchemes.log("Project 'homosapien' exists");
                if (!this.componentExists("New Component 1", "homosapien")) {
                    this.addComponent("homosapien", "New Component 1");
                }
                if (!this.versionExists("New Version 1", "homosapien")) {
                    this.addVersion("homosapien", "New Version 1", "Version 1");
                }
            } else {
                this.addProject("homosapien", "HSP", "admin");
                this.addComponent("homosapien", "New Component 1");
                this.addVersion("homosapien", "New Version 1", "Version 1");
            }
            if (this.projectExists("neanderthal")) {
                TestFieldConfigurationSchemes.log("Project 'neanderthal' exists");
            } else {
                this.addProject("neanderthal", "NDT", "admin");
            }
            if (this.projectExists("monkey")) {
                TestFieldConfigurationSchemes.log("Project 'monkey' exists");
            } else {
                this.addProject("monkey", "MKY", "admin");
            }
            if (this.fieldSchemeExists("New Field Layout Scheme")) {
                this.deleteFieldLayoutScheme("New Field Layout Scheme");
            }
            this.resetFields();
            String issueKey = this.addIssue("homosapien", "HSP", "Bug", "test for field layout schemes", "Major", null, null, null, "Administrator", "test environment 2", "test description for field layout schemes", null, null, null);
            this.fieldSchemesAddScheme();
            this.fieldSchemesAddDuplicateScheme();
            this.fieldSchemesAddInvalidScheme();
            this.fieldSchemesAssociateWithProject();
            this.fieldSchemesCreateIssueWithFieldConfigurationSchemeHidden();
            this.fieldSchemesCreateIssueWithFieldLayoutSchemeRequired();
            this.checkNavigatorFields();
            this.checkProjectTabPanels();
            this.fieldSchemesEditIssueWithFieldConfigurationSchemeHidden(issueKey);
            this.fieldSchemesEditIssueWithFieldLayoutSchemeRequired(issueKey);
            String issueKey2 = this.addIssue("homosapien", "HSP", "Bug", "test for field layout schemes", "Major", new String[]{"New Component 1"}, new String[]{"New Version 1"}, new String[]{"New Version 1"}, "Administrator", "test environment 2", "test description for field layout schemes", null, null, null);
            this.fieldSchemeMoveIssueWithFieldSchemeHidden(issueKey);
            this.fieldSchemeMoveIssueWithFieldSchemeRequired(issueKey);
            this.fieldSchemeCreateSubTaskWithFieldSchemeHidden(issueKey);
            this.fieldSchemeCreateSubTaskWithFieldSchemeRequired(issueKey);
            this.fieldSchemesDeleteScheme();
            this.deleteIssue(issueKey);
            this.deleteIssue(issueKey2);
        }
        finally {
            if (sidebarWasEnabled) {
                this.sidebarDarkFeatureControl.enableSidebarForSite();
            }
        }
    }

    private void fieldSchemesAddScheme() {
        TestFieldConfigurationSchemes.log("Field Configuration Scheme: Adding a scheme");
        this.addFieldLayoutScheme("New Field Layout Scheme", "field layout scheme for testing");
        this.assertTextPresent("New Field Layout Scheme");
    }

    private void fieldSchemesDeleteScheme() {
        TestFieldConfigurationSchemes.log("Field Configuration Scheme: Deleting a scheme");
        this.deleteFieldLayoutScheme("New Field Layout Scheme");
        this.assertLinkNotPresentWithText("New Field Layout Scheme");
        this.assertLinkNotPresentWithText("field layout scheme for testing");
    }

    private void fieldSchemesAddDuplicateScheme() {
        TestFieldConfigurationSchemes.log("Field Configuration Scheme: Adding a scheme with a duplicate name");
        this.addFieldLayoutScheme("New Field Layout Scheme", "field layout scheme for testing");
        this.assertTextPresent("A field configuration scheme with this name already exists.");
    }

    private void fieldSchemesAddInvalidScheme() {
        TestFieldConfigurationSchemes.log("Field Configuration Scheme: Adding a scheme with a duplicate name");
        this.addFieldLayoutScheme("", "");
        this.assertTextPresent("The field configuration scheme name must not be empty.");
    }

    private void fieldSchemesAssociateWithProject() {
        TestFieldConfigurationSchemes.log("Field Configuration Scheme: associate a scheme to an issue type in a project");
        this.associateFieldLayoutScheme("neanderthal", "Bug", "New Field Layout Scheme");
        this.assertTextPresent("New Field Layout Scheme");
        this.removeAssociationWithFieldLayoutScheme("neanderthal", "Bug", "New Field Layout Scheme");
        this.assertTextNotPresent("New Field Layout Scheme");
    }

    private void fieldSchemesCreateIssueWithFieldLayoutSchemeRequired() {
        TestFieldConfigurationSchemes.log("Create Issue: Attempt to create with issue field configuration");
        this.addFieldLayoutSchemeEntry("Bug", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.createIssueStep1();
        this.setFormElement("summary", "test summary");
        this.submit();
        this.assertTextPresent("CreateIssueDetails.jspa");
        this.assertTextPresent("Component/s is required");
        this.assertTextPresent("Affects Version/s is required");
        this.assertTextPresent("Fix Version/s is required");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Bug", "New Field Layout Scheme");
        this.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
    }

    private void fieldSchemesCreateIssueWithFieldConfigurationSchemeHidden() {
        this.copyFieldLayout(FIELD_CONFIGURATION_NAME_ONE);
        this.addFieldLayoutSchemeEntry("Bug", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        TestFieldConfigurationSchemes.log("Create Issue: Test the creation of am issue using hidden fields");
        this.createIssueStep1();
        this.assertFormElementNotPresent("components");
        this.assertFormElementNotPresent("versions");
        this.assertFormElementNotPresent("fixVersions");
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Bug", "New Field Layout Scheme");
    }

    private void removeFieldConfigurationSchemeEntry(String issueTypeName, String schemeName) {
        this.gotoFieldLayoutSchemes();
        this.clickLinkWithText(schemeName);
        this.assertTextInTable("scheme_entries", issueTypeName);
        try {
            WebTable table = this.getDialog().getResponse().getTableWithID("scheme_entries");
            for (int i = 0; i < table.getRowCount(); ++i) {
                String cellAsText = table.getCellAsText(i, 0);
                if (!TextUtils.stringSet((String)cellAsText) || !cellAsText.contains(issueTypeName)) continue;
                table.getTableCell(i, 2).getLinkWith("Delete").click();
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private void fieldSchemesEditIssueWithFieldConfigurationSchemeHidden(String issueKey) {
        this.addFieldLayoutSchemeEntry("Bug", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        TestFieldConfigurationSchemes.log("Edit Issue: Test the updating of an issue using hidden fields");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.assertFormElementNotPresent("components");
        this.assertFormElementNotPresent("versions");
        this.assertFormElementNotPresent("fixVersions");
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Bug", "New Field Layout Scheme");
    }

    private void assertSearcherFields(boolean presenceFlag) {
        String json = this.tester.getDialog().getElement("criteriaJson").getTextContent();
        String[] searchers = json.split("},");
        ArrayList fieldsToCheck = Lists.newArrayList((Object[])new String[]{"\"id\":\"priority\"", "\"id\":\"resolution\"", "\"id\":\"duedate\""});
        String presenceString = null;
        if (presenceFlag) {
            fieldsToCheck.add("\"id\":\"assignee\"");
            presenceString = "\"isShown\":true";
        } else {
            presenceString = "\"isShown\":false";
        }
        int count = 0;
        for (int index = 0; count < fieldsToCheck.size() && index < searchers.length; ++index) {
            String s = searchers[index];
            if (!s.contains((CharSequence)fieldsToCheck.get(count))) continue;
            Assert.assertThat((Object)s, (Matcher)Matchers.containsString((String)presenceString));
            ++count;
        }
        TestFieldConfigurationSchemes.assertEquals((int)fieldsToCheck.size(), (int)count);
    }

    private void checkNavigatorFields() {
        TestFieldConfigurationSchemes.log("Check Issue Navigator display for hidden/visible fields");
        this.activateSubTasks();
        this.addFieldLayoutSchemeEntry("Bug", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Assignee");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Due Date");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Priority");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Resolution");
        this.getNavigation().issueNavigator().displayAllIssues();
        this.assertSearcherFields(true);
        this.associateFieldLayoutScheme("neanderthal", "Bug", "New Field Layout Scheme");
        this.associateFieldLayoutScheme("monkey", "Bug", "New Field Layout Scheme");
        this.addFieldLayoutSchemeEntry("New Feature", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.addFieldLayoutSchemeEntry("Improvement", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.addFieldLayoutSchemeEntry("Task", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.addFieldLayoutSchemeEntry("Sub-task", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.getNavigation().issueNavigator().displayAllIssues();
        this.assertSearcherFields(false);
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Assignee");
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Due Date");
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Priority");
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Resolution");
        this.getNavigation().issueNavigator().displayAllIssues();
        this.assertSearcherFields(true);
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.removeAssociationWithFieldLayoutScheme("neanderthal", "Bug", "New Field Layout Scheme");
        this.removeAssociationWithFieldLayoutScheme("monkey", "Bug", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Bug", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("New Feature", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Improvement", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Task", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Sub-task", "New Field Layout Scheme");
        this.deactivateSubTasks();
    }

    private void checkProjectTabPanels() {
        TestFieldConfigurationSchemes.log("Check Project Tab Panel for hidden/visible fields");
        this.activateSubTasks();
        this.addFieldLayoutSchemeEntry("Bug", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Version/s");
        this.gotoPage("/browse/HSP");
        this.assertLinkPresentWithText("Components");
        this.assertLinkPresentWithText("Versions");
        this.assertLinkPresentWithText("Road Map");
        this.assertLinkPresentWithText("Change Log");
        this.associateFieldLayoutScheme("neanderthal", "Bug", "New Field Layout Scheme");
        this.associateFieldLayoutScheme("monkey", "Bug", "New Field Layout Scheme");
        this.addFieldLayoutSchemeEntry("New Feature", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.addFieldLayoutSchemeEntry("Improvement", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.addFieldLayoutSchemeEntry("Task", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.addFieldLayoutSchemeEntry("Sub-task", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.gotoPage("/browse/HSP");
        this.assertLinkNotPresentWithText("Open Issues");
        this.assertLinkNotPresentWithText("Components");
        this.assertLinkNotPresentWithText("Versions");
        this.assertLinkNotPresentWithText("Road Map");
        this.assertLinkNotPresentWithText("Change Log");
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Version/s");
        this.navigation.browseProjectTabPanel("HSP", "com.atlassian.jira.jira-projects-plugin:issues-panel-panel");
        this.assertTextPresent("Unresolved: By Component");
        this.assertTextPresent("Unresolved: By Version");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.removeAssociationWithFieldLayoutScheme("neanderthal", "Bug", "New Field Layout Scheme");
        this.removeAssociationWithFieldLayoutScheme("monkey", "Bug", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Bug", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("New Feature", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Improvement", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Task", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Sub-task", "New Field Layout Scheme");
        this.deactivateSubTasks();
    }

    private void fieldSchemesEditIssueWithFieldLayoutSchemeRequired(String issueKey) {
        TestFieldConfigurationSchemes.log("Edit Issue: Attempt to edit an issue with issue field configuration");
        this.addFieldLayoutSchemeEntry("Bug", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.gotoIssue(issueKey);
        this.clickLink("edit-issue");
        this.assertTextPresent("Edit Issue");
        this.submit("Update");
        this.assertTextPresent("Component/s is required");
        this.assertTextPresent("Affects Version/s is required");
        this.assertTextPresent("Fix Version/s is required");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Bug", "New Field Layout Scheme");
        this.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
    }

    private void fieldSchemeMoveIssueWithFieldSchemeHidden(String issueKey) {
        TestFieldConfigurationSchemes.log("Move Issue: Test the abilty to hide a field in a particular Field Configuration Scheme");
        this.addFieldLayoutSchemeEntry("Improvement", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Improvement", "New Field Layout Scheme");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.gotoIssue(issueKey);
        this.clickLink("move-issue");
        this.assertTextPresent("Move Issue");
        this.navigation.issue().selectIssueType("Improvement", "issuetype");
        this.submit();
        this.assertTextPresent("All fields will be updated automatically.");
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Improvement", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Improvement", "New Field Layout Scheme");
    }

    private void fieldSchemeMoveIssueWithFieldSchemeRequired(String issueKey) {
        TestFieldConfigurationSchemes.log("Move Issue: Test the abilty to make a field required in a particular Field Configuration Scheme");
        this.addFieldLayoutSchemeEntry("Improvement", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Improvement", "New Field Layout Scheme");
        this.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.gotoIssue(issueKey);
        this.clickLink("move-issue");
        this.assertTextPresent("Move Issue");
        this.navigation.issue().selectIssueType("Improvement", "issuetype");
        this.submit();
        this.assertTextPresent("Step 3 of 4");
        this.getDialog().setWorkingForm("jiraform");
        this.submit();
        this.assertTextPresent("Step 3 of 4");
        this.assertTextPresent("Component/s is required");
        this.assertTextPresent("Affects Version/s is required");
        this.assertTextPresent("Fix Version/s is required");
        this.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Improvement", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Improvement", "New Field Layout Scheme");
    }

    private void fieldSchemeCreateSubTaskWithFieldSchemeRequired(String issueKey) {
        TestFieldConfigurationSchemes.log("Sub Task Create: Enforce Sub Tasks on a field configuration scheme");
        this.activateSubTasks();
        this.addFieldLayoutSchemeEntry("Sub-task", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Sub-task", "New Field Layout Scheme");
        this.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.gotoIssue(issueKey);
        this.clickLink("create-subtask");
        this.assertTextPresent("Create Sub-Task");
        this.setFormElement("summary", "test summary");
        this.submit();
        this.assertTextPresent("Create Sub-Task");
        this.assertTextPresent("Component/s is required");
        this.assertTextPresent("Affects Version/s is required");
        this.assertTextPresent("Fix Version/s is required");
        this.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Sub-task", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Sub-task", "New Field Layout Scheme");
        this.deactivateSubTasks();
    }

    private void fieldSchemeCreateSubTaskWithFieldSchemeHidden(String issueKey) {
        TestFieldConfigurationSchemes.log("Sub Task Create: Enforce Sub Tasks on a field configuration scheme");
        this.activateSubTasks();
        this.addFieldLayoutSchemeEntry("Sub-task", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Sub-task", "New Field Layout Scheme");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.gotoIssue(issueKey);
        this.clickLink("create-subtask");
        this.assertTextPresent("Create Sub-Task");
        this.assertFormElementNotPresent("components");
        this.assertFormElementNotPresent("versions");
        this.assertFormElementNotPresent("fixVersions");
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Sub-task", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Sub-task", "New Field Layout Scheme");
        this.deactivateSubTasks();
    }
}

