/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.email.EmailKit;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.AbstractSubscriptionEmailTest;
import com.icegreen.greenmail.util.GreenMailUtil;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.EMAIL})
public class TestSharedEmailSubscription
extends AbstractSubscriptionEmailTest {
    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestSharedSubscription.xml");
        this.configureAndStartSmtpServer();
        this.backdoor.userProfile().changeUserNotificationType("bob", "text");
    }

    public void testHtmlSharedZeroResults() throws Exception {
        this.navigation.login("fred", "fred");
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_ZERO_RESULTS, null);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.flushMailQueueAndWait(1);
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        TestSharedEmailSubscription.assertNotNull((Object)messages[0]);
        this.assertHtmlMessageValid(messages[0], AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_ZERO_RESULTS, "jiratest@atlassian.com", "fred@example.com", "fred");
        String body = GreenMailUtil.getBody((Part)messages[0]);
        TestSharedEmailSubscription.assertNotPartialLink(body);
        TestSharedEmailSubscription.assertEditLinkHtml(body);
    }

    public void testHtmlSharedCompleteResults() throws Exception {
        this.navigation.login("fred", "fred");
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_FULL, null);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.flushMailQueueAndWait(1);
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        TestSharedEmailSubscription.assertNotNull((Object)messages[0]);
        this.assertHtmlMessageValid(messages[0], AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_FULL, "jiratest@atlassian.com", "fred@example.com", "fred");
        String body = EmailKit.getBody((Part)messages[0]);
        TestSharedEmailSubscription.assertNotPartialLink(body);
        TestSharedEmailSubscription.assertEditLinkHtml(body);
    }

    public void testHtmlSharedPartialResults() throws Exception {
        this.navigation.login("fred", "fred");
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, null);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.flushMailQueueAndWait(1);
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        TestSharedEmailSubscription.assertNotNull((Object)messages[0]);
        this.assertHtmlMessageValid(messages[0], AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, "jiratest@atlassian.com", "fred@example.com", "fred");
        String body = EmailKit.getBody((Part)messages[0]);
        body = TestSharedEmailSubscription.assertPartialLinkHtml(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, body);
        TestSharedEmailSubscription.assertEditLinkHtml(body);
    }

    public void testTextSharedZeroResults() throws Exception {
        this.navigation.login("bob", "bob");
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_ZERO_RESULTS, null);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.flushMailQueueAndWait(1);
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        TestSharedEmailSubscription.assertNotNull((Object)messages[0]);
        this.assertTextMessageValid(messages[0], AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_ZERO_RESULTS, "jiratest@atlassian.com", "bob@stuff.com.com", "bob");
        String body = GreenMailUtil.getBody((Part)messages[0]);
        TestSharedEmailSubscription.assertNotPartialLink(body);
        TestSharedEmailSubscription.assertEditLinkText(body);
    }

    public void testTextSharedCompleteResults() throws Exception {
        this.navigation.login("bob", "bob");
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_FULL, null);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.flushMailQueueAndWait(1);
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        TestSharedEmailSubscription.assertNotNull((Object)messages[0]);
        this.assertTextMessageValid(messages[0], AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_FULL, "jiratest@atlassian.com", "bob@stuff.com.com", "bob");
        String body = GreenMailUtil.getBody((Part)messages[0]);
        TestSharedEmailSubscription.assertNotPartialLink(body);
        TestSharedEmailSubscription.assertEditLinkText(body);
    }

    public void testTextSharedPartialResults() throws Exception {
        this.navigation.login("bob", "bob");
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, null);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.flushMailQueueAndWait(1);
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        TestSharedEmailSubscription.assertNotNull((Object)messages[0]);
        this.assertTextMessageValid(messages[0], AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, "jiratest@atlassian.com", "bob@stuff.com.com", "bob");
        String body = GreenMailUtil.getBody((Part)messages[0]);
        body = TestSharedEmailSubscription.assertPartialLinkText(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, body);
        TestSharedEmailSubscription.assertEditLinkText(body);
    }
}

