/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.RegexMatchers;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import com.atlassian.jira.webtests.JIRAServerSetup;
import com.atlassian.jira.webtests.ztests.email.ShareClient;
import com.google.common.collect.Sets;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.io.IOException;
import java.util.HashSet;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
public class TestShareEmails
extends EmailFuncTestCase {
    private ShareClient shareClient;
    private String issueKey;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.backdoor.restoreBlankInstance();
        this.startMailService(JIRAServerSetup.SMTP);
        int smtpPort = this.mailService.getSmtpPort();
        this.backdoor.mailServers().addSmtpServer(smtpPort);
        this.issueKey = this.backdoor.issues().createIssue(10000L, "Issue 1", "admin").key();
        this.shareClient = new ShareClient(this.getEnvironmentData());
        this.mailService.addUser("bob@stuff.com.com", "bob", "bob");
        this.mailService.addUser("fred@example.com", "fred", "fred");
        this.mailService.addUser("fake@example.com", "fake", "fake");
        this.backdoor.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        this.backdoor.userProfile().changeUserNotificationType("bob", "text");
        this.backdoor.userProfile().changeUserNotificationType("fred", "html");
    }

    public void testAll() throws Exception {
        this.log("Running _testShareIssue");
        this._testShareIssue();
        this.log("Running _testShareSavedSearch");
        this._testShareSavedSearch();
        this.log("Running _testShareJqlSearch");
        this._testShareJqlSearch();
    }

    public void _testShareIssue() throws Exception {
        HashSet usernames = Sets.newHashSet((Object[])new String[]{"fred", "bob"});
        HashSet emails = Sets.newHashSet((Object[])new String[]{"fake@example.com"});
        String comment = "I thought you should know";
        this.shareClient.shareIssue(this.issueKey, usernames, emails, comment);
        this.flushMailQueueAndWait(3);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessagesAndClear();
        MimeMessage message = this.getMessageForAddress(mimeMessages, "fred@example.com");
        String subject = message.getSubject();
        String body = GreenMailUtil.getBody((Part)message);
        this.assertMessageIsHtml(message);
        TestShareEmails.assertEquals((String)"[JIRATEST] Administrator shared \"HSP-1: Issue 1\" with you", (String)subject);
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)"shared</strong> an issue with you"));
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)comment));
        MatcherAssert.assertThat((Object)body, (Matcher)RegexMatchers.regexMatches("/browse/HSP-1\".*>HSP-1</a>"));
        message = this.getMessageForAddress(mimeMessages, "bob@stuff.com.com");
        subject = message.getSubject();
        body = GreenMailUtil.getBody((Part)message);
        this.assertMessageIsText(message);
        TestShareEmails.assertEquals((String)"[JIRATEST] Administrator shared \"HSP-1: Issue 1\" with you", (String)subject);
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)"Administrator shared an issue with you"));
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)"/browse/HSP-1"));
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)comment));
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)"Key: HSP-1"));
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)"Project: homosapien"));
        message = this.getMessageForAddress(mimeMessages, "fake@example.com");
        this.assertMessageIsHtml(message);
    }

    public void _testShareSavedSearch() throws Exception {
        String searchJql = "project = HSP";
        String searchName = "Funky Homosapiens";
        String searchDescription = "Find those dudes!";
        String jsonShareString = "[{\"type\":\"global\"}]";
        String filterId = this.backdoor.searchRequests().createFilter("admin", searchJql, searchName, searchDescription, jsonShareString);
        HashSet usernames = Sets.newHashSet((Object[])new String[]{"fred", "bob"});
        HashSet emails = Sets.newHashSet((Object[])new String[]{"fake@example.com"});
        String comment = "I thought you should know";
        this.shareClient.shareSavedSearch(filterId, usernames, emails, comment);
        this.flushMailQueueAndWait(3);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessagesAndClear();
        MimeMessage message = this.getMessageForAddress(mimeMessages, "fred@example.com");
        String subject = message.getSubject();
        String body = GreenMailUtil.getBody((Part)message);
        TestShareEmails.assertEquals((String)"[JIRATEST] Administrator shared the filter \"Funky Homosapiens\" with you", (String)subject);
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)"Administrator</a>"));
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)"<b>shared</b> a filter with you"));
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)"I thought you should know"));
        MatcherAssert.assertThat((Object)body, (Matcher)RegexMatchers.regexMatches("/secure/IssueNavigator.jspa\\?mode=hide\\&amp;requestId=" + filterId + "\" style=\".*\">" + searchName));
        message = this.getMessageForAddress(mimeMessages, "bob@stuff.com.com");
        subject = message.getSubject();
        body = GreenMailUtil.getBody((Part)message);
        this.assertMessageIsText(message);
        TestShareEmails.assertEquals((String)"[JIRATEST] Administrator shared the filter \"Funky Homosapiens\" with you", (String)subject);
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)"Administrator shared a filter with you"));
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)"I thought you should know"));
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)("/secure/IssueNavigator.jspa?mode=hide&requestId=" + filterId)));
        message = this.getMessageForAddress(mimeMessages, "fake@example.com");
        subject = message.getSubject();
        body = GreenMailUtil.getBody((Part)message);
        this.assertMessageIsHtml(message);
        TestShareEmails.assertEquals((String)"[JIRATEST] Administrator shared a search result with you", (String)subject);
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)"Administrator</a>"));
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)"<b>shared</b> a search result with you"));
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)"I thought you should know"));
        MatcherAssert.assertThat((Object)body, (Matcher)RegexMatchers.regexMatches("/secure/IssueNavigator.jspa\\?reset=true\\&amp;jqlQuery=project\\+%3D\\+HSP\""));
    }

    public void _testShareJqlSearch() throws Exception {
        String searchJql = "project = HSP";
        HashSet usernames = Sets.newHashSet((Object[])new String[]{"fred", "bob"});
        String comment = "I thought you should know";
        this.shareClient.shareSearchQuery(searchJql, usernames, null, comment);
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        MimeMessage message = this.getMessageForAddress(mimeMessages, "fred@example.com");
        String subject = message.getSubject();
        String body = GreenMailUtil.getBody((Part)message);
        this.assertMessageIsHtml(message);
        TestShareEmails.assertEquals((String)"[JIRATEST] Administrator shared a search result with you", (String)subject);
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)"Administrator</a>"));
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)"<b>shared</b> a search result with you"));
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)"I thought you should know"));
        MatcherAssert.assertThat((Object)body, (Matcher)RegexMatchers.regexMatches("/secure/IssueNavigator.jspa\\?reset=true\\&amp;jqlQuery=project\\+%3D\\+HSP\" style=\".*\">View search results"));
        message = this.getMessageForAddress(mimeMessages, "bob@stuff.com.com");
        subject = message.getSubject();
        body = GreenMailUtil.getBody((Part)message);
        this.assertMessageIsText(mimeMessages[0]);
        TestShareEmails.assertEquals((String)"[JIRATEST] Administrator shared a search result with you", (String)subject);
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)"Administrator shared a search result with you"));
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)comment));
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)"/secure/IssueNavigator.jspa?reset=true&jqlQuery=project+%3D+HSP"));
    }

    private void assertMessageIsText(MimeMessage textMessage) throws MessagingException, IOException {
        this.assertMessageContainsContentWithType(textMessage, "text/plain; charset=UTF-8");
    }

    private void assertMessageIsHtml(MimeMessage textMessage) throws MessagingException, IOException {
        this.assertMessageContainsContentWithType(textMessage, "text/html; charset=UTF-8");
    }

    private void assertMessageContainsContentWithType(MimeMessage htmlMessage, String expectedType) throws MessagingException, IOException {
        Object content = htmlMessage.getContent();
        if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            for (int i = 0; i < multipart.getCount(); ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                if (!expectedType.equals(bodyPart.getContentType())) continue;
                return;
            }
            TestShareEmails.fail((String)("Message did not contain any BodyPart with type: " + expectedType));
        }
        TestShareEmails.assertEquals((String)expectedType, (String)htmlMessage.getContentType());
    }

    private MimeMessage getMessageForAddress(MimeMessage[] messages, String toAddress) throws MessagingException {
        for (MimeMessage message : messages) {
            Address[] recipients = message.getRecipients(Message.RecipientType.TO);
            if (!recipients[0].toString().equals(toAddress)) continue;
            return message;
        }
        TestShareEmails.fail((String)("Didn't find a message for : " + toAddress));
        return null;
    }
}

