/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.admin.MailServerAdministration;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.io.IOUtils;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
public class TestSendTestEmail
extends EmailFuncTestCase {
    public static final int PORT = 25025;
    private SmtpServerNotRespondingToQuit testMail = new SmtpServerNotRespondingToQuit();

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
        this.testMail.startServer(25025);
    }

    @Override
    public void tearDownTest() {
        this.testMail.stop();
        super.tearDownTest();
    }

    public void testJiraConsidersTestMailSuccessfulWhenTheMailServerDoesNotRespondToQuitCommand() throws InterruptedException {
        this.assertSendingMailIsEnabled();
        this.log("Setting SMTP server to 'localhost:25025'");
        this.backdoor.mailServers().addSmtpServer("admin@example.com", "PRE", 25025);
        MailServerAdministration.SendTestEmail sendTestEmail = this.administration.mailServers().Smtp().goTo().sendTestEmail();
        sendTestEmail.send();
        sendTestEmail.assertMessageSentInformationDisplayed();
    }

    class SmtpServerNotRespondingToQuit {
        ServerSocket serverSocket;
        Thread serverThread;

        SmtpServerNotRespondingToQuit() {
        }

        public void stop() {
            this.closeQuietly(this.serverSocket);
            this.serverThread.interrupt();
        }

        private void closeQuietly(ServerSocket serverSocket) {
            try {
                if (serverSocket != null) {
                    serverSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void startServer(final int port) {
            this.serverThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    TestSendTestEmail.this.log("SmtpServerNotRespondingToQuit starting up");
                    try {
                        SmtpServerNotRespondingToQuit.this.serverSocket = new ServerSocket(port);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                    boolean data = false;
                    InputStream inputStream = null;
                    OutputStream outputStream = null;
                    Socket socket = null;
                    try {
                        String line;
                        socket = SmtpServerNotRespondingToQuit.this.serverSocket.accept();
                        inputStream = socket.getInputStream();
                        outputStream = socket.getOutputStream();
                        PrintWriter pw = new PrintWriter(outputStream);
                        pw.println("220 SmtpServerNotRespondingToQuit Simple Mail Transfer Service Ready");
                        pw.flush();
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        while ((line = bufferedReader.readLine()) != null) {
                            if (line.startsWith("EHLO")) {
                                pw.println("250-SmtpServerNotRespondingToQuit greets localhost");
                                pw.println("250 HELP");
                            } else if (line.startsWith("DATA")) {
                                pw.println("354 Start mail input; end with <CRLF>.<CRLF>");
                                data = true;
                            } else if (line.trim().equals(".")) {
                                data = false;
                                pw.println("250 OK");
                            } else if (!line.startsWith("QUIT") && !data) {
                                pw.println("250 OK");
                            }
                            pw.flush();
                        }
                    }
                    catch (Throwable ex) {
                        try {
                            TestSendTestEmail.this.log(ex);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(outputStream);
                            IOUtils.closeQuietly(inputStream);
                            IOUtils.closeQuietly((Socket)socket);
                            SmtpServerNotRespondingToQuit.this.closeQuietly(SmtpServerNotRespondingToQuit.this.serverSocket);
                            TestSendTestEmail.this.log("SmtpServerNotRespondingToQuit shutting down");
                            throw throwable;
                        }
                        IOUtils.closeQuietly(outputStream);
                        IOUtils.closeQuietly((InputStream)inputStream);
                        IOUtils.closeQuietly((Socket)socket);
                        SmtpServerNotRespondingToQuit.this.closeQuietly(SmtpServerNotRespondingToQuit.this.serverSocket);
                        TestSendTestEmail.this.log("SmtpServerNotRespondingToQuit shutting down");
                    }
                    IOUtils.closeQuietly((OutputStream)outputStream);
                    IOUtils.closeQuietly((InputStream)inputStream);
                    IOUtils.closeQuietly((Socket)socket);
                    SmtpServerNotRespondingToQuit.this.closeQuietly(SmtpServerNotRespondingToQuit.this.serverSocket);
                    TestSendTestEmail.this.log("SmtpServerNotRespondingToQuit shutting down");
                }
            };
            this.serverThread.start();
        }
    }
}

