/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import java.io.IOException;
import java.util.UUID;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.StringContains;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
public class TestNonEnglishNotifications
extends EmailFuncTestCase {
    public void testNonEnglishNotifications() throws InterruptedException, MessagingException, IOException {
        String randomPrefix = "[" + UUID.randomUUID().toString() + "]";
        this.navigation.login("admin");
        this.administration.restoreData("TestTranslatedNotifications.xml");
        this.configureAndStartSmtpServer("jiratest@atlassian.com", randomPrefix);
        this.navigation.login("fred");
        this.tester.gotoPage("/secure/ViewSubscriptions.jspa?filterId=10000");
        this.tester.clickLinkWithText("Ex\u00e9cuter maintenant");
        this.navigation.login("admin");
        this.flushMailQueueAndWait(1);
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        Assert.assertThat((String)"There should be at least one notification sent", (Object)messages.length, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        for (MimeMessage message : messages) {
            if (!message.getSubject().contains(randomPrefix)) continue;
            String body = this.getTextContentFromMail(message);
            Assert.assertThat((Object)body, (Matcher)StringContains.containsString((String)"Non attribu&eacute;e"));
            Assert.assertThat((Object)body, (Matcher)StringContains.containsString((String)"Non r&eacute;solu"));
            Assert.assertThat((Object)body, (Matcher)StringContains.containsString((String)"17/mars/09"));
            return;
        }
        TestNonEnglishNotifications.fail((String)"No matching message was found!");
    }

    private String getTextContentFromMail(MimeMessage message) throws IOException, MessagingException {
        Object content = message.getContent();
        if (content instanceof MimeMultipart) {
            MimeMultipart multipart = (MimeMultipart)content;
            for (int i = 0; i < multipart.getCount(); ++i) {
                BodyPart part = multipart.getBodyPart(i);
                if (!part.isMimeType("text/html") && !part.isMimeType("text/plain")) continue;
                return part.getContent().toString();
            }
        }
        return content.toString();
    }
}

