/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import com.icegreen.greenmail.store.FolderException;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
public class TestMentions
extends EmailFuncTestCase {
    public static final String ISSUE_KEY_1 = "HSP-1";
    public static final String ISSUE_KEY_2 = "HSP-4";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestMentions.xml");
        this.configureAndStartSmtpServerWithNotify();
        this.mailService.addUser("admin@example.com", "admin", "admin");
        this.mailService.addUser("bob@example.com", "bob", "bob");
        this.mailService.addUser("fred@example.com", "fred", "fred");
        this.backdoor.userProfile().changeUserNotificationType("admin", "text");
    }

    public void testSendMentions() throws InterruptedException, MessagingException, IOException, FolderException {
        this.navigation.issue().addComment(ISSUE_KEY_1, "I think [~bob] should have a look at this!");
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        TestMentions.assertEquals((int)2, (int)mimeMessages.length);
        MimeMessage mimeMessage = this.getMentionMail(mimeMessages);
        this.assertEmailToEquals(mimeMessage, "bob@example.com");
        this.assertEmailSubjectEquals(mimeMessage, this.expectedEmailSubject(ISSUE_KEY_1));
        this.assertEmailBodyContains(mimeMessage, "Bob Brown");
        this.assertEmailBodyContains(mimeMessage, "should have a look at this");
        this.navigation.issue().addComment(ISSUE_KEY_1, "This is a test comment for [~admin].");
        this.flushMailQueueAndWait(1);
        this.mailService.removeAllReceivedMessages();
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.EDIT_ALL_COMMENTS, "jira-administrators");
        this.navigation.issue().viewIssue(ISSUE_KEY_1);
        this.tester.clickLink("edit_comment_10201");
        this.tester.setFormElement("comment", "I think [~admin] should have a look at this! [~bob] why don't you check this out too?");
        this.tester.submit();
        this.flushMailQueueAndWait(2);
        mimeMessages = this.mailService.getReceivedMessages();
        TestMentions.assertEquals((int)2, (int)mimeMessages.length);
        mimeMessage = this.getMentionMail(mimeMessages);
        this.assertEmailToEquals(mimeMessage, "bob@example.com");
        this.assertEmailSubjectEquals(mimeMessage, this.expectedEmailSubject(ISSUE_KEY_1));
        this.assertEmailBodyContains(mimeMessage, "Bob Brown");
        this.assertEmailBodyContains(mimeMessage, "why don't you check this out too?");
    }

    public void testSendMentionsOnlySendsOneEmail() throws InterruptedException, MessagingException, IOException, FolderException {
        this.navigation.issue().addComment(ISSUE_KEY_1, "I think [~admin] should have a look at this!");
        this.flushMailQueueAndWait(1);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        TestMentions.assertEquals((int)1, (int)mimeMessages.length);
        MimeMessage mimeMessage = this.getMentionMail(mimeMessages);
        TestMentions.assertNull((Object)mimeMessage);
        this.assertEmailBodyContains(mimeMessages[0], "Administrator commented on HSP-1");
        this.assertEmailBodyDoesntContain(mimeMessages[0], "mentioned");
    }

    public void testNoMentionsSentForUserWithoutBrowseUsersPermission() throws InterruptedException, MessagingException {
        this.navigation.logout();
        this.navigation.login("bob");
        this.navigation.userProfile().changeAutowatch(false);
        this.navigation.issue().addComment(ISSUE_KEY_1, "I think [~admin] should have a look at this!");
        this.navigation.logout();
        this.navigation.login("admin");
        this.flushMailQueueAndWait(1);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        TestMentions.assertEquals((int)1, (int)mimeMessages.length);
        TestMentions.assertFalse((boolean)mimeMessages[0].getSubject().contains("mentioned"));
    }

    public void testNoMentionsSentForUserWithoutBrowseIssuePermission() throws InterruptedException, MessagingException, IOException {
        this.navigation.issue().addComment(ISSUE_KEY_1, "I think [~fred] should have a look at this!");
        this.flushMailQueueAndWait(1);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        TestMentions.assertEquals((int)1, (int)mimeMessages.length);
        TestMentions.assertFalse((boolean)mimeMessages[0].getSubject().contains("mentioned"));
    }

    public void testSendHtmlMention() throws InterruptedException, MessagingException, IOException {
        this.navigation.issue().addComment(ISSUE_KEY_1, "I think [~bob] should have a look at this!");
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        TestMentions.assertEquals((int)2, (int)mimeMessages.length);
        MimeMessage mimeMessage = this.getMentionMail(mimeMessages);
        this.assertEmailSubjectEquals(mimeMessage, this.expectedEmailSubject(ISSUE_KEY_1));
        this.assertEmailBodyContains(mimeMessage, "Bob Brown</a>");
        this.assertEmailBodyContains(mimeMessage, "<strong>mentioned you</strong> on");
    }

    public void testSendMentionForDescription() throws InterruptedException, MessagingException, IOException, FolderException {
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "This is a first test issue", MapBuilder.newBuilder().add("description", new String[]{"Hello [~admin]. I created this! Hi [~bob] I just mentioned you!"}).toMap());
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        TestMentions.assertEquals((int)2, (int)mimeMessages.length);
        MimeMessage mimeMessage = this.getMentionMail(mimeMessages);
        this.assertEmailSubjectEquals(mimeMessage, this.expectedEmailSubject(issueKey));
        this.assertEmailBodyContains(mimeMessage, "I just mentioned you");
        this.assertEmailBodyContains(mimeMessage, "Bob Brown");
        this.navigation.issue().createIssue("homosapien", "Bug", "This is a first test issue", MapBuilder.newBuilder().add("description", new String[]{"Hello [~admin]. I created this!"}).toMap());
        this.flushMailQueueAndWait(1);
        this.mailService.removeAllReceivedMessages();
        this.navigation.issue().gotoEditIssue(ISSUE_KEY_2);
        this.tester.setFormElement("description", "Hello [~admin]. I created this! Hey [~bob] you are in the description too now!");
        this.tester.submit();
        this.flushMailQueueAndWait(2);
        mimeMessages = this.mailService.getReceivedMessages();
        TestMentions.assertEquals((int)2, (int)mimeMessages.length);
        mimeMessage = this.getMentionMail(mimeMessages);
        this.assertEmailToEquals(mimeMessage, "bob@example.com");
        this.assertEmailSubjectEquals(mimeMessage, this.expectedEmailSubject(ISSUE_KEY_2));
        this.assertEmailBodyContains(mimeMessage, "Bob Brown");
        this.assertEmailBodyContains(mimeMessage, "you are in the description too now!");
    }

    private String expectedEmailSubject(String issueKey) {
        return "[JIRATEST] Administrator mentioned you on " + issueKey + " (JIRA)";
    }

    public void testEmailUserLinkWhenMentionedInIssueComment() throws Exception {
        this.navigation.issue().addComment(ISSUE_KEY_1, "This is me mentioning [~bob]");
        String baseUrl = this.backdoor.getTestkit().applicationProperties().getString("jira.baseurl");
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        TestMentions.assertEquals((int)2, (int)mimeMessages.length);
        MimeMessage mimeMessage = this.getMentionMail(mimeMessages);
        this.assertEmailBodyContains(mimeMessage, String.format("href=\"%s/secure/ViewProfile.jspa?name=bob\"", baseUrl));
    }

    public void testEmailUserOnceWhenWatchingAndMentioned() throws Exception {
        this.navigation.issue().addWatchers(ISSUE_KEY_1, "bob");
        this.navigation.issue().addComment(ISSUE_KEY_1, "This is me mentioning [~bob]");
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        TestMentions.assertEquals((int)2, (int)mimeMessages.length);
    }

    private MimeMessage getMentionMail(MimeMessage[] mimeMessages) throws MessagingException {
        for (MimeMessage mimeMessage : mimeMessages) {
            if (!mimeMessage.getSubject().contains("mentioned")) continue;
            return mimeMessage;
        }
        return null;
    }
}

