/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import com.google.common.collect.Lists;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
public class TestMailImageAttachments
extends EmailFuncTestCase {
    public static final Pattern IMG_SRC_WITH_CID = Pattern.compile("<img.*?src=\"cid:(\\S+)\"");

    public void testEachImageAttachmentIsVisible() throws Exception {
        this.administration.restoreData("TestIssueNotifications.xml");
        this.configureAndStartSmtpServerWithNotify();
        String issueId = "COW-1";
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        TestMailImageAttachments.assertEquals((int)2, (int)mimeMessages.length);
        for (MimeMessage mimeMessage : mimeMessages) {
            this.assertEachCidAttachmentIsUsedInMailMessage(mimeMessage);
        }
    }

    private void nottestMentionsEmails(int foo) throws Exception {
        this.administration.restoreData("TestIssueNotifications.xml");
        this.configureAndStartSmtpServerWithNotify();
        this.backdoor.usersAndGroups().addUser("user10");
        String issueId = "COW-1";
        this.navigation.issue().addComment("COW-1", "Some Comment [~user10]");
        this.flushMailQueueAndWait(3);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertThat((Object)mimeMessages.length, (org.hamcrest.Matcher)Matchers.equalTo((Object)3));
        for (MimeMessage message : mimeMessages) {
            this.assertEachImageWithCidHasCorrespondingAttachment(message);
        }
    }

    private void assertEachCidAttachmentIsUsedInMailMessage(MimeMessage mimeMessage) throws IOException, MessagingException {
        Object content = mimeMessage.getContent();
        Assert.assertThat((Object)content, (org.hamcrest.Matcher)Matchers.is((org.hamcrest.Matcher)Matchers.instanceOf(Multipart.class)));
        Multipart multipart = (Multipart)content;
        Collection<String> contentIds = this.getContentIds(multipart);
        for (String contentId : contentIds) {
            this.assertEmailBodyContains(mimeMessage, contentId);
        }
    }

    private Collection<String> getContentIds(Multipart multipart) throws MessagingException {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart bodyPart = multipart.getBodyPart(i);
            String[] headers = bodyPart.getHeader("Content-ID");
            if (headers == null) continue;
            Assert.assertThat((String)"There should be only one 'Content-ID' header in BodyPart", (Object)headers.length, (org.hamcrest.Matcher)Matchers.equalTo((Object)1));
            String cidHeader = headers[0];
            result.add(cidHeader.substring(1, cidHeader.length() - 1));
        }
        return result;
    }

    private void assertEachImageWithCidHasCorrespondingAttachment(MimeMessage message) throws MessagingException, IOException {
        Object content = message.getContent();
        Assert.assertThat((Object)content, (org.hamcrest.Matcher)Matchers.is((org.hamcrest.Matcher)Matchers.instanceOf(Multipart.class)));
        Multipart multipart = (Multipart)content;
        Object[] cidsFromMessage = this.getCidsFromMessage(GreenMailUtil.getBody((Part)message));
        Collection<String> contentIds = this.getContentIds(multipart);
        Assert.assertThat(contentIds, (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])cidsFromMessage));
    }

    private String[] getCidsFromMessage(String messageBody) {
        Matcher matcher = IMG_SRC_WITH_CID.matcher(messageBody);
        ArrayList result = Lists.newArrayList();
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result.toArray(new String[result.size()]);
    }
}

