/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.UserProfileImpl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import com.google.common.collect.ImmutableList;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL, Category.ISSUES})
public class TestIssueNotifications
extends EmailFuncTestCase {
    @Override
    public void tearDownTest() {
        this.backdoor.darkFeatures().disableForSite("jira.no.frother.reporter.field");
        super.tearDownTest();
    }

    @Override
    protected void configureAndStartSmtpServerWithNotify() {
        super.configureAndStartSmtpServerWithNotify();
        this.navigation.login("henry.ford");
        this.navigation.userProfile().changeNotifyMyChanges(true);
        this.navigation.logout();
        this.navigation.login("admin");
    }

    public void testDeleteUserBeforeCommentNotification() throws InterruptedException, MessagingException, IOException {
        this.administration.restoreData("TestIssueNotifications.xml");
        this.backdoor.darkFeatures().enableForSite("jira.no.frother.reporter.field");
        this.configureAndStartSmtpServerWithNotify();
        this.configureService();
        this.navigation.logout();
        this.navigation.login("henry.ford");
        this.navigation.issue().viewIssue("COW-2");
        this.tester.clickLink("footer-comment-button");
        this.tester.setFormElement("comment", "monkeys");
        this.tester.submit();
        this.tester.clickLink("delete_comment_10000");
        this.tester.submit("Delete");
        this.navigation.logout();
        this.navigation.login("admin");
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("reporter", "admin");
        this.tester.submit("Update");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.navigation.webSudoAuthenticateUsingLastPassword();
        this.tester.clickLink("deleteuser_link_henry.ford");
        this.tester.submit("Delete");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SERVICES);
        this.flushMailQueueAndWait(3);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        TestIssueNotifications.assertEquals((int)3, (int)mimeMessages.length);
        this.assertEmailBodyContainsLine(mimeMessages[0], ".*henry.ford\\s.*commented.*");
        this.assertEmailBodyContainsLine(mimeMessages[0], ".*COW.*/.*COW-2.*");
        this.assertEmailBodyContainsLine(mimeMessages[1], ".*henry.ford\\s.*updated.*");
        this.assertEmailBodyContainsLine(mimeMessages[1], ".*COW.*/.*COW-2.*");
        this.assertEmailBodyContainsLine(mimeMessages[2], ".*admin.+\\s.*updated.*");
        this.assertEmailBodyContainsLine(mimeMessages[2], ".*COW.*/.*COW-1.*");
    }

    public void testDeleteIssueBeforeCommentNotification() throws InterruptedException, MessagingException, IOException {
        EnvironmentUtils envUtils = new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation);
        if (envUtils.isOnWindows()) {
            return;
        }
        this.administration.restoreData("TestIssueNotifications.xml");
        this.configureAndStartSmtpServerWithNotify();
        this.configureService();
        this.navigation.logout();
        this.navigation.login("henry.ford");
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("footer-comment-button");
        this.tester.setFormElement("comment", "monkeys");
        this.tester.submit();
        this.navigation.logout();
        this.navigation.login("admin");
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SERVICES);
        this.navigation.webSudoAuthenticateUsingLastPassword();
        this.flushMailQueueAndWait(4);
        this.assertCommentAndDeleteMessages(this.getMessagesForRecipient("Henry.Ford@example.com"));
        this.assertCommentAndDeleteMessages(this.getMessagesForRecipient("admin@example.com"));
    }

    private void assertCommentAndDeleteMessages(List<MimeMessage> mimeMessages) throws IOException, MessagingException {
        TestIssueNotifications.assertEquals((String)"messages received", (int)2, (int)mimeMessages.size());
        this.assertEmailBodyContains(mimeMessages.get(0), "henry.ford");
        this.assertEmailBodyContainsLine(mimeMessages.get(0), ".*commented.*");
        this.assertEmailBodyContainsLine(mimeMessages.get(0), ".*COW.*/.*COW-1.*");
        this.assertEmailBodyContains(mimeMessages.get(1), "admin");
        this.assertEmailBodyContainsLine(mimeMessages.get(1), ".*deleted.*");
        this.assertEmailBodyContainsLine(mimeMessages.get(1), ".*COW.*/.*COW-1.*");
    }

    public void testDeleteSubTaskNotification() throws InterruptedException, MessagingException, IOException {
        this.administration.restoreData("TestIssueNotifications.xml");
        this.configureAndStartSmtpServerWithNotify();
        this.configureService();
        String issueId = "COW-3";
        this.navigation.issue().viewIssue(issueId);
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
        this.flushMailQueueAndWait(1);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        TestIssueNotifications.assertEquals((int)1, (int)mimeMessages.length);
        MimeMessage message = mimeMessages[0];
        TestIssueNotifications.assertEquals((String)"admin@example.com", (String)message.getHeader("To")[0]);
        this.assertMailProperties(message, issueId, "[JIRATEST] (COW-3) A calf is a tasty little renet factory");
    }

    public void testDeleteIssueNotification() throws InterruptedException, MessagingException, IOException {
        this.administration.restoreData("TestIssueNotifications.xml");
        this.configureAndStartSmtpServerWithNotify();
        this.configureService();
        String issueId = "COW-1";
        this.navigation.issue().viewIssue(issueId);
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        TestIssueNotifications.assertEquals((int)2, (int)mimeMessages.length);
        ImmutableList expectedList = ImmutableList.of((Object)"admin@example.com", (Object)"Henry.Ford@example.com");
        ImmutableList receivedList = ImmutableList.of((Object)mimeMessages[0].getHeader("To")[0], (Object)mimeMessages[1].getHeader("To")[0]);
        TestIssueNotifications.assertEquals(new HashSet(expectedList), new HashSet(receivedList));
        this.assertMailProperties(mimeMessages[0], issueId, "[JIRATEST] (COW-1) The cow is in the pasture");
        this.assertMailProperties(mimeMessages[1], issueId, "[JIRATEST] (COW-1) The cow is in the pasture");
    }

    public void testDeleteCommentNotification() throws InterruptedException, MessagingException, IOException {
        String commentBody = "This comment will be deleted";
        String emailSubject = "[JIRATEST] (COW-1) The cow is in the pasture";
        UserProfileImpl userProfile = new UserProfileImpl(this.tester, this.getEnvironmentData(), this.navigation);
        this.administration.restoreData("TestIssueNotifications.xml");
        this.configureAndStartSmtpServerWithNotify();
        this.configureService();
        userProfile.changeUserNotificationType(true);
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("footer-comment-button");
        this.tester.setFormElement("comment", "This comment will be deleted");
        this.tester.submit();
        this.tester.assertTextPresent("This comment will be deleted");
        this.tester.clickLink("delete_comment_10000");
        this.tester.submit("Delete");
        this.tester.assertTextNotPresent("This comment will be deleted");
        this.flushMailQueueAndWait(4);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient("admin@example.com");
        TestIssueNotifications.assertEquals((int)2, (int)messagesForAdmin.size());
        List<MimeMessage> messagesForHenry = this.getMessagesForRecipient("Henry.Ford@example.com");
        TestIssueNotifications.assertEquals((int)2, (int)messagesForHenry.size());
        for (MimeMessage message : messagesForHenry) {
            String subject = message.getSubject();
            if (!subject.contains("Updated")) continue;
            this.assertEmailSubjectEquals(message, "[JIRATEST] (COW-1) The cow is in the pasture");
            this.assertEmailBodyContains(message, "Comment: was deleted");
            this.assertEmailBodyContains(message, "(was: This comment will be deleted)");
        }
    }

    public void testEditCommentNotification() throws InterruptedException, MessagingException, IOException {
        String originalComment = "This text will be soon edited";
        String newCommentAdmin = "The administrator just edited this text";
        String newCommentAnon = "An anonymous user just edited this text";
        String emailSubject = "[JIRATEST] (COW-1) The cow is in the pasture";
        this.administration.restoreData("TestIssueNotificationsAnonymous.xml");
        this.configureAndStartSmtpServerWithNotify();
        this.configureService();
        this.editIssue("This text will be soon edited", "henry.ford", "COW-1", "footer-comment-button");
        this.editIssueInForm("admin", "COW-1", "edit_comment_10000", "comment-edit", "The administrator just edited this text");
        this.editIssueInForm(null, "COW-1", "edit_comment_10000", "comment-edit", "An anonymous user just edited this text");
        this.navigation.login("admin");
        this.flushMailQueueAndWait(6);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient("admin@example.com");
        TestIssueNotifications.assertEquals((int)3, (int)messagesForAdmin.size());
        for (MimeMessage message : messagesForAdmin) {
            String subject = message.getSubject();
            if (!subject.contains("Edited")) continue;
            this.assertEmailSubjectEquals(message, "[JIRATEST] (COW-1) The cow is in the pasture");
            String from = message.getFrom()[0].toString();
            if (from.contains("Administrator")) {
                this.assertEmailBodyContains(message, "Administrator edited comment on COW-1 at");
                this.assertEmailBodyContains(message, "The administrator just edited this text");
                this.assertEmailBodyContains(message, "This text will be soon edited");
                this.assertEmailBodyDoesntContain(message, "An anonymous user just edited this text");
                continue;
            }
            this.assertEmailBodyContains(message, "Anonymous edited comment on COW-1 at");
            this.assertEmailBodyContains(message, "An anonymous user just edited this text");
            this.assertEmailBodyContains(message, "The administrator just edited this text");
            this.assertEmailBodyDoesntContain(message, "This text will be soon edited");
        }
    }

    private void configureService() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SERVICES);
        this.navigation.webSudoAuthenticateUsingLastPassword();
        this.tester.setFormElement("name", "");
        this.tester.clickLink("edit_10000");
        this.tester.setFormElement("service.schedule.cronString", "0 0 * * * ?");
        this.tester.submit("Update");
    }

    public void testEditCommentWithNewlineSendsEmailWithCorrectNumberOfNewlines() throws InterruptedException, MessagingException, IOException {
        String substring;
        long brTagsCountBetweenFirstAndLastCommentLine;
        String originalComment = "And now, for something\n\ncompletely different";
        String newCommentAdmin = "And now, for something\r\n\r\ncompletely different - The Larch";
        this.administration.restoreData("TestIssueNotificationsAnonymous.xml");
        this.configureAndStartSmtpServerWithNotify();
        this.configureService();
        this.editIssue("And now, for something\n\ncompletely different", "henry.ford", "COW-1", "footer-comment-button");
        this.editIssueInForm("admin", "COW-1", "edit_comment_10000", "comment-edit", "And now, for something\r\n\r\ncompletely different - The Larch");
        this.navigation.login("admin");
        this.flushMailQueueAndWait(4);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient("admin@example.com");
        TestIssueNotifications.assertEquals((int)2, (int)messagesForAdmin.size());
        Iterator<MimeMessage> iterator = messagesForAdmin.iterator();
        Assert.assertThat((String)"Comment created notification ok", (Object)GreenMailUtil.getBody((Part)((Part)iterator.next())), (Matcher)Matchers.containsString((String)"And now, for something<br /> <br /> completely different"));
        String body = GreenMailUtil.getBody((Part)((Part)iterator.next()));
        int start = body.indexOf("something");
        int end = body.indexOf("Larch");
        if (start == -1 || end == -1 || start >= end) {
            this.logEmail(body);
            TestIssueNotifications.fail((String)"Incorrect notification email received, cannot find edited comment body.");
        }
        if ((brTagsCountBetweenFirstAndLastCommentLine = (long)StringUtils.countMatches((CharSequence)(substring = body.substring(start, end)), (CharSequence)"<br")) != 2L) {
            this.logEmail(body);
            TestIssueNotifications.fail((String)("There should be exactly 2 newlines in email notification, got " + brTagsCountBetweenFirstAndLastCommentLine + " instead"));
        }
    }

    private void logEmail(String body) {
        this.log("Email body start");
        this.log(body);
        this.log("Email body end");
    }

    private String addBRforNewline(String multiLineText) {
        return multiLineText.replaceAll("\n", "<br/>\n");
    }

    private void editIssueInForm(String userName, String issueKey, String linkId, String workingFormName, String newComment) {
        this.navigation.logout();
        if (userName != null) {
            this.navigation.login(userName);
        } else {
            this.tester.gotoPage("/secure/Dashboard.jspa");
        }
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink(linkId);
        this.tester.setWorkingForm(workingFormName);
        this.tester.setFormElement("comment", newComment);
        this.tester.submit("Save");
        this.tester.assertTextPresent(this.addBRforNewline(newComment));
    }

    private void editIssue(String originalComment, String userName, String issueKey, String linkId) {
        this.navigation.logout();
        this.navigation.login(userName);
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink(linkId);
        this.tester.setFormElement("comment", originalComment);
        this.tester.submit();
        this.tester.assertTextPresent(this.addBRforNewline(originalComment));
    }

    public void testAnonymousUser() throws InterruptedException, MessagingException, IOException {
        String originalComment = "a comment from henry";
        this.administration.restoreData("TestIssueNotificationsNoName.xml");
        this.configureAndStartSmtpServerWithNotify();
        this.configureService();
        this.navigation.logout();
        this.tester.gotoPage("/secure/Dashboard.jspa");
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("footer-comment-button");
        this.tester.setFormElement("comment", "a comment from henry");
        this.tester.submit();
        this.tester.assertTextPresent("a comment from henry");
        this.navigation.logout();
        this.navigation.login("henry.ford");
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("footer-comment-button");
        this.tester.setFormElement("comment", "a comment from henry");
        this.tester.submit();
        this.tester.assertTextPresent("a comment from henry");
        this.navigation.login("admin");
        this.flushMailQueueAndWait(2);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient("admin@example.com");
        TestIssueNotifications.assertEquals((int)2, (int)messagesForAdmin.size());
        String emailBody = GreenMailUtil.getBody((Part)((Part)messagesForAdmin.get(0)));
        if (emailBody.contains("Anonymous")) {
            this.assertEmailBodyContains(messagesForAdmin.get(1), "henry.ford");
            this.assertEmailBodyContains(messagesForAdmin.get(1), "commented");
            this.assertEmailBodyContains(messagesForAdmin.get(1), "COW-1");
        } else {
            this.assertEmailBodyContains(messagesForAdmin.get(0), "henry.ford");
            this.assertEmailBodyContains(messagesForAdmin.get(0), "commented");
            this.assertEmailBodyContains(messagesForAdmin.get(0), "COW-1");
            this.assertEmailBodyContains(messagesForAdmin.get(1), "Anonymous");
            this.assertEmailBodyContains(messagesForAdmin.get(1), "commented");
            this.assertEmailBodyContains(messagesForAdmin.get(1), "COW-1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssignIssueNotificationNoCurrentAssignee() throws Exception {
        this.administration.restoreData("TestIssueNotificationsNotCurrentAssignee.xml");
        this.configureAndStartSmtpServerWithNotify();
        this.configureService();
        try {
            this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
            this.navigation.issue().assignIssue("COw-2", "this is a comment", "henry.ford");
        }
        finally {
            this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
        }
        this.flushMailQueueAndWait(0);
        List<MimeMessage> messagesForHank = this.getMessagesForRecipient("Henry.Ford@example.com");
        TestIssueNotifications.assertEquals((int)0, (int)messagesForHank.size());
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient("admin@example.com");
        TestIssueNotifications.assertEquals((int)0, (int)messagesForAdmin.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssignIssueNotificationCurrentAndPreviousAssignee() throws Exception {
        this.administration.restoreData("TestIssueNotificationsCurrentAssignee.xml");
        this.configureAndStartSmtpServerWithNotify();
        this.configureService();
        try {
            this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
            this.navigation.issue().assignIssue("COw-2", "this is a comment", "henry.ford");
        }
        finally {
            this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
        }
        this.flushMailQueueAndWait(2);
        List<MimeMessage> messagesForHank = this.getMessagesForRecipient("Henry.Ford@example.com");
        TestIssueNotifications.assertEquals((int)1, (int)messagesForHank.size());
        MimeMessage message = messagesForHank.get(0);
        this.assertEmailBodyContains(message, "assigned");
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient("admin@example.com");
        TestIssueNotifications.assertEquals((int)1, (int)messagesForAdmin.size());
        message = messagesForAdmin.get(0);
        this.assertEmailBodyContains(message, "assigned");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssignIssueNotificationUnassigned() throws Exception {
        this.administration.restoreData("TestIssueNotificationsCurrentAssignee.xml");
        this.configureAndStartSmtpServerWithNotify();
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
        try {
            this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
            this.navigation.issue().unassignIssue("COW-2", "this is a comment");
        }
        finally {
            this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
        }
        this.flushMailQueueAndWait(1);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient("admin@example.com");
        TestIssueNotifications.assertEquals((int)1, (int)messagesForAdmin.size());
        MimeMessage message = messagesForAdmin.get(0);
        this.assertEmailBodyContains(message, "assigned");
    }

    public void testResolutionDateInEmail() throws InterruptedException, MessagingException, IOException {
        this.administration.restoreData("TestIssueNotifications.xml");
        this.configureAndStartSmtpServerWithNotify();
        this.configureService();
        this.tester.clickLink("view_profile");
        this.tester.clickLink("edit_prefs_lnk");
        this.tester.selectOption("userNotificationsMimeType", "HTML");
        this.tester.submit();
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("footer-comment-button");
        this.tester.setWorkingForm("comment-add");
        this.tester.setFormElement("comment", "Test comment");
        this.tester.submit("Add");
        this.tester.clickLink("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.flushMailQueueAndWait(2);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient("admin@example.com");
        TestIssueNotifications.assertEquals((int)2, (int)messagesForAdmin.size());
        MimeMessage message = messagesForAdmin.get(0);
        this.assertEmailBodyDoesntContain(message, "Resolved:");
        this.assertEmailBodyContains(message, "commented");
        MimeMessage resolvedMessage = messagesForAdmin.get(1);
        this.assertEmailBodyContains(resolvedMessage, "Resolved");
    }

    public void testMailOrdering() throws Exception {
        String originalComment = "This text will be soon edited";
        String newCommentAdmin = "The administrator just edited this text";
        String newCommentAnon = "An anonymous user just edited this text";
        this.administration.restoreData("TestIssueNotificationsAnonymous.xml");
        this.configureAndStartSmtpServerWithNotify();
        this.configureService();
        this.editIssue("This text will be soon edited", "henry.ford", "COW-1", "footer-comment-button");
        this.editIssueInForm("admin", "COW-1", "edit_comment_10000", "comment-edit", "The administrator just edited this text");
        this.editIssueInForm(null, "COW-1", "edit_comment_10000", "comment-edit", "An anonymous user just edited this text");
        this.navigation.login("admin");
        this.flushMailQueueAndWait(6);
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        TestIssueNotifications.assertEquals((int)6, (int)messages.length);
        Date firstDate = messages[0].getSentDate();
        boolean notInOrder = false;
        for (MimeMessage message : messages) {
            notInOrder = message.getSentDate().before(firstDate);
        }
        TestIssueNotifications.assertFalse((boolean)notInOrder);
    }

    private void assertMailProperties(MimeMessage message, String issueId, String subject) throws MessagingException, IOException {
        TestIssueNotifications.assertEquals((String)subject, (String)message.getHeader("Subject")[0]);
        TestIssueNotifications.assertEquals((String)"\"admin (JIRA)\" <jiratest@atlassian.com>", (String)message.getHeader("From")[0]);
        this.assertEmailBodyContains(message, "admin");
        this.assertEmailBodyContainsLine(message, ".*deleted.*");
        this.assertEmailBodyContainsLine(message, ".*" + issueId + ".*");
    }
}

