/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import java.util.List;
import javax.mail.internet.MimeMessage;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
public class TestIssueEmailSubject
extends EmailFuncTestCase {
    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssueNotificationsCurrentAssignee.xml");
        this.configureAndStartSmtpServerWithNotify();
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
    }

    private void assertEmailSubject(Runnable setup, String expectedSubjectHeading) throws Exception {
        setup.run();
        this.flushMailQueueAndWait(1);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient("admin@example.com");
        TestIssueEmailSubject.assertEquals((int)1, (int)messagesForAdmin.size());
        MimeMessage message = messagesForAdmin.get(0);
        this.assertEmailSubjectEquals(message, expectedSubjectHeading);
    }

    public void testCreateIssue() throws Exception {
        this.assertEmailSubject(new Runnable(){

            @Override
            public void run() {
                TestIssueEmailSubject.this.navigation.issue().createIssue("COW", null, "New issue");
            }
        }, "[JIRATEST] (COW-4) New issue");
    }

    public void testIssueUpdated() throws Exception {
        this.assertEmailSubject(new Runnable(){

            @Override
            public void run() {
                TestIssueEmailSubject.this.navigation.issue().setDescription("COW-2", "Updated text");
            }
        }, "[JIRATEST] (COW-2) This cow has a calf");
    }

    public void testAssignIssue() throws Exception {
        this.assertEmailSubject(new Runnable(){

            @Override
            public void run() {
                TestIssueEmailSubject.this.navigation.issue().unassignIssue("COW-2", "this is a comment");
            }
        }, "[JIRATEST] (COW-2) This cow has a calf");
    }

    public void testIssueResolved() throws Exception {
        this.assertEmailSubject(new Runnable(){

            @Override
            public void run() {
                TestIssueEmailSubject.this.navigation.issue().resolveIssue("COW-2", "Fixed", "Yay!");
            }
        }, "[JIRATEST] (COW-2) This cow has a calf");
    }

    public void testIssueCommented() throws Exception {
        this.assertEmailSubject(new Runnable(){

            @Override
            public void run() {
                TestIssueEmailSubject.this.navigation.issue().addComment("COW-2", "jaisodf", null);
            }
        }, "[JIRATEST] (COW-2) This cow has a calf");
    }

    public void testIssueDeleted() throws Exception {
        this.assertEmailSubject(new Runnable(){

            @Override
            public void run() {
                TestIssueEmailSubject.this.navigation.issue().deleteIssue("COW-3");
            }
        }, "[JIRATEST] (COW-3) A calf is a tasty little renet factory");
    }
}

