/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadata;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadataParticipant;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.TransitionsClient;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.util.List;
import javax.annotation.Nullable;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.junit.Before;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
public class TestHistoryMetadataNotifications
extends EmailFuncTestCase {
    private IssueClient issueClient;
    private TransitionsClient transitionsClient;
    private final HistoryMetadata metadataWIthRawDescription = this.createMetdata().emailDescriptionKey("nonexistant.description.key.xxxxx").emailDescription("custom description").build();
    private final HistoryMetadataParticipant.HistoryMetadataParticipantBuilder actor = HistoryMetadataParticipant.builder((String)"<b>actor</b>", (String)"actorType").displayName("<b>Bitbucket</b> User").url("http://bitbucket.org");
    private final HistoryMetadata metadataWithActor = this.createMetdata().actor(this.actor.build()).build();
    private final HistoryMetadata metadataWithActorKey = this.createMetdata().actor(this.actor.displayNameKey("reference.changehistory.customemaildescription.cause").build()).cause(HistoryMetadataParticipant.builder((String)"review", (String)"review").build()).build();

    @Override
    @Before
    public void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
        this.transitionsClient = new TransitionsClient((JIRAEnvironmentData)this.environmentData);
        this.administration.restoreData("TestIssueNotificationsCurrentAssignee.xml");
        this.configureAndStartSmtpServerWithNotify();
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
        this.administration.generalConfiguration().setBaseUrl(this.environmentData.getBaseUrl().toString());
    }

    public void testUpdateWithCustomDescription() throws Exception {
        this.updateSummary("COW-1", "custom description", this.metadataWIthRawDescription);
        this.updateSummary("COW-2", "custom description key", this.createMetdata().build());
        this.flushMailQueueAndWait(3);
        List<MimeMessage> emails = this.getMessagesForRecipient("admin@example.com");
        this.assertEmailBodyContainsLine(emails.get(0), ".*Administrator.*updated.*an issue.*custom description");
        this.assertEmailBodyContainsLine(emails.get(1), ".*Automated transition updated an issue - triggered by.*Administrator.*RemoteSystem.*pull request #1");
    }

    public void testUpdateWithCustomDescriptionInTextFormat() throws Exception {
        this.backdoor.userProfile().changeUserNotificationType("admin", "text");
        this.updateSummary("COW-1", "custom description", this.metadataWIthRawDescription);
        this.updateSummary("COW-2", "custom description key", this.createMetdata().build());
        this.updateSummary("COW-3", "plain update", null);
        this.flushMailQueueAndWait(4);
        List<MimeMessage> emails = this.getMessagesForRecipient("admin@example.com");
        this.assertEmailBodyContainsLine(emails.get(0), "Administrator updated COW-1: custom description");
        this.assertEmailBodyContainsLine(emails.get(1), "Automated transition updated an issue - triggered by Administrator's RemoteSystem pull request #1");
        this.assertEmailBodyContainsLine(emails.get(2), "Administrator updated COW-3:");
    }

    public void testUpdateWithCustomAvatar() throws Exception {
        HistoryMetadata withGeneratorAvatar = this.createMetdata().generator(HistoryMetadataParticipant.builder((String)"generatorAvatar", (String)"generator").avatarUrl("http://localhost/genavatar").build()).build();
        HistoryMetadata withActorAvatar = this.createMetdata().actor(HistoryMetadataParticipant.builder((String)"actorAvatar", (String)"actor").avatarUrl("http://localhost/actoravatar").build()).build();
        HistoryMetadata withRelativeAvatar = this.createMetdata().generator(HistoryMetadataParticipant.builder((String)"relativeAvatar", (String)"generator").avatarUrl("/secure/projectavatar?pid=10000&avatarId=10011").build()).build();
        this.updateSummary("COW-1", "generatorAvatar", withGeneratorAvatar);
        this.updateSummary("COW-2", "actorAvatar", withActorAvatar);
        this.updateSummary("COW-3", "relativeAvatar", withRelativeAvatar);
        this.flushMailQueueAndWait(4);
        List<MimeMessage> emails = this.getMessagesForRecipient("admin@example.com");
        this.assertEmailBodyContainsLine(emails.get(0), ".*<img id=\"header-avatar-image\" class=\"image_fix\" src=\"http://localhost/genavatar\".*");
        this.assertEmailBodyContainsLine(emails.get(1), ".*<img id=\"header-avatar-image\" class=\"image_fix\" src=\"http://localhost/actoravatar\".*");
        this.assertEmailBodyContainsLine(emails.get(2), ".*<img id=\"header-avatar-image\" class=\"image_fix\" src=\"cid:jira-generated-image-static-projectavatar.*");
        this.assertEmailBodyContainsLine(emails.get(2), "Content-ID: <jira-generated-image-static-projectavatar.*");
        this.assertEmailHasNumberOfParts(emails.get(2), 5);
    }

    public void testTransitionWithCustomActor() throws Exception {
        this.transitionsClient = (TransitionsClient)this.transitionsClient.anonymous();
        this.transition("COW-1", this.metadataWithActor, 4);
        this.transition("COW-2", this.metadataWithActorKey, 4);
        this.flushMailQueueAndWait(3);
        List<MimeMessage> emails = this.getMessagesForRecipient("admin@example.com");
        this.assertEmailBodyContainsLine(emails.get(0), ".*Automated transition updated an issue - triggered by <a href=\"http://bitbucket.org\".*&lt;b&gt;Bitbucket&lt;/b&gt; User</a>'s RemoteSystem pull request #1.*", "Change By:", ".*<a href=\"http://bitbucket.org\".*&lt;b&gt;Bitbucket&lt;/b&gt; User</a>.*");
        this.assertEmailBodyContainsLine(emails.get(1), ".*Automated transition updated an issue - triggered by <a href=\"http://bitbucket.org\".*pull request &lt;b&gt;actor&lt;/b&gt;</a>'s RemoteSystem review.*", "Change By:", ".*a href=\"http://bitbucket.org\".*pull request &lt;b&gt;actor&lt;/b&gt;</a>.*");
    }

    public void testTransitionWithCustomActorTextFormat() throws Exception {
        this.backdoor.userProfile().changeUserNotificationType("admin", "text");
        this.transitionsClient = (TransitionsClient)this.transitionsClient.anonymous();
        this.transition("COW-1", this.metadataWithActor, 4);
        this.transition("COW-2", this.metadataWithActorKey, 4);
        this.transition("COW-1", this.metadataWithActor, 301);
        this.transition("COW-1", this.metadataWithActor, 5);
        this.transition("COW-1", this.metadataWithActor, 3);
        this.transition("COW-1", this.metadataWithActor, 2);
        this.transitionsClient = (TransitionsClient)this.transitionsClient.loginAs("admin");
        this.transition("COW-3", this.metadataWithActor, 2);
        this.flushMailQueueAndWait(12);
        List<MimeMessage> emails = this.getMessagesForRecipient("admin@example.com");
        this.assertEmailBodyContainsLine(emails.get(0), "Automated transition updated an issue - triggered by Bitbucket\\s+User's RemoteSystem pull request #1");
        this.assertEmailBodyContainsLine(emails.get(1), "Automated transition updated an issue - triggered by pull request\\s+actor's RemoteSystem review");
        this.assertEmailBodyContainsLine(emails.get(2), "Automated transition updated an issue - triggered by Bitbucket\\s+User's RemoteSystem pull request #1");
        this.assertEmailBodyContainsLine(emails.get(3), "Automated transition updated an issue - triggered by Bitbucket\\s+User's RemoteSystem pull request #1");
        this.assertEmailBodyContainsLine(emails.get(4), "Automated transition updated an issue - triggered by Bitbucket\\s+User's RemoteSystem pull request #1");
        this.assertEmailBodyContainsLine(emails.get(5), "Automated transition updated an issue - triggered by Bitbucket\\s+User's RemoteSystem pull request #1");
        this.assertEmailBodyContainsLine(emails.get(6), "Automated transition updated an issue - triggered by Administrator's RemoteSystem pull request #1");
    }

    public void testTransitionIssueTextFormat() throws Exception {
        this.backdoor.userProfile().changeUserNotificationType("admin", "text");
        this.transition("COW-1", null, 4);
        this.transition("COW-1", null, 301);
        this.transition("COW-1", null, 5);
        this.transition("COW-1", null, 3);
        this.transition("COW-1", null, 2);
        this.flushMailQueueAndWait(10);
        List<MimeMessage> emails = this.getMessagesForRecipient("admin@example.com");
        System.out.println(Iterables.toString((Iterable)Iterables.transform(emails, (Function)new Function<MimeMessage, String>(){

            public String apply(@Nullable MimeMessage email) {
                return GreenMailUtil.getBody((Part)email).trim().replaceAll("\\n", "\\\\n").replaceAll("\\r", "\\\\r") + "\n";
            }
        })));
        this.assertEmailBodyContainsLine(emails.get(0), "Work on COW-1 started by Administrator.");
        this.assertEmailBodyContainsLine(emails.get(1), "Work on COW-1 stopped by Administrator.");
        this.assertEmailBodyContainsLine(emails.get(2), "Administrator resolved COW-1.");
        this.assertEmailBodyContainsLine(emails.get(3), "Administrator reopened COW-1.");
        this.assertEmailBodyContainsLine(emails.get(4), "Administrator closed COW-1.");
    }

    private void transition(String issueKey, HistoryMetadata metadataWithActor, int transitionId) {
        this.transitionsClient.postResponse(issueKey, new IssueUpdateRequest().transition(ResourceRef.withId((String)Integer.valueOf(transitionId).toString())).historyMetadata(metadataWithActor));
    }

    private HistoryMetadata.HistoryMetadataBuilder createMetdata() {
        return HistoryMetadata.builder((String)"test").cause(HistoryMetadataParticipant.builder((String)"#1", (String)"causetype").displayNameKey("reference.changehistory.customemaildescription.cause").build()).generator(HistoryMetadataParticipant.builder((String)"RemoteSystem", (String)"systemtype").build()).emailDescriptionKey("reference.changehistory.customemaildescription");
    }

    private void updateSummary(String issueKey, String summary, HistoryMetadata metadata) {
        this.issueClient.update(issueKey, new IssueUpdateRequest().fields(new IssueFields().summary(summary)).historyMetadata(metadata));
    }
}

