/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rules.RestRule;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import com.atlassian.jira.webtests.util.issue.IssueInlineEdit;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
public class TestCurrentAssigneeNotifications
extends EmailFuncTestCase {
    @Override
    public void setUpTest() {
        super.setUpTest();
        this.restoreDataAndConfigureSmtp("TestCurrentAssigneeNotifications.xml");
        this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
    }

    @Override
    public void tearDownTest() {
        this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
        super.tearDownTest();
    }

    public void testAssignIssueSendsEmailToNewAndOldAssignees() throws Exception {
        this.navigation.issue().assignIssue("HSP-1", "This has been re-assigned", "homer");
        this.assertHomerAndBartsEmails(1, 1);
    }

    public void testAssignIssueTriggersIssueAssignedEvent() throws Exception {
        this.navigation.issue().assignIssue("HSP-1", "This has been re-assigned", "homer");
        this.assertEmailSentToUserListeningOnlyToIssueAssignedEvents();
    }

    public void testEditIssueChangingAssigneeSendsEmailToNewAndOldAssignees() throws Exception {
        this.editIssueAndChangeAssignee("HSP-1", "This has been re-assigned", "homer");
        this.assertHomerAndBartsEmails(1, 1);
    }

    public void testEditIssueChangingAssigneeTriggersIssueAssignedEvent() throws Exception {
        this.editIssueAndChangeAssignee("HSP-1", "This has been re-assigned", "homer");
        this.assertEmailSentToUserListeningOnlyToIssueAssignedEvents();
    }

    public void testTransitionIssueChangingAssigneeSendsEmailToNewAndOldAssignees() throws Exception {
        this.workflowIssueAndChangeAssignee("HSP-1", "homer");
        this.assertHomerAndBartsEmails(1, 1);
    }

    public void testTransitionIssueChangingAssigneeTriggersIssueAssignedEvent() throws Exception {
        this.workflowIssueAndChangeAssignee("HSP-1", "homer");
        this.assertEmailSentToUserListeningOnlyToIssueAssignedEvents();
    }

    public void testBulkEditIssueChangingAssigneeSendsEmailToNewAndOldAssignees() throws Exception {
        this.bulkEditHSP_1("homer");
        this.assertHomerAndBartsEmails(1, 1);
    }

    public void testBulkEditIssueChangingAssigneeTriggersIssueAssignedEvent() throws Exception {
        this.bulkEditHSP_1("homer");
        this.assertEmailSentToUserListeningOnlyToIssueAssignedEvents();
    }

    public void testBulkTransitionIssueChangingAssigneeSendsEmailToNewAndOldAssignees() throws Exception {
        this.bulkTransitionHSP_1("homer");
        this.assertHomerAndBartsEmails(1, 1);
    }

    public void testBulkTransitionIssueChangingAssigneeTriggersIssueAssignedEvent() throws Exception {
        this.bulkTransitionHSP_1("homer");
        this.assertEmailSentToUserListeningOnlyToIssueAssignedEvents();
    }

    public void testInlineEditingAssigneeSendsEmailToNewAndOldAssignees() throws Exception {
        this.inlineAssign("HSP-1", "10000", "homer");
        this.assertHomerAndBartsEmails(1, 1);
    }

    public void testInlineEditingAssigneeTriggersIssueAssignedEvent() throws Exception {
        this.inlineAssign("HSP-1", "10000", "homer");
        this.assertEmailSentToUserListeningOnlyToIssueAssignedEvents();
    }

    private void inlineAssign(String issueKey, String issueId, String newAssignee) throws Exception {
        this.navigation.issue().gotoIssue(issueKey);
        IssueInlineEdit inlineEdit = new IssueInlineEdit(this.locator, this.tester, new RestRule(this));
        inlineEdit.inlineEditField(issueId, "assignee", newAssignee);
    }

    private void bulkEditHSP_1(String newAssigneeName) {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.tester.checkCheckbox("actions", "assignee");
        this.tester.selectOption("assignee", newAssigneeName);
        this.tester.checkCheckbox("sendBulkNotification", "true");
        this.tester.submit("Next");
        this.tester.submit("Confirm");
        this.waitAndReloadBulkOperationProgressPage();
    }

    private void bulkTransitionHSP_1(String newAssigneeName) {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.tester.submit("Next");
        this.tester.checkCheckbox("wftransition", "jira_5_5");
        this.tester.submit("Next");
        this.tester.checkCheckbox("actions", "resolution");
        this.tester.selectOption("resolution", "Won't Fix");
        this.tester.checkCheckbox("actions", "assignee");
        this.tester.selectOption("assignee", newAssigneeName);
        this.tester.checkCheckbox("sendBulkNotification", "true");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.waitAndReloadBulkOperationProgressPage();
    }

    private void editIssueAndChangeAssignee(String issueKey, String commentStr, String newAssigneeName) {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.selectOption("assignee", newAssigneeName);
        this.tester.setFormElement("comment", commentStr);
        this.tester.submit("Update");
    }

    private void workflowIssueAndChangeAssignee(String issueKey, String newAssigneeName) {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.selectOption("resolution", "Won't Fix");
        this.tester.selectOption("assignee", newAssigneeName);
        this.tester.submit("Transition");
    }

    private void assertHomerAndBartsEmails(int expectedHomerEmailCount, int expectedBartEmailCount) throws MessagingException, InterruptedException, IOException {
        this.flushMailQueueAndWaitForRecipients(5000, "homer@localhost", "bart@localhost");
        this.assertHomerWasAssignedEmails("homer@localhost", expectedHomerEmailCount);
        this.assertHomerWasAssignedEmails("bart@localhost", expectedBartEmailCount);
    }

    private void assertHomerWasAssignedEmails(String emailAddress, int expectedEmailCount) throws MessagingException, IOException {
        List<MimeMessage> messagesForRecipient = this.getMessagesForRecipient(emailAddress);
        TestCurrentAssigneeNotifications.assertEquals((int)expectedEmailCount, (int)messagesForRecipient.size());
        Iterator<MimeMessage> i$ = messagesForRecipient.iterator();
        while (i$.hasNext()) {
            MimeMessage msg;
            MimeMessage message = msg = i$.next();
            String subject = message.getSubject();
            TestCurrentAssigneeNotifications.assertTrue((boolean)subject.contains("HSP-1"));
            this.assertEmailBodyContains(message, "HSP-1");
            this.assertEmailBodyContains(message, "Assignee:");
            this.assertEmailBodyContainsLine(message, ".*diffremovedchars.*bart.*");
            this.assertEmailBodyContainsLine(message, ".*diffaddedchars.*homer.*");
        }
    }

    private void restoreDataAndConfigureSmtp(String fileName) {
        this.administration.restoreData(fileName);
        this.configureAndStartSmtpServer();
    }

    private void assertEmailSentToUserListeningOnlyToIssueAssignedEvents() throws Exception {
        this.flushMailQueueAndWaitForRecipients(5000, "test@test.com");
        List<MimeMessage> messagesForRecipient = this.getMessagesForRecipient("test@test.com");
        Assert.assertThat((Object)messagesForRecipient.size(), (Matcher)Matchers.is((Object)1));
    }
}

