/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
public class TestBulkHeaders
extends EmailFuncTestCase {
    public void testBulkHeadersPresent() throws InterruptedException, MessagingException {
        this.administration.restoreData("TestIssueNotifications.xml");
        this.configureAndStartSmtpServerWithNotify();
        String issueId = "COW-1";
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        TestBulkHeaders.assertEquals((int)2, (int)mimeMessages.length);
        for (MimeMessage msg : mimeMessages) {
            String[] prec = msg.getHeader("Precedence");
            String[] auto = msg.getHeader("Auto-Submitted");
            TestBulkHeaders.assertEquals((String)"bulk", (String)prec[0]);
            TestBulkHeaders.assertEquals((String)"auto-generated", (String)auto[0]);
        }
    }

    public void testBulkHeadersNotPresent() throws InterruptedException, MessagingException {
        this.administration.restoreData("TestStripBulk.xml");
        this.configureAndStartSmtpServerWithNotify();
        String issueId = "MKY-1";
        this.navigation.issue().viewIssue("MKY-1");
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
        this.flushMailQueueAndWait(3);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        TestBulkHeaders.assertEquals((int)3, (int)mimeMessages.length);
        for (MimeMessage msg : mimeMessages) {
            TestBulkHeaders.assertNull((Object)msg.getHeader("Precedence"));
            TestBulkHeaders.assertNull((Object)msg.getHeader("Auto-Submitted"));
        }
    }
}

