/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;

public class ShareClient
extends RestApiClient {
    private final com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData;

    public ShareClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
        super((JIRAEnvironmentData)environmentData);
        this.environmentData = environmentData;
    }

    ShareClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData, String version) {
        super((JIRAEnvironmentData)environmentData, version);
        this.environmentData = environmentData;
    }

    public Response shareIssue(String issueKey, Set<String> usernames, @Nullable Set<String> emails, String message) {
        ShareBean bean = new ShareBean(usernames, emails, message, null);
        return this.postToShareResource("issue/" + issueKey, bean);
    }

    public Response shareSavedSearch(String searchRequestId, Set<String> usernames, @Nullable Set<String> emails, String message) {
        ShareBean bean = new ShareBean(usernames, emails, message, null);
        return this.postToShareResource("filter/" + searchRequestId, bean);
    }

    public Response shareSearchQuery(String jql, Set<String> usernames, @Nullable Set<String> emails, String message) {
        ShareBean bean = new ShareBean(usernames, emails, message, jql);
        return this.postToShareResource("search", bean);
    }

    private Response postToShareResource(final String path, final ShareBean shareBean) {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                WebResource shareResource = ShareClient.this.getShareResource().path(path);
                return (ClientResponse)shareResource.type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)shareBean);
            }
        });
    }

    private WebResource getShareResource() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("share").path("1.0");
    }

    static class ShareBean {
        public Set<String> usernames;
        public Set<String> emails;
        public String message;
        public String jql;

        public ShareBean(Set<String> usernames, Set<String> emails, String message, String jql) {
            this.usernames = usernames;
            this.emails = emails;
            this.message = message;
            this.jql = jql;
        }
    }
}

