/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.database;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.DATABASE})
public class TestDatabaseSystemTimeReader
extends RestFuncTest {
    private static final String REST_DBTIME_RESOURCE = "/rest/func-test/latest/databaseSystemTime";
    private static final int RESPONSE_OK = 200;

    public void testThatDatabaseSystemTimeIncreasesOverTime() throws Exception {
        long time1 = this.readDatabaseTime();
        Thread.sleep(1000L);
        long time2 = this.readDatabaseTime();
        TestDatabaseSystemTimeReader.assertTrue((String)("Database system time is not increasing (" + time1 + ", " + time2 + ")."), (time1 < time2 ? 1 : 0) != 0);
    }

    private long readDatabaseTime() throws Exception {
        WebResponse response = this.GET(REST_DBTIME_RESOURCE);
        this.assertResponseOk(response);
        return Long.parseLong(response.getText());
    }

    private void assertResponseOk(WebResponse response) {
        String failMessage = "REST error response: " + response.getResponseMessage();
        try {
            String responseMessage = response.getText();
            failMessage = failMessage + " - " + responseMessage;
        }
        catch (IOException e) {
            failMessage = failMessage + " (" + IOException.class.getSimpleName() + " getting response: " + e.toString() + ")";
        }
        TestDatabaseSystemTimeReader.assertEquals((String)failMessage, (int)200, (int)response.getResponseCode());
    }
}

