/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.database;

import com.atlassian.jira.functest.framework.backdoor.EntityEngineControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.DATABASE})
public class TestDatabaseLargeInQueries
extends RestFuncTest {
    private EnvironmentUtils environmentUtils;

    @Override
    protected void setUpTest() {
        this.environmentUtils = new EnvironmentUtils(this.getTester(), this.getEnvironmentData());
        this.administration.restoreBlankInstance();
    }

    public void testLargeInQueryNumeric() {
        if (this.environmentUtils.isOracle()) {
            System.err.println("Warning: this test is currently ignored in Oracle, awaiting environment fixes.");
            return;
        }
        ArrayList<Long> values = new ArrayList<Long>();
        for (long value = 8000L; value < 10001L; ++value) {
            values.add(value);
        }
        List<Map<String, String>> results = this.backdoor.entityEngine().findByValueList("Project", "id", values, (List<String>)ImmutableList.of((Object)"id", (Object)"name"), EntityEngineControl.ValueType.NUMBER);
        TestDatabaseLargeInQueries.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"id", (Object)10000, (Object)"name", (Object)"homosapien")), results);
    }

    public void testLargeInQueryString() {
        ArrayList<String> values = new ArrayList<String>();
        values.add("homosapien");
        for (int i = 0; i < 2050; ++i) {
            values.add(String.valueOf(i));
        }
        List<Map<String, String>> results = this.backdoor.entityEngine().findByValueList("Project", "name", values, (List<String>)ImmutableList.of((Object)"id", (Object)"name"), EntityEngineControl.ValueType.STRING);
        TestDatabaseLargeInQueries.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"id", (Object)10000, (Object)"name", (Object)"homosapien")), results);
    }

    public void testLargeNumberOfParametersWithSmallerInFragments() {
        ArrayList<String> values = new ArrayList<String>();
        values.add("homosapien");
        for (int i = 0; i < 1200; ++i) {
            values.add(String.valueOf(i));
        }
        List<Map<String, String>> results = this.backdoor.entityEngine().findByValueList2Fields("Project", "lead", "name", values, (List<String>)ImmutableList.of((Object)"id", (Object)"name"), EntityEngineControl.ValueType.STRING);
        TestDatabaseLargeInQueries.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"id", (Object)10000, (Object)"name", (Object)"homosapien")), results);
    }
}

