/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.database;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.parser.SystemInfoParser;
import com.atlassian.jira.functest.framework.parser.SystemInfoParserImpl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

@WebTest(value={Category.FUNC_TEST, Category.DATABASE})
public class TestDatabaseCollationReader
extends FuncTestCase {
    private SystemInfoParser.SystemInfo systemInfo;

    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
        this.systemInfo = new SystemInfoParserImpl(this.getTester(), this.navigation).getSystemInfo();
    }

    public void testDatabaseCollationReadSuccessfully() {
        if (this.getDatabaseType().startsWith("hsql")) {
            return;
        }
        String databaseCollation = this.systemInfo.getProperty("Database collation");
        MatcherAssert.assertThat((String)("Could not read collation for database type " + this.getDatabaseType()), (Object)databaseCollation, (Matcher)Matchers.not((Matcher)Matchers.isOneOf((Object[])new String[]{null, "", "null", "Unknown"})));
    }

    private String getDatabaseType() {
        return this.systemInfo.getDatabaseType();
    }
}

