/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebImage;
import com.meterware.httpunit.WebTable;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS, Category.USERS_AND_GROUPS, Category.FIELDS, Category.SCHEMES})
public class TestSingleLevelGroupByReport
extends FuncTestCase {
    public void testRunReportLoggedIn() {
        this.administration.restoreData("TestFullAnonymousPermissions.xml");
        this.navigation.login("admin", "admin");
        this.runReport();
    }

    public void testRunReportAnonymously() {
        this.administration.restoreData("TestFullAnonymousPermissions.xml");
        this.navigation.logout();
        this.runReport();
    }

    public void runReport() {
        this.navigation.runReport(10001L, "com.atlassian.jira.plugin.system.reports:singlelevelgroupby");
        this.text.assertTextPresent("Select a filter to display");
        this.text.assertTextPresent("Select a field to group by");
        this.tester.setFormElement("filterid", "10000");
        this.tester.submit("Next");
        this.text.assertTextPresent("Single Level Group By Report");
        this.text.assertTextPresent("MKY-2");
        this.text.assertTextPresent("MKY-1");
        this.text.assertTextPresent("0 of 2 issues have been resolved");
        Node headerLink = new CssLocator(this.tester, ".stat-heading h3 a").getNode();
        TestSingleLevelGroupByReport.assertEquals((String)"header cell should display user name", (String)"Administrator", (String)headerLink.getNodeValue());
        String link = headerLink.getAttributes().getNamedItem("href").getNodeValue();
        TestSingleLevelGroupByReport.assertTrue((String)"header cell should contain a link to a filtered results page", (boolean)link.contains("jqlQuery=project+%3D+10001+AND+issuetype+%3D+1+AND+assignee+%3D+admin+ORDER+BY+key+DESC"));
    }

    public void testVersionIsEncoded() {
        this.administration.restoreData("TestVersionAndComponentsWithHTMLNames.xml");
        this.gotoSingleLevelGroupByReportAllFixForVersions();
        this.text.assertTextPresent("&quot;version&lt;input &gt;");
        this.text.assertTextNotPresent("\"version<input >");
        Node headerElement = new CssLocator(this.tester, ".stat-heading h3").getNodes()[0];
        TestSingleLevelGroupByReport.assertTrue((String)"a span element with the release icon should be present", (new CssLocator(headerElement, "span.aui-icon").getNodes().length == 1 ? 1 : 0) != 0);
        Node headerLink = new CssLocator(headerElement, "a").getNode();
        TestSingleLevelGroupByReport.assertEquals((String)"header cell should display correct version name", (String)"New Version 1", (String)headerLink.getNodeValue());
        String link = headerLink.getAttributes().getNamedItem("href").getNodeValue();
        TestSingleLevelGroupByReport.assertTrue((String)"header cell should contain a link to a filtered results page", (boolean)link.contains("jqlQuery=project+%3D+HSP+AND+fixVersion+%3D+%22New+Version+1%22+ORDER+BY+key+DESC"));
    }

    public void testFieldVisibility() {
        this.administration.restoreData("TestVersionAndComponentsWithHTMLNames.xml");
        this.gotoSingleLevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(true, true);
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Priority");
        this.gotoSingleLevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(false, true);
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Resolution");
        this.gotoSingleLevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(false, false);
        this.administration.fieldConfigurations().defaultFieldConfiguration().showFields("Priority");
        this.gotoSingleLevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(true, false);
        this.administration.fieldConfigurations().defaultFieldConfiguration().showFields("Resolution");
        this.gotoSingleLevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(true, true);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Improvement");
        this.tester.setFormElement("summary", "This is a test to see if field is shown");
        this.tester.submit();
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
        this.tester.clickLink("add-field-configuration");
        this.tester.setFormElement("fieldLayoutName", "Many Hidden Fields");
        this.tester.submit("Add");
        this.tester.clickLink("hide_4");
        this.tester.clickLink("hide_8");
        this.tester.clickLink("hide_13");
        this.tester.clickLink("hide_15");
        this.tester.clickLink("issue_fields");
        this.tester.clickLink("add-field-configuration-scheme");
        this.tester.setFormElement("fieldLayoutSchemeName", "All Fields Hidden Scheme");
        this.tester.submit("Add");
        this.tester.clickLink("add-issue-type-field-configuration-association");
        this.tester.selectOption("issueTypeId", "Bug");
        this.tester.selectOption("fieldConfigurationId", "Many Hidden Fields");
        this.tester.submit("Add");
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.tester.gotoPage("/secure/admin/SelectFieldLayoutScheme!default.jspa?projectId=" + projectId);
        this.tester.selectOption("schemeId", "All Fields Hidden Scheme");
        this.tester.submit("Associate");
        this.gotoSingleLevelGroupByReportAllFixForVersions();
        this.assertFieldsVisibleEnt();
    }

    public void testFilterIdRequired() {
        this.administration.restoreBlankInstance();
        this.navigation.runReport(10001L, "com.atlassian.jira.plugin.system.reports:singlelevelgroupby");
        this.tester.submit("Next");
        this.text.assertTextPresent("Filter is a required field");
    }

    private void gotoSingleLevelGroupByReportAllFixForVersions() {
        this.navigation.runReport(10001L, "com.atlassian.jira.plugin.system.reports:singlelevelgroupby");
        this.tester.setFormElement("filterid", "10000");
        this.tester.selectOption("mapper", "Fix For Versions (all)");
        this.tester.submit("Next");
    }

    private void assertFieldsVisibleEnt() {
        try {
            WebTable table = this.tester.getDialog().getResponse().getTableWithID("single_groupby_report_table");
            int rowCount = table.getRowCount();
            TestSingleLevelGroupByReport.assertEquals((int)9, (int)rowCount);
            for (int i = 2; i < rowCount; i += 2) {
                TableCell priorityCell = table.getTableCell(i, 4);
                if (i == 8) {
                    this.assertTableCellContainsPriorityIcon(priorityCell);
                } else {
                    this.assertTableCellContainsNoPriorityIcon(priorityCell);
                }
                TableCell resolutioCell = table.getTableCell(i, 2);
                if (i == 8) {
                    TestSingleLevelGroupByReport.assertTrue((boolean)resolutioCell.asText().contains("Unresolved"));
                    continue;
                }
                TestSingleLevelGroupByReport.assertFalse((boolean)resolutioCell.asText().contains("Unresolved"));
            }
        }
        catch (SAXException e) {
            TestSingleLevelGroupByReport.fail((String)("SAX Exception:" + e.getMessage()));
        }
    }

    private void assertFieldsVisible(boolean priorityVisible, boolean resolutionVisible) {
        try {
            WebTable table = this.tester.getDialog().getResponse().getTableWithID("single_groupby_report_table");
            int rowCount = table.getRowCount();
            TestSingleLevelGroupByReport.assertEquals((int)7, (int)rowCount);
            for (int i = 2; i < rowCount; i += 2) {
                TableCell priorityCell = table.getTableCell(i, 4);
                if (priorityVisible) {
                    this.assertTableCellContainsPriorityIcon(priorityCell);
                } else {
                    this.assertTableCellContainsNoPriorityIcon(priorityCell);
                }
                TableCell resolutionCell = table.getTableCell(i, 2);
                if (resolutionVisible) {
                    TestSingleLevelGroupByReport.assertTrue((boolean)resolutionCell.asText().contains("Unresolved"));
                    continue;
                }
                TestSingleLevelGroupByReport.assertFalse((boolean)resolutionCell.asText().contains("Unresolved"));
            }
        }
        catch (SAXException e) {
            TestSingleLevelGroupByReport.fail((String)("SAX Exception:" + e.getMessage()));
        }
    }

    private void assertTableCellContainsPriorityIcon(TableCell tableCell) {
        WebImage[] images = tableCell.getImages();
        TestSingleLevelGroupByReport.assertNotNull((Object)images);
        TestSingleLevelGroupByReport.assertEquals((int)1, (int)images.length);
        WebImage icon = images[0];
        TestSingleLevelGroupByReport.assertTrue((boolean)icon.getSource().contains("/images/icons"));
    }

    private void assertTableCellContainsNoPriorityIcon(TableCell tableCell) {
        WebImage[] images = tableCell.getImages();
        TestSingleLevelGroupByReport.assertTrue((images == null || images.length == 0 ? 1 : 0) != 0);
    }
}

