/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard;

import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.assertions.DashboardAssertions;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.Arrays;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.DASHBOARDS, Category.PERMISSIONS})
public class TestManageDashboardPagePermissions
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("DashboardPagePermissions.xml");
    }

    public void testCleanupOfPermissionsOnProjectDelete() {
        this.administration.project().deleteProject(10010L);
        DashboardAssertions dashboardAssertions = this.assertions.getDashboardAssertions();
        this.navigation.dashboard().navigateToPopular();
        List<SharedEntityInfo> list = Arrays.asList(TestManageDashboardPagePermissions.globalPage(), TestManageDashboardPagePermissions.privatePage(), TestManageDashboardPagePermissions.sharedWithAdmins().setSharingPermissions(TestSharingPermissionUtils.createPrivatePermissions()), TestManageDashboardPagePermissions.sharedWithDevelopers().setSharingPermissions(TestSharingPermissionUtils.createPrivatePermissions()), TestManageDashboardPagePermissions.sharedWithJiraAdmin(), TestManageDashboardPagePermissions.sharedWithJiraDeveloper(), TestManageDashboardPagePermissions.sharedWithJiraUser(), TestManageDashboardPagePermissions.sharedWithProjectAdmins(), TestManageDashboardPagePermissions.sharedWithProjectDevelopers().setSharingPermissions(TestSharingPermissionUtils.createPrivatePermissions()), TestManageDashboardPagePermissions.sharedWithProject(), TestManageDashboardPagePermissions.systemPage());
        dashboardAssertions.assertDashboardPages(list, Dashboard.Table.POPULAR);
        this.navigation.logout();
        this.navigation.login("developer");
        this.navigation.dashboard().navigateToPopular();
        dashboardAssertions.assertDashboardPages(Arrays.asList(TestManageDashboardPagePermissions.globalPage(), TestManageDashboardPagePermissions.sharedWithJiraDeveloper(), TestManageDashboardPagePermissions.sharedWithJiraUser(), TestManageDashboardPagePermissions.sharedWithProject(), TestManageDashboardPagePermissions.systemPage()), Dashboard.Table.POPULAR);
        this.navigation.logout();
        this.navigation.login("fred");
        this.navigation.dashboard().navigateToPopular();
        dashboardAssertions.assertDashboardPages(Arrays.asList(TestManageDashboardPagePermissions.globalPage(), TestManageDashboardPagePermissions.sharedWithJiraUser(), TestManageDashboardPagePermissions.systemPage()), Dashboard.Table.POPULAR);
    }

    public void testCorrectDashboardsOnTabs() {
        DashboardAssertions dashboardAssertions = this.assertions.getDashboardAssertions();
        this.navigation.dashboard().navigateToPopular();
        dashboardAssertions.assertDashboardPages(Arrays.asList(TestManageDashboardPagePermissions.globalPage(), TestManageDashboardPagePermissions.privatePage(), TestManageDashboardPagePermissions.sharedWithAdmins(), TestManageDashboardPagePermissions.sharedWithDevelopers(), TestManageDashboardPagePermissions.sharedWithJiraAdmin(), TestManageDashboardPagePermissions.sharedWithJiraDeveloper(), TestManageDashboardPagePermissions.sharedWithJiraUser(), TestManageDashboardPagePermissions.sharedWithProjectAdmins(), TestManageDashboardPagePermissions.sharedWithProjectDevelopers(), TestManageDashboardPagePermissions.sharedWithProject(), TestManageDashboardPagePermissions.systemPage()), Dashboard.Table.POPULAR);
        this.navigation.logout();
        this.navigation.login("developer");
        this.navigation.dashboard().navigateToPopular();
        dashboardAssertions.assertDashboardPages(Arrays.asList(TestManageDashboardPagePermissions.globalPage(), TestManageDashboardPagePermissions.sharedWithDevelopers(), TestManageDashboardPagePermissions.sharedWithJiraDeveloper(), TestManageDashboardPagePermissions.sharedWithJiraUser(), TestManageDashboardPagePermissions.sharedWithProjectDevelopers(), TestManageDashboardPagePermissions.sharedWithProject(), TestManageDashboardPagePermissions.systemPage()), Dashboard.Table.POPULAR);
        this.navigation.logout();
        this.navigation.login("fred");
        this.navigation.dashboard().navigateToPopular();
        dashboardAssertions.assertDashboardPages(Arrays.asList(TestManageDashboardPagePermissions.globalPage(), TestManageDashboardPagePermissions.sharedWithJiraUser(), TestManageDashboardPagePermissions.systemPage()), Dashboard.Table.POPULAR);
    }

    public void testCleanupOfPermissionsOnRoleDelete() {
        this.navigation.gotoAdmin();
        this.administration.roles().delete(10001L);
        DashboardAssertions dashboardAssertions = this.assertions.getDashboardAssertions();
        this.navigation.dashboard().navigateToPopular();
        dashboardAssertions.assertDashboardPages(Arrays.asList(TestManageDashboardPagePermissions.globalPage(), TestManageDashboardPagePermissions.privatePage(), TestManageDashboardPagePermissions.sharedWithAdmins(), TestManageDashboardPagePermissions.sharedWithDevelopers().setSharingPermissions(TestSharingPermissionUtils.createPrivatePermissions()), TestManageDashboardPagePermissions.sharedWithJiraAdmin(), TestManageDashboardPagePermissions.sharedWithJiraDeveloper(), TestManageDashboardPagePermissions.sharedWithJiraUser(), TestManageDashboardPagePermissions.sharedWithProjectAdmins(), TestManageDashboardPagePermissions.sharedWithProjectDevelopers(), TestManageDashboardPagePermissions.sharedWithProject(), TestManageDashboardPagePermissions.systemPage()), Dashboard.Table.POPULAR);
        this.navigation.logout();
        this.navigation.login("developer");
        this.navigation.dashboard().navigateToPopular();
        dashboardAssertions.assertDashboardPages(Arrays.asList(TestManageDashboardPagePermissions.globalPage(), TestManageDashboardPagePermissions.sharedWithJiraDeveloper(), TestManageDashboardPagePermissions.sharedWithJiraUser(), TestManageDashboardPagePermissions.sharedWithProject(), TestManageDashboardPagePermissions.systemPage()), Dashboard.Table.POPULAR);
        this.navigation.logout();
        this.navigation.login("fred");
        this.navigation.dashboard().navigateToPopular();
        dashboardAssertions.assertDashboardPages(Arrays.asList(TestManageDashboardPagePermissions.globalPage(), TestManageDashboardPagePermissions.sharedWithJiraUser(), TestManageDashboardPagePermissions.systemPage()), Dashboard.Table.POPULAR);
    }

    public void testCleanupOfPermissionsOnGroupDelete() {
        this.administration.usersAndGroups().deleteGroup("jira-developers");
        DashboardAssertions dashboardAssertions = this.assertions.getDashboardAssertions();
        this.navigation.dashboard().navigateToPopular();
        List<SharedEntityInfo> list = Arrays.asList(TestManageDashboardPagePermissions.globalPage(), TestManageDashboardPagePermissions.privatePage(), TestManageDashboardPagePermissions.sharedWithAdmins(), TestManageDashboardPagePermissions.sharedWithDevelopers(), TestManageDashboardPagePermissions.sharedWithJiraAdmin(), TestManageDashboardPagePermissions.sharedWithJiraDeveloper().setSharingPermissions(TestSharingPermissionUtils.createPrivatePermissions()), TestManageDashboardPagePermissions.sharedWithJiraUser(), TestManageDashboardPagePermissions.sharedWithProjectAdmins(), TestManageDashboardPagePermissions.sharedWithProjectDevelopers(), TestManageDashboardPagePermissions.sharedWithProject(), TestManageDashboardPagePermissions.systemPage());
        dashboardAssertions.assertDashboardPages(list, Dashboard.Table.POPULAR);
        this.navigation.logout();
        this.navigation.login("developer");
        this.navigation.dashboard().navigateToPopular();
        dashboardAssertions.assertDashboardPages(Arrays.asList(TestManageDashboardPagePermissions.globalPage(), TestManageDashboardPagePermissions.sharedWithJiraUser(), TestManageDashboardPagePermissions.systemPage()), Dashboard.Table.POPULAR);
        this.navigation.logout();
        this.navigation.login("fred");
        this.navigation.dashboard().navigateToPopular();
        dashboardAssertions.assertDashboardPages(Arrays.asList(TestManageDashboardPagePermissions.globalPage(), TestManageDashboardPagePermissions.sharedWithJiraUser(), TestManageDashboardPagePermissions.systemPage()), Dashboard.Table.POPULAR);
    }

    private static SharedEntityInfo systemPage() {
        return new SharedEntityInfo(10000L, "System Dashboard", null, false, TestSharingPermissionUtils.createPublicPermissions());
    }

    private static SharedEntityInfo globalPage() {
        return new SharedEntityInfo(10011L, "Global", null, false, TestSharingPermissionUtils.createPublicPermissions());
    }

    private static SharedEntityInfo privatePage() {
        return new SharedEntityInfo(10010L, "Private", "Copy of 'System Dashboard'", false, TestSharingPermissionUtils.createPrivatePermissions());
    }

    private static SharedEntityInfo sharedWithAdmins() {
        return new SharedEntityInfo(10016L, "Shared with Admins", null, false, TestSharingPermissionUtils.createProjectPermissions(0L, 0L, "Dev Role Browse", "Administrators"));
    }

    private static SharedEntityInfo sharedWithDevelopers() {
        return new SharedEntityInfo(10015L, "Shared with Developers", null, false, TestSharingPermissionUtils.createProjectPermissions(0L, 0L, "Dev Role Browse", "Developers"));
    }

    private static SharedEntityInfo sharedWithJiraAdmin() {
        return new SharedEntityInfo(10014L, "Shared with jira-admin", null, false, TestSharingPermissionUtils.createGroupPermissions("jira-administrators"));
    }

    private static SharedEntityInfo sharedWithJiraDeveloper() {
        return new SharedEntityInfo(10013L, "Shared with jira-developer", null, false, TestSharingPermissionUtils.createGroupPermissions("jira-developers"));
    }

    private static SharedEntityInfo sharedWithJiraUser() {
        return new SharedEntityInfo(10012L, "Shared with jira-user", null, false, TestSharingPermissionUtils.createGroupPermissions("jira-user"));
    }

    private static SharedEntityInfo sharedWithProjectAdmins() {
        return new SharedEntityInfo(10019L, "Shared with proj Admins", null, false, TestSharingPermissionUtils.createProjectPermissions(0L, 0L, "Admin Role Browse", null));
    }

    private static SharedEntityInfo sharedWithProjectDevelopers() {
        return new SharedEntityInfo(10018L, "Shared with proj Developers", null, false, TestSharingPermissionUtils.createProjectPermissions(0L, 0L, "Dev Role Browse", null));
    }

    private static SharedEntityInfo sharedWithProject() {
        return new SharedEntityInfo(10017L, "Shared with Proj jira-dev", null, false, TestSharingPermissionUtils.createProjectPermissions(0L, 0L, "monkey", null));
    }
}

