/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.DASHBOARDS})
public class TestDashboardDeleteConfirm
extends FuncTestCase {
    private static final int EXISTING_DASHBOARD_ID = 10010;
    private static final int NOT_EXISTING_DASHBOARD_ID = 666;

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestDeleteConfirmDashboard.xml");
    }

    public void testRestoreDefaultDashboardPortalPagesFavouritedByOthers() throws Exception {
        this.navigation.dashboard().navigateToMy();
        this.tester.clickLink("restore_defaults");
        XPathLocator locator = new XPathLocator(this.tester, "//span[@id='othersFavouritedPortalPages']");
        this.text.assertTextSequence(locator, new String[]{"3rd Dashboard", "(2 Users)"});
        this.text.assertTextSequence(locator, new String[]{"Dashboard for Administrator", "(1 User)"});
        this.navigation.dashboard().favouriteDashboard(10031L);
        this.navigation.dashboard().unFavouriteDashboard(10010L);
        this.navigation.dashboard().navigateToMy();
        this.tester.clickLink("restore_defaults");
        locator = new XPathLocator(this.tester, "//span[@id='othersFavouritedPortalPages']");
        this.text.assertTextSequence(locator, new String[]{"3rd Dashboard", "(2 Users)"});
        this.text.assertTextSequence(locator, new String[]{"Dashboard for Administrator", "(1 User)"});
        this.navigation.logout();
        this.navigation.login("user3");
        this.navigation.dashboard().favouriteDashboard(10010L);
        this.navigation.logout();
        this.navigation.login("admin");
        this.navigation.dashboard().navigateToMy();
        this.tester.clickLink("restore_defaults");
        locator = new XPathLocator(this.tester, "//span[@id='othersFavouritedPortalPages']");
        this.text.assertTextSequence(locator, new String[]{"3rd Dashboard", "(2 Users)"});
        this.text.assertTextSequence(locator, new String[]{"Dashboard for Administrator", "(2 Users)"});
        this.navigation.dashboard().navigateToMy();
        this.tester.clickLink("delete_3");
        this.tester.submit("Delete");
        this.navigation.dashboard().navigateToMy();
        this.tester.clickLink("delete_1");
        this.tester.submit("Delete");
        this.navigation.dashboard().navigateToMy();
        this.tester.clickLink("restore_defaults");
        locator = new XPathLocator(this.tester, "//span[@id='othersFavouritedPortalPages']");
        TestDashboardDeleteConfirm.assertNull((Object)locator.getNode());
    }

    public void testDeleteConfirm() {
        this.navigation.dashboard().navigateToMy();
        this.tester.clickLink("restore_defaults");
        XPathLocator locator = new XPathLocator(this.tester, "//span[@id='othersFavouritedPortalPages']");
        this.text.assertTextSequence(locator, new String[]{"3rd Dashboard", "(2 Users)"});
        this.text.assertTextSequence(locator, new String[]{"Dashboard for Administrator", "(1 User)"});
        this.navigation.dashboard().navigateToMy();
        this.tester.clickLink("delete_3");
        locator = new XPathLocator(this.tester, "//p[@id='otherFavouriteCount']");
        TestDashboardDeleteConfirm.assertEquals((String)"There is 1 other person who has added this dashboard as a favourite.", (String)locator.getText().trim());
        this.tester.submit("Delete");
        this.navigation.dashboard().navigateToMy();
        this.tester.clickLink("restore_defaults");
        locator = new XPathLocator(this.tester, "//span[@id='othersFavouritedPortalPages']");
        this.text.assertTextSequence(locator, new String[]{"3rd Dashboard", "(2 Users)"});
        this.navigation.dashboard().navigateToMy();
        this.tester.clickLink("delete_0");
        locator = new XPathLocator(this.tester, "//p[@id='otherFavouriteCount']");
        TestDashboardDeleteConfirm.assertNull((Object)locator.getNode());
        this.tester.submit("Delete");
        this.navigation.dashboard().navigateToMy();
        this.tester.clickLink("restore_defaults");
        locator = new XPathLocator(this.tester, "//span[@id='othersFavouritedPortalPages']");
        this.text.assertTextSequence(locator, new String[]{"3rd Dashboard", "(2 Users)"});
        this.navigation.dashboard().navigateToMy();
        this.tester.clickLink("delete_1");
        locator = new XPathLocator(this.tester, "//p[@id='otherFavouriteCount']");
        TestDashboardDeleteConfirm.assertNull((Object)locator.getNode());
        this.tester.submit("Delete");
        this.navigation.dashboard().navigateToMy();
        this.tester.clickLink("restore_defaults");
        locator = new XPathLocator(this.tester, "//span[@id='othersFavouritedPortalPages']");
        this.text.assertTextSequence(locator, new String[]{"3rd Dashboard", "(2 Users)"});
        this.navigation.dashboard().navigateToMy();
        this.tester.clickLink("delete_0");
        locator = new XPathLocator(this.tester, "//p[@id='otherFavouriteCount']");
        TestDashboardDeleteConfirm.assertEquals((String)"There are 2 other people who have added this dashboard as a favourite.", (String)locator.getText().trim());
        this.tester.submit("Delete");
        this.navigation.dashboard().navigateToMy();
        this.tester.clickLink("restore_defaults");
        locator = new XPathLocator(this.tester, "//span[@id='othersFavouritedPortalPages']");
        TestDashboardDeleteConfirm.assertNull((Object)locator.getNode());
    }

    public void testDeleteConfirmPlainPage() {
        this.shouldNotDeleteDashboardGivenCancelOnConfirmation();
        this.shouldDeleteDashboardGivenSubmitOnConfirmation();
        this.shouldDisplayErrorGivenNotExistingDashboard();
    }

    private void shouldNotDeleteDashboardGivenCancelOnConfirmation() {
        this.goToPlainDeleteDashboardConfirm(10010);
        this.assertDeleteConfirmNoError();
        this.cancelDeleteConfirmation();
        this.assertOnManageDashboards();
        this.assertDashboardExists(10010);
    }

    private void shouldDeleteDashboardGivenSubmitOnConfirmation() {
        this.goToPlainDeleteDashboardConfirm(10010);
        this.assertDeleteConfirmNoError();
        this.submitDeleteConfirmation();
        this.assertOnManageDashboards();
        this.assertDashboardDoesNotExist(10010);
    }

    private void shouldDisplayErrorGivenNotExistingDashboard() {
        this.goToPlainDeleteDashboardConfirm(666);
        this.assertDeleteConfirmError("Dashboard does not exist.");
    }

    private void goToPlainDeleteDashboardConfirm(int dashboardId) {
        this.navigation.gotoPage("secure/DeletePortalPage!default.jspa?pageId=" + dashboardId);
    }

    private void assertDeleteConfirmNoError() {
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-message.info"), "Confirm that you want to delete this Dashboard.");
        this.assertions.assertNodeByIdExists("delete-portal-page-submit");
        this.assertions.assertNodeByIdExists("delete-portal-page-cancel");
    }

    private void assertDeleteConfirmError(String errorMsg) {
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-message.error"), errorMsg);
        this.assertions.assertNodeByIdDoesNotExist("delete-portal-page-submit");
        this.assertions.assertNodeByIdDoesNotExist("delete-portal-page-cancel");
    }

    private void cancelDeleteConfirmation() {
        this.tester.clickLink("delete-portal-page-cancel");
    }

    private void submitDeleteConfirmation() {
        this.tester.submit("Delete");
    }

    private void assertOnManageDashboards() {
        this.assertions.assertNodeHasText("//header//h1", "Manage Dashboards");
    }

    private void assertDashboardExists(int dashboardId) {
        this.assertions.assertNodeExists(this.dashboardRowLocator(dashboardId));
    }

    private void assertDashboardDoesNotExist(int dashboardId) {
        this.assertions.assertNodeDoesNotExist(this.dashboardRowLocator(dashboardId));
    }

    private String dashboardRowLocator(int dashboardId) {
        return String.format("//tr[@id='pp_%d']", dashboardId);
    }
}

