/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.CUSTOM_FIELDS, Category.FIELDS})
public class TestTranslateCustomField
extends FuncTestCase {
    public static final String NAME_EN = "MY TEXT FIELD";
    public static final String NAME_FR = "Mon champ de texte";
    public static final String METTRE_A_JOUR = "Mettre \u00e0 jour";

    public void testEditFieldConfigurations() throws Exception {
        this.administration.restoreData("TestTranslateCustomField.xml");
        this.backdoor.userProfile().changeUserLanguage("admin", "fr_FR");
        this.assertFieldDescription("homosapien", "Bogue", "The default description of MY TEXT FIELD", NAME_EN);
        this.assertFieldDescription("monkey", "Bogue", "A customised description for Monkey", NAME_EN);
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("translate_customfield_10000");
        this.tester.setFormElement("description", "Une nouvelle description");
        this.tester.submit(METTRE_A_JOUR);
        this.assertFieldDescription("homosapien", "Bogue", "Une nouvelle description", NAME_EN);
        this.assertFieldDescription("monkey", "Bogue", "A customised description for Monkey", NAME_EN);
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("translate_customfield_10000");
        this.tester.setFormElement("name", NAME_FR);
        this.tester.submit(METTRE_A_JOUR);
        this.assertFieldDescription("homosapien", "Bogue", "Une nouvelle description", NAME_FR);
        this.assertFieldDescription("monkey", "Bogue", "A customised description for Monkey", NAME_FR);
        this.backdoor.userProfile().changeUserLanguage("admin", "en_UK");
        this.assertFieldDescription("homosapien", "Bug", "The default description of MY TEXT FIELD", NAME_EN);
        this.assertFieldDescription("monkey", "Bug", "A customised description for Monkey", NAME_EN);
        this.backdoor.userProfile().changeUserLanguage("admin", "de_DE");
        this.assertFieldDescription("homosapien", "Bug", "The default description of MY TEXT FIELD", NAME_EN);
        this.assertFieldDescription("monkey", "Bug", "A customised description for Monkey", NAME_EN);
        this.backdoor.userProfile().changeUserLanguage("admin", "fr_FR");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("translate_customfield_10000");
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("description", "");
        this.tester.submit(METTRE_A_JOUR);
        this.assertFieldDescription("homosapien", "Bogue", "The default description of MY TEXT FIELD", NAME_EN);
        this.assertFieldDescription("monkey", "Bogue", "A customised description for Monkey", NAME_EN);
        this.backdoor.userProfile().changeUserLanguage("admin", "en_UK");
    }

    private void editDescription(String fieldConfigName, String description) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
        this.tester.clickLink("configure-" + fieldConfigName);
        this.tester.clickLink("edit_10");
        this.tester.setFormElement("description", description);
        this.tester.submit("Update");
    }

    private void assertFieldDescription(String projectName, String issueType, String description, String name) {
        String key = this.navigation.issue().createIssue(projectName, issueType, "Summary");
        this.navigation.issue().viewIssue(key);
        this.tester.clickLink("edit-issue");
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{name, description});
    }

    private void assertNoFieldDescription(String projectName, String issueType, String oldDescription) {
        String key = this.navigation.issue().createIssue(projectName, issueType, "Summary");
        this.navigation.issue().viewIssue(key);
        this.tester.clickLink("edit-issue");
        this.text.assertTextPresent(new WebPageLocator(this.tester), NAME_EN);
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), oldDescription);
    }

    private static class Data {
        private Data() {
        }

        static class IssueTypes {
            IssueTypes() {
            }

            static class Bug {
                Bug() {
                }

                static String id() {
                    return "1";
                }
            }
        }
    }
}

