/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.backdoor.ManagedConfigurationControl;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.CUSTOM_FIELDS, Category.FIELDS})
public class TestManagedCustomFields
extends FuncTestCase {
    private static final Long MY_TEXT_FIELD_ID_LONG = 10000L;
    private static final String MY_TEXT_FIELD_ID = "customfield_" + MY_TEXT_FIELD_ID_LONG;
    private static final String MY_TEXT_FIELD_NAME = "MY TEXT FIELD";

    public void testManagedCustomField() throws Exception {
        this.administration.restoreData("TestEditCustomFieldDescription.xml");
        ManagedConfigurationControl managedConfiguration = this.backdoor.managedConfiguration();
        ManagedConfigurationControl.ManagedEntity managedCustomField = managedConfiguration.getManagedCustomField(MY_TEXT_FIELD_ID);
        TestManagedCustomFields.assertFalse((String)"Custom field should not be locked", (boolean)managedCustomField.isLocked());
        TestManagedCustomFields.assertFalse((String)"Custom field should not be managed", (boolean)managedCustomField.isManaged());
        this.verifyCustomField(false, false);
        managedCustomField = managedConfiguration.postManagedCustomField(MY_TEXT_FIELD_ID, true, false);
        TestManagedCustomFields.assertFalse((String)"Custom field should not be locked", (boolean)managedCustomField.isLocked());
        TestManagedCustomFields.assertTrue((String)"Custom field should be managed", (boolean)managedCustomField.isManaged());
        this.verifyCustomField(true, false);
        managedCustomField = managedConfiguration.postManagedCustomField(MY_TEXT_FIELD_ID, true, true);
        TestManagedCustomFields.assertTrue((String)"Custom field should be locked", (boolean)managedCustomField.isLocked());
        TestManagedCustomFields.assertTrue((String)"Custom field should be managed", (boolean)managedCustomField.isManaged());
        this.verifyCustomField(true, true);
    }

    private void verifyCustomField(boolean isManaged, boolean isLocked) {
        this.navigation.gotoCustomFields();
        TableCellLocator locator = new TableCellLocator(this.getTester(), "custom-fields", 1, 0);
        this.assertions.getTextAssertions().assertTextPresent(locator, MY_TEXT_FIELD_NAME);
        if (isLocked) {
            this.assertions.getTextAssertions().assertTextPresent(locator, "Locked");
            this.assertions.assertNodeByIdDoesNotExist("edit_MY TEXT FIELD");
            this.assertions.assertNodeByIdDoesNotExist("del_" + MY_TEXT_FIELD_ID);
            this.assertions.getLinkAssertions().assertLinkByIdHasExactText("config_" + MY_TEXT_FIELD_ID, "View");
            this.tester.gotoPage("/secure/admin/EditCustomField!default.jspa?id=" + MY_TEXT_FIELD_ID_LONG);
            this.assertions.getJiraMessageAssertions().assertHasMessage("You cannot edit field 'MY TEXT FIELD' as it is locked.");
            this.assertions.assertNodeByIdDoesNotExist("update_submit");
        } else if (isManaged) {
            this.assertions.getTextAssertions().assertTextPresent(locator, "Managed");
            this.assertions.assertNodeByIdExists("edit_MY TEXT FIELD");
            this.assertions.assertNodeByIdExists("del_" + MY_TEXT_FIELD_ID);
            this.assertions.getLinkAssertions().assertLinkByIdHasExactText("config_" + MY_TEXT_FIELD_ID, "Configure");
            this.tester.gotoPage("/secure/admin/EditCustomField!default.jspa?id=" + MY_TEXT_FIELD_ID_LONG);
            this.assertions.assertNodeByIdExists("update_submit");
        } else {
            this.assertions.getTextAssertions().assertTextNotPresent(locator, "Managed");
            this.assertions.getTextAssertions().assertTextNotPresent(locator, "Locked");
        }
    }
}

